// LabPlot : PlotGRASS.cc

#include <stdlib.h>
#include <iostream>
#include <klocale.h>
#include <kdebug.h>

#include "PlotGRASS.h"

#ifdef HAVE_GRASS
#include "../GRASSQt/GRASSPainter.h"
#include "../GRASSQt/GRASSVectorLayer.h"
#endif

using namespace std;

PlotGRASS::PlotGRASS(Worksheet *p)
	: Plot(p) 
{
	title = new Label(i18n("GRASS-Plot"),QFont("Adobe Times",22),QColor(Qt::black));
	title->setPosition(0.4,0.04);

#ifdef HAVE_GRASS
	gisbase = QString(getenv("GRASS_DIR"))+QString("/dist.i686-pc-linux-gnu");
	gisrc = QString(getenv("HOME"))+QString("/.grassrc5");
	location = QString("spearfish");
#endif
}

QStringList PlotGRASS::Info() {
	QStringList s;
	s<<"GRASS";
	s<<QString::number(position.X())+QString(" , ")+QString::number(position.Y());
	s<<QString::number(size.X())+QString(" X ")+QString::number(size.Y());
	if (transparent)
		s<<QString("yes");
	else
		s<<QString("no");
	s<<bgcolor.name();
	s<<gbgcolor.name();

	return s;
}

void PlotGRASS::draw(QPainter *p,int w, int h) {
	//const int gap = 10;

	//int w = worksheet->width(), h = worksheet->height();

	kdDebug()<<"PlotGRASS::draw() w/h : "<<w<<' '<<h<<endl;
	int xmin = (int)(w*(size.X()*p1.X()+position.X()));
	int xmax = (int)(w*(size.X()*p2.X()+position.X()));
	int ymin = (int)(h*(size.Y()*p1.Y()+position.Y()));
	int ymax = (int)(h*(size.Y()*p2.Y()+position.Y()));

	kdDebug()<<"XMIN/MXAX/YMIN/YMAX = "<<xmin<<','<<xmax<<','<<ymin<<','<<ymax<<endl;
	kdDebug()<<"p1 = "<<p1.X()<<'/'<<p1.Y()<<" p2 = "<<p2.X()<<'/'<<p2.Y()<<endl;

	// background color
	p->setBrush(bgcolor);
	p->setPen(Qt::NoPen);
	p->drawRect((int)(w*position.X()),(int)(h*position.Y()),(int)(w*size.X()),(int)(h*size.Y()));

	// graph background color
	p->setBrush(gbgcolor);
	//TEST : p->setBrush(Qt::green);
	p->setPen(Qt::NoPen);

	kdDebug()<<"PLOTGRASS : title->draw() pos:"<<position.X()<<' '<<position.Y()<<endl;
	kdDebug()<<" 			size:"<<size.X()<<' '<<size.Y()<<endl;
	title->draw(p,position,size,w,h);

	drawCurves(p,w,h);

	if(legend.enabled())
		legend.draw(p,type,graphlist,position,size,w,h);
}

void PlotGRASS::drawCurves(QPainter *p, int w, int h) {
	kdDebug()<<"PlotGRASS::drawCurves()"<<endl;
	//const int w = worksheet->width();
	//const int h = worksheet->height();
	int xmin = (int)(w*(size.X()*p1.X()+position.X()));
	int xmax = (int)(w*(size.X()*p2.X()+position.X()));
	int ymin = (int)(h*(size.Y()*p1.Y()+position.Y()));
	int ymax = (int)(h*(size.Y()*p2.Y()+position.Y()));

	kdDebug()<<"xmin/xmax ymin/ymax : "<<xmin<<'/'<<xmax<<' '<<ymin<<'/'<<ymax<<endl;
	kdDebug()<<"width/height : "<<w<<'/'<<h<<endl;

	kdDebug()<<"GISBASE : "<<gisbase<<endl;
	kdDebug()<<"GISRC : "<<gisrc<<endl;
	setenv("GISBASE",gisbase.latin1(),1);
	setenv("GISRC",gisrc.latin1(),1);

#ifdef HAVE_GRASS
	//GRASSPainter gPainter((char *) g->getLOC().latin1());
	GRASSPainter gPainter((char *)location.latin1());

	for (unsigned int i=0; i < graphlist->getNumber() ; i++) {
		if(graphlist->getGraph(i)->isShown() == FALSE)
			continue;
		
		GraphGRASS *g = graphlist->getGraphGRASS(i);
		Style style = g->getStyle();
		LType type = g->getType();

		if (type == LRASTER) {
			// TODO : Raster Layer
		}
		else if (type == LVECTOR) {
			GRASSVectorLayer* vecLayer = new GRASSVectorLayer(&gPainter,
				(char *)g->getLayer().latin1(), "");
			vecLayer->drawMode((GRASSVectorLayer::DrawMode) style.isFilled());
			vecLayer->penColor(style.Color());
			vecLayer->fillColor(style.FillColor());
			gPainter.addLayer(vecLayer);
		}
		else if (type == LSITE) {
			// TODO : Site Layer
		}

	}

	QRect rect(xmin,ymin,xmax-xmin,ymax-ymin);
	gPainter.paint(rect, p);
#endif
}
