//LabPlot : MainWin.h

#ifndef MAINWIN_H
#define MAINWIN_H

#include <qstring.h>
#include <qfont.h>
#include <qlistbox.h>
#include <qworkspace.h>
#include <qtoolbutton.h>
#include <qsignalmapper.h>
#include <qdragobject.h>
#include <qtimer.h>
#include <kapp.h>
#include <kmainwindow.h>
#include <kparts/mainwindow.h>
#include <kaction.h>
#include <kkeydialog.h>
#include <kstatusbar.h>
#include <kstandarddirs.h>
#include <kmenubar.h>
#include "GraphList.h"
#include "Worksheet.h"
#include "Project.h"

extern "C" double parse(char[]);

class MainWin
	: public KParts::MainWindow
{
	Q_OBJECT
private:
	void New();
	void readConfig();
	void enableAutosave(bool as);
	void newDialog(bool d, PType type);	// interface to all data and function dialogs
	void newPlot(PType type);			// interface to all new plot functions
	class Worksheet *activeWorksheet() { return (Worksheet *)ws->activeWindow(); }
	QWorkspace* ws;
	QString filename;
	KParts::ReadOnlyPart* gvpart;
	QPtrList<KAction> worksheetsActions;
	QSignalMapper *sm;
	KConfig *config;
	KRecentFilesAction* recent;
	KAction *configureAction, *project_action, *explorer_action;
	KAction *export_image, *export_svg, *export_pic, *export_pstoedit, *export_ImageMagick;
	KAction *print_action, *save_action, *save_as;
	KAction *graph_list, *clear_action, *close_action, *worksheet, *plot, *arrange, *overlay;
	KAction *deleteplot, *newgrassplot, *grassdata, *newvtkplot, *vtkdata;
	KAction *smooth, *prune, *average, *hist, *interpolation, *differences, *integration, *regression, *fft, *convolution, *fit;
	KAction *axes, *title, *legend, *objects;
	KAction *asx, *asy, *asz, *asall, *maglens, *panzoom, *sl, *sr, *su, *sd, *sxu, *sxd, *syu, *syd, *szu, *szd;
	KAction *baseline, *region, *label, *line, *rect, *ellipse, *image;
	KToggleAction *menubar, *toolbar, *sidetoolbar, *analysistoolbar, *drawingtoolbar, *statusbar;
	KToggleAction *printpreview;
	Project *project;
	QTimer *autosaveTimer;
	bool autosave;
	long autosaveinterval;
	bool modified;
private slots:
	void open();
	void open(const KURL& url);
	void save();
	void saveAs();
	void projectInfo();
	void projectExplorer();
	void clear();
	void closeWin();
	void setWinFocus(int i) { (ws->windowList()).at(i)->setFocus(); }

	void toggleFullScreen();
	void toggleMenuBar();
	void toggleToolBar();
	void toggleSideToolBar();
	void toggleAnalysisToolBar();
	void toggleDrawingToolBar();
	void toggleStatusBar();
	void configure();
	void configureKeys() { KKeyDialog::configure(actionCollection(), this, true); }
	void configureToolbars();
	void saveSettings();
	void setAutosaveInterval(long interval) { autosaveinterval=interval;}

	void new2DPlot() { newPlot(P2D); }
	void newSurfacePlot() { newPlot(PSURFACE); }
	void new3DPlot() { newPlot(P3D); }
	void newPiePlot() { newPlot(PPIE); }
	void newPolarPlot() { newPlot(PPOLAR); }
	void newTernaryPlot() { newPlot(PTERNARY); }
	void newGRASSPlot() { newPlot(PGRASS); }
	void newVTKPlot() { newPlot(PVTK); }
	void deletePlot();
	class Worksheet* newWorksheet();
	void setActiveWorksheet(int i) { ws->windowList().at(i)->showMaximized(); }
	void aboutKDE();
	void reportBug();
	void exampleAxesLabel() { openfile(locate("data", QString("LabPlot/axeslabel.lpl.gz"))); }
	void exampleAnalysis() { openfile(locate("data", QString("LabPlot/analysis.lpl.gz"))); }
	void exampleSurface() { openfile(locate("data", QString("LabPlot/surface.lpl.gz"))); }
	void example3d() { openfile(locate("data", QString("LabPlot/3d.lpl.gz"))); }
	void exampleRydberg() { openfile(locate("data", QString("LabPlot/rydberg.lpl.gz"))); }
	void exampleLog() { openfile(locate("data", QString("LabPlot/log.lpl.gz"))); }
	void exampleFFT() { openfile(locate("data", QString("LabPlot/fft.lpl.gz"))); }
	void exampleObjects() { openfile(locate("data", QString("LabPlot/objects.lpl.gz"))); }
	void exampleHist() { openfile(locate("data", QString("LabPlot/hist.lpl.gz"))); }
	void exampleFit() { openfile(locate("data", QString("LabPlot/fit.lpl.gz"))); }
	void exampleImage() { openfile(locate("data", QString("LabPlot/image.lpl.gz"))); }
	void examplePie() { openfile(locate("data", QString("LabPlot/pie.lpl.gz"))); }
	void exampleExponentialFit() { openfile(locate("data", QString("LabPlot/exponential_fit.lpl.gz"))); }
	void exampleMultiplot() { openfile(locate("data", QString("LabPlot/multiplot.lpl.gz"))); }
	void exampleGrass() { openfile(locate("data", QString("LabPlot/grass.lpl.gz"))); }
	void exampleSurface2() { openfile(locate("data", QString("LabPlot/surface2.lpl.gz"))); }
	void examplePolar() { openfile(locate("data", QString("LabPlot/polar.lpl.gz"))); }
	void exampleTernary() { openfile(locate("data", QString("LabPlot/ternary.lpl.gz"))); }
	void exampleAudio() { openfile(locate("data", QString("LabPlot/audio.lpl.gz"))); }
public slots:
	void updateWorksheetList();
	void exportPlot();
	void exportSVG();
	void exportPIC();
	void exportPstoedit();
	void exportImageMagick();
	void print();
	void printPreview();
	void graphs();
	
	void new2DData() { newDialog(0,P2D); }
	void newSData() { newDialog(0,PSURFACE); }
	void new3DData() { newDialog(0,P3D); }
	void newPieData() { newDialog(0,PPIE); }
	void newPolarData() { newDialog(0,PPOLAR); }
	void newTernaryData() { newDialog(0,PTERNARY); }
	void newGRASSData() { newDialog(0,PGRASS); }
	void newVTKData() { newDialog(0,PVTK); }
	void new2DFunction() { newDialog(1,P2D);  }
	void new3DFunction() {newDialog(1,P3D); }
	void newSFunction() { newDialog(1,PSURFACE); }
	void newPolarFunction() {newDialog(1,PPOLAR); }
	
	void smoothDialog();
	void averageDialog();
	void pruneDialog();
	void histDialog();
	void interpolationDialog();
	void differencesDialog();
	void integrationDialog();
	void regressionDialog();
	void fftDialog();
	void convolutionDialog();
	void fitDialog();

	void arrangeDialog();
	void overlayDialog();
	void worksheetDialog();
	void graphDialog();
	void axesDialog();
	void titleDialog();
	void legendDialog();
	void objectDialog();

	void autoScaleX();
	void autoScaleY();
	void autoScaleZ();
	void autoScaleAll();
	void magLens();
	void panZoom();
	void shiftLeft();
	void shiftRight();
	void shiftUp();
	void shiftDown();
	void scaleXUp();
	void scaleXDown();
	void scaleYUp();
	void scaleYDown();
	void scaleZUp();
	void scaleZDown();

	void defineRegion();
	void defineBaseline();
	void defineLine();
	void defineLabel();
	void defineRect();
	void defineEllipse();
	void defineImage();
public:
	MainWin(const char *name,const char *filen);
	void replot();
	void openfile(QString file);
	void message(QString msg) {statusBar()->message(msg); }
	KConfig* getConfig() { return config; }
	int defining_region, defining_line, defining_rect, defining_ellipse;	// value = 0-not,1-left,2-right line
	int defining_maglens,defining_panzoom;						// dto.
	bool defining_baseline,defining_label,defining_image;
	Project *getProject() { return project; }
	void setProject(Project *p) { project=p; }
	QWorkspace *getWorkspace() { return ws; }
	void deleteActiveWorksheet();
	void setModified() {modified = true;}
protected:
	void resizeEvent(QResizeEvent *e) { this->resize(e->size()); }
	void dragEnterEvent(QDragEnterEvent *e) { e->accept(QTextDrag::canDecode(e)); }
	void dropEvent(QDropEvent *e);
	void closeEvent(QCloseEvent *e);
	void mouseDoubleClickEvent(QMouseEvent *e) { if(!menuBar()->isVisible()) menuBar()->show(); }

};

#endif //MAINWIN_H
