// LabPlot : LabPlotSplash.cc
#include <qpixmap.h>
#include <qapplication.h>
#include <kstandarddirs.h>

#include "LabPlotSplash.h"

/***************************************************************************/
LabPlotSplash::LabPlotSplash(const QString &PNGImageFileName)
    :QWidget(0, "LabPlot Splash", WStyle_NoBorder | WStyle_StaysOnTop |
    WStyle_Customize), m_timer()
{
    QString file = locate("appdata", PNGImageFileName);
    QPixmap pixmap(file);

    // the size of the splashscreen image
    int h = pixmap.width(), l = pixmap.height();

    // center the image on the desktop
    setGeometry(QApplication::desktop()->width ()/2-(h/2), QApplication::desktop()->height()/2-(l/2), h, l);
    setFixedSize(h, l);

    setPaletteBackgroundPixmap(pixmap);

    // auto-close in 2 seconds...
    connect(&m_timer, SIGNAL(timeout()), this, SLOT(deleteLater()));
    m_timer.start(2000, true);
}
