//LabPlot : ImageMagickDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfiledialog.h>
#include <klocale.h>
#include <ktempfile.h>
#include <kprocess.h>
#include <kmessagebox.h>
#include "ImageMagickDialog.h"

using namespace std;

#ifdef HAVE_MAGICK
#include <list>
#include "Magick++.h"
using namespace Magick;
#endif

ImageMagickDialog::ImageMagickDialog(Worksheet *p, const char *name)
	: Dialog(p, name), p(p)
{
	setCaption(i18n("Export via ImageMagick"));

	QHBox *hb = new QHBox(vbox);
	new QLabel(i18n("Export to : "),hb);
	format = new KComboBox(hb);
	QObject::connect(format,SIGNAL(activated (int)),SLOT(updateFilename(int)));

#ifdef HAVE_MAGICK
        QStringList formatlist;

	list<CoderInfo> coderList;
	coderInfoList( &coderList,CoderInfo::AnyMatch,CoderInfo::TrueMatch,CoderInfo::AnyMatch);
	list<CoderInfo>::iterator entry = coderList.begin();
	while( entry != coderList.end() )  {
		formatlist<<QString(entry->name().c_str())+QString(" : (")+QString(entry->description().c_str())+')';
		formats<<QString(entry->name().c_str());
			//kdDebug()<<QString(entry->name().c_str())+" : ("+QString(entry->description().c_str())+")"<<endl;
		entry++;
	}
        format->insertStringList(formatlist);
	format->setCurrentItem(0);
#endif
	hb = new QHBox(vbox);
	new QLabel(i18n("File : "),hb);
	filele = new KLineEdit(QString("out.8bim"),hb);
	KPushButton *newFile = new KPushButton(i18n("Browse..."),hb);
	QObject::connect(newFile,SIGNAL(clicked()),SLOT(selectFile()));

	hb = new QHBox(vbox);
        new QLabel(i18n("Size : "),hb);
        xle = new KLineEdit(QString("800"),hb);
	xle->setValidator(new QIntValidator(xle));
        new QLabel(QString(" x "),hb);
        yle = new KLineEdit(QString("600"),hb);
	yle->setValidator(new QIntValidator(yle));
        new QLabel(i18n(" Rotation : "),hb);
        rotle = new KLineEdit(QString("0"),hb);
	rotle->setValidator(new QDoubleValidator(-360,360,2,rotle));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	int sizex = vbox->minimumSizeHint().width();
	int sizey = vbox->minimumSizeHint().height()+gbox->minimumSizeHint().height();
	setMinimumSize(sizex,sizey);
	resize(sizex,sizey);
}

//! slot for "format" combobox
void ImageMagickDialog::updateFilename(int index) {
	QString filename =  filele->text();
        filename.replace( QRegExp(QString("[.]+.*")), "." + formats[index].lower() );
        filele->setText(filename);
}

void ImageMagickDialog::selectFile() {
	QString filename = QFileDialog::getSaveFileName( QString::null, "*." + formats[format->currentItem()].lower(), this );
	if ( filename )
		filele->setText(filename);
	// change extension
	updateFilename(format->currentItem());
}

void ImageMagickDialog::apply_clicked() {
	// check if file exists
	if ( QFile::exists(filele->text()) ) {
		int answer = KMessageBox::warningYesNoCancel( this, 
			i18n( "Overwrite\n\'%1\'?" ).arg( filele->text() ), i18n("Export via ImageMagick"));
		if (answer != KMessageBox::Yes)
			return;
	}

	KTempFile *tmpfile = new KTempFile(QString::null,".ps");
	tmpfile->setAutoDelete(true);
	QString filename = tmpfile->name();
	if (p)  p->Print(filename);

#ifdef HAVE_MAGICK
	kdDebug()<<"exporting via ImageMagick to "<<formats[format->currentItem()]<<endl;
	Magick::Image image;
	kdDebug()<<"read postscript file"<<endl;
	image.read(filename.latin1());
	Geometry geometry(xle->text().toInt(),yle->text().toInt());
	kdDebug()<<"apply zoom"<<endl;
	image.zoom(geometry);
	kdDebug()<<"rotate"<<endl;
	image.rotate(rotle->text().toDouble());
	image.magick(formats[format->currentItem()].latin1());
	kdDebug()<<"writing "<<filele->text()<<endl;
	// TODO : crash if ImageMagick cant export to this format
	image.write(filele->text().latin1());
#else
	KMessageBox::warningContinueCancel(this,i18n("Sorry. Your Installation doesn't support ImageMagick!"));
#endif
	kdDebug()<<"export OK"<<endl;
	tmpfile->close();
}
