//LabPlot : Image.h

#ifndef IMAGE_H
#define IMAGE_H

#include <qcolor.h>
#include <qpainter.h>
#include <qstringlist.h>
#include "Point.h"

class Image
{
public:
	Image(Point p=0, QString n="", double s=1.0, double a=0);
	QStringList Info();
	void save(QTextStream *t);
	void open(QTextStream *t,int version);
	Point getPos() { return pos; }
	void setPos(double x, double y) { pos=Point(x,y);}
	QString getName() { return name; }
	double getScale() { return scale; }
	double getAngle() { return angle; }
	void draw(QPainter *p, double w, double h);
	bool inside(int x, int y, int w, int h);
protected:
	Point pos;
	QString name;
	double scale;
	double angle;
};

#endif //IMAGE_H
