//LabPlot : GraphM.cc

#include <stdlib.h>
#include <iostream>
#include <qimage.h>
#include <kdebug.h>
#include "GraphM.h"

using namespace std;

GraphM::GraphM(QString n, QString l, LRange r[3],int t, Style st,
		Symbol sy, double *a,int dimx, int dimy, bool s)
	: Graph(n,l,t,st,sy,dimx*dimy,s)
{
	range = new LRange[3];

	if (r) {
		kdDebug()<<"Range : "<<r[0].Min()<<' '<<r[0].Max()<<endl;
		kdDebug()<<"Range : "<<r[1].Min()<<' '<<r[1].Max()<<endl;
		kdDebug()<<"Range : "<<r[2].Min()<<' '<<r[2].Max()<<endl;
	}
	//kdDebug()<<"NX = "<<dimx<<" / NY = "<<dimy<<endl;

	if(r) {
		range[0].setMin(r[0].Min());
		range[0].setMax(r[0].Max());
		range[1].setMin(r[1].Min());
		range[1].setMax(r[1].Max());
		range[2].setMin(r[2].Min());
		range[2].setMax(r[2].Max());
	}

	nx = dimx;	// xrange
	ny = dimy;	// yrange

	array = new double[nx*ny];
	for (int i=0;i<nx;i++)
		for (int j=0;j<ny;j++)
			array[j+i*ny] = a[j+i*ny];

	/*for (int i=0;i<nx;i++) {
		for (int j=0;j<ny;j++) {
			kdDebug()<<' '<<array[j+ny*i];
		}
		kdDebug()<<endl;
	}*/
}

void GraphM::save(QTextStream *t) {
	saveGraph(t);
	*t<<nx<<' '<<ny<<endl;
       	*t<<range[0].Min()<<' '<<range[0].Max()<<endl;
       	*t<<range[1].Min()<<' '<<range[1].Max()<<endl;
       	*t<<range[2].Min()<<' '<<range[2].Max()<<endl;
	*t<<type<<' ';
	style.save(t);
	symbol.save(t);

	//dump data
	for (int i=0;i< nx;i++) {
		for(int j=0;j<ny;j++) {
			*t<<array[j+i*ny]<<' ';
		}
		*t<<endl;
	}
}

void GraphM::open(QTextStream *t, int version) {
	openGraph(t,version);
	
	*t>>nx>>ny;

	double zmin, zmax;
	*t>>zmin>>zmax;
	range[0].setMin(zmin); range[0].setMax(zmax);
	*t>>zmin>>zmax;
	range[1].setMin(zmin); range[1].setMax(zmax);
	*t>>zmin>>zmax;
	range[2].setMin(zmin); range[2].setMax(zmax);

	type = (PType) style.open(t,version);
	symbol.open(t,version);

	// read data
	array = new double[nx*ny];
	t->readLine();
	for (int i=0;i<nx;i++) {
		QString line = t->readLine();

		//kdDebug()<<"line "<<i<<" : "<<line<<endl;

                line = line.simplifyWhiteSpace();
        	QStringList oneline = QStringList::split(QChar(' '), line );

		int j=0;
		for ( QStringList::Iterator it = oneline.begin(); it != oneline.end(); ++it ) {
			double z = (*it).toDouble();
			if (j==0 && i==0) {
				zmin=zmax=z;
			}
			else {
				z<zmin?zmin=z:0;
				z>zmax?zmax=z:0;
			}
			array[j+ny*i]=z;
			j++;
			//kdDebug()<<"array["<<j+ny*i<<"] = "<<array[j+ny*i]<<endl;
		}
	}
}

QStringList GraphM::Info(){
	QStringList s;
	QString t;
	if(type==0)
		t=i18n("2D");
	else if (type==1)
		t=i18n("Surface");
	else if (type==2)
		t=i18n("3D");

	QString sh=i18n("NO");
	if (shown)
		sh=i18n("YES");

	s << name << t << sh;
	s << QString::number(nx) << QString::number(ny);
	s << QString::number(range[0].Min())+ " .. " + QString::number(range[0].Max());
	s << QString::number(range[1].Min())+ " .. " + QString::number(range[1].Max());
	s << QString::number(range[2].Min())+ " .. " + QString::number(range[2].Max());
	
	return s;
}
