//LabPlot : GraphGRASS.cc

#include <iostream>
#include <qstringlist.h>
#include <qprogressdialog.h>
#include <kdebug.h>
#include "GraphGRASS.h"

using namespace std;

GraphGRASS::GraphGRASS(QString n, QString l,LRange r[2], int t, Style st,
		Symbol sy, int nr)
	: Graph(n,l,t,st,sy,nr)
{
	//TODO : Range ?
	range = new LRange[2];
	if (r) {
		for (int i=0;i<2;i++) {
			range[i].setMin(r[i].Min());
			range[i].setMax(r[i].Max());
		}
	}
}

QStringList GraphGRASS::Info() {
	//TODO
	QStringList s;
	QString t="GRASS";

	QString sh=i18n("NO");
	if (shown)
		sh=i18n("YES");

	s << name << t << sh;
	s << QString::number(number);
	s << QString(" 1 ");		// only 1 column
	s << QString::number(range[0].Min()) + " .. " +QString::number(range[0].Max());
	s << QString::number(range[1].Min())+ " .. " +QString::number(range[1].Max());
	
	return s;
}

void GraphGRASS::save(QTextStream *t) {
	*t<<(int) ltype<<endl;
	*t<<layer<<endl;

	saveGraph(t);
	*t<<number<<endl;
       	*t<<range[0].Min()<<' '<<range[0].Max()<<' '<<range[1].Min()<<' '<<range[1].Max()<<endl;
	*t<<type<<' ';
	style.save(t);
	symbol.save(t);
}

void GraphGRASS::open(QTextStream *t,int version) {
	if (version > 13) {
		kdDebug()<<"GraphGRASS::open()"<<endl;
		int tmp;
		*t>>tmp;
		ltype = (LType) tmp;
		*t>>layer;

		openGraph(t,version);
		*t>>number;

		kdDebug()<<"GraphGRASS : "<<endl;
		kdDebug()<<"     name : "<<name<<endl;
		kdDebug()<<"     label : "<<label<<endl;
		kdDebug()<<"     number :  "<<number<<endl;

		double xmin, xmax, ymin, ymax;
		*t>>xmin>>xmax>>ymin>>ymax;
		range[0].setMin(xmin);
		range[0].setMax(xmax);
		range[1].setMin(ymin);
		range[1].setMax(ymax);

		kdDebug()<<"GraphGRASS : reading ranges"<<endl;

		type = (PType) style.open(t,version);
		symbol.open(t,version);
	}
}
