//LabPlot: Axis.h

#ifndef AXIS_H
#define AXIS_H

#include <qstring.h>
#include <qfont.h>
#include <qcolor.h>
#include "Label.h"
#include "defs.h"

class Axis {
public:
	Axis();
	void enable(bool b) { e = b; }		/*!< enable axis*/
	bool enabled() { return e; }		/*!< axis enabled ?*/
	void setScale(TScale s) { scale=s; }
	TScale Scale() { return scale; }
	void setLabel(Label *label) { l = label; }	/*!< set axis label*/
	void setScaling(double s) { scaling=s; }
	double getScaling() { return scaling; }
	void setShift(double s) { shift=s; }
	double getShift() { return shift; }
	Label *label() { return l; }		/*!< get axis label*/
	void setTicsLabelRotation(double r) { tlrotation = r; }
	double getTicsLabelRotation() { return tlrotation; }
	void setTicLabelPrefix(QString p) { tlprefix=p; }
	QString getTicLabelPrefix() { return tlprefix; }
	void setTicLabelSuffix(QString s) { tlsuffix=s; }
	QString getTicLabelSuffix() { return tlsuffix; }
	void setTicsFont(QFont a) { tf = a; }	/*!< set tics label font*/
	QFont ticsFont() { return tf; }		/*!< get tics label font*/
	void setTicsColor(QColor col) { tc = col; }
	QColor ticsColor() { return tc; }
	void setTicsLabelColor(QColor col) { tlc = col; }
	QColor ticsLabelColor() { return tlc; }
	void setTicsLabelFormat(TFormat tmp) { atlf = tmp; }
	TFormat ticsLabelFormat() { return atlf; }
	void setDateTimeFormat(QString f) { datetimeformat = f; }
	QString getDateTimeFormat() { return datetimeformat; }
	void setTicsLabelPrecision(int tmp) { tlp = tmp; }
	int ticsLabelPrecision() { return tlp; }

	void setMajorTics(int t) { majortics = t; }	/*!< set number of major tics*/
	int majorTics() { return majortics; }		/*!< get number of major tics*/
	void setMinorTics(int t) { minortics = t; }	/*!< set number of minor tics*/
	int minorTics() { return minortics; }		/*!< get number of minor tics*/
	void enableMajorTics(bool b) { majorticse = b; }
	void enableMinorTics(bool b) { minorticse = b; }
	bool majorTicsEnabled() { return majorticse; }
	bool minorTicsEnabled() { return minorticse; }
	void setTicsPos(int tp) { ticspos = tp; }
	int getTicsPos() { return ticspos; }
	void setBorderColor(QColor col) { bc = col; }
	QColor borderColor() { return bc; }
	void setGridColor(QColor col) { gc = col; }
	QColor gridColor() { return gc; }
private:
	bool e;				//!< axis enabled ?
	TScale scale;
	double scaling, shift;	//!< scaling and shift of axes tic values
	Label *l;
	double tlrotation;		//!< tic label rotation
	QString tlprefix, tlsuffix;	//!< tic label prefix and suffix
	QFont tf;				//!< axis/tics label font
	QColor tc, tlc, bc, gc;
	TFormat atlf;			//!< tics label format
	QString datetimeformat;	//!< format for time tic label
	int tlp;				//!< tics label precision
	int ticspos;			//!< tics label position 0:out 1:in 2:in&out 3:none
	int majortics;			//!< number of major tics
       	int minortics;			//!< number of minor tics
	bool majorticse;		//!< major tics enabled ?
	bool minorticse;		//!< minor tics enabled ?
};

#endif	//AXIS_H
