//LabPlot : AverageListDialog.cc

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <qstring.h>
#include <qlabel.h>
#include <qfiledialog.h>
#include <qcolordialog.h>
#include <klocale.h>
#include "AverageListDialog.h"

using namespace std;

AverageListDialog::AverageListDialog(Worksheet *p,const char *name)
	: ListDialog(p, name)
{
	setCaption(i18n("Average Dialog"));

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	new QLabel(i18n(" Average every n points :"),tab1);
	QHBox *hb = new QHBox(tab1);
	new QLabel(QString(" n = "),hb);
	nle = new KLineEdit(QString("3"),hb);
	nle->setValidator(new QIntValidator(nle));

	Style style;
	Symbol symbol;
	QVBox *styletab;
	if(p->getPlot(p->getAPI())->getType() == PSURFACE)
		styletab = surfaceStyle(tw);
	else
		styletab = simpleStyle(tw,0, &style, &symbol);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
        QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	int sizex = vbox->minimumSizeHint().width();
	int sizey = vbox->minimumSizeHint().height()+gbox->minimumSizeHint().height()+
		tw->minimumSizeHint().height();
	setMinimumSize(sizex,sizey);
	resize(sizex,sizey);
}

void AverageListDialog::apply_clicked() {
	// more selected graphs ???
	int item = (int) (lv->itemPos(lv->currentItem())/18);
	//TODO
	GraphList *gl = p->getPlot(p->getAPI())->getGraphList();
	GRAPHType s = gl->getStruct(item);

	if (s == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		int nx = g->Number();
		Point *ptr = new Point[nx];
		Point *a = g->getData();

		// do the average
		int n = (nle->text()).toInt();
		double xmin=0, xmax=1, ymin=0, ymax=1;
		for (int i = 0;i<nx/n;i++) {
			double x = a[(int) (n*i+n/2)].X();
			double y = 0;
			for (int j=0;j<n;j++) {
				y+=a[n*i+j].Y();
			}
			y = y/n;

			// new ranges
			if (i==0) {
				xmin=xmax=x;
				ymin=ymax=y;
			}
			else {
				x<xmin?xmin=x:0;
				x>xmax?xmax=x:0;
				y<ymin?ymin=y:0;
				y>ymax?ymax=y:0;
			}

			ptr[i].setPoint(x,y);
		}

		// create the new Graph
		LRange range[2];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);
		
		QString fun = QString(i18n("average (")+QString::number(n)+i18n(") of ")+g->Label());
		
		Style style(cb2->currentItem(),color->color(),
			filled->isChecked(),fcolor->color());
		Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),
			ssize->text().toInt(),(FType)symbolfillcb->currentItem(),sfcolor->color());
		Graph2D *ng = new Graph2D(fun,fun,range,P2D,style,symbol,ptr,g->Number()/n);
		p->addGraph2D(ng);	
	}
	else if (s == GRAPH3D) {
		Graph3D *g = gl->getGraph3D(item);
		int nx = g->Number();
		Point3D *ptr = new Point3D[nx];
		Point3D *a = g->getData();

		cout<< "TYPE : "<<type<<endl;
		
		// do the average
		int n = (nle->text()).toInt();
		double xmin=0, xmax=1, ymin=0, ymax=1, zmin=0, zmax=1;
		for (int i = 0;i<nx/n;i++) {
			double x = 0, y = 0, z = 0;
			if (type == P2D) {	// 2derr
				x = a[(int) (n*i+n/2)].X();
				for (int j=0;j<n;j++) {
					y += a[n*i+j].Y();
					z += a[n*i+j].Z();
				}
				y = y/n;
				z = z/n;
			}
			else {		// 3d
				for (int j = 0;j<n;j++) {
					x+=a[(int)(j+n*i)].X();
					y+=a[(int)(j+n*i)].Y();
					z+=a[(int)(j+n*i)].Z();
				}
				x = x/n;
				y = y/n;
				z = z/n;
			}
			
			// new ranges
			if (i==0) {
				xmin=xmax=x;
				ymin=ymax=y;
				zmin=zmax=z;
			}
			else {
				x<xmin?xmin=x:0;
				x>xmax?xmax=x:0;
				y<ymin?ymin=y:0;
				y>ymax?ymax=y:0;
				z<zmin?zmin=z:0;
				z>zmax?zmax=z:0;
			}

			ptr[i].setPoint(x,y,z);
		}

		// create the new Graph
		LRange range[3];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);
		range[2] = LRange(zmin,zmax);
		
		QString fun = QString(i18n("average (")+QString::number(n)+i18n(") of ")+g->Label());
		
		Style style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color());
		Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),
			ssize->text().toInt(),(FType)symbolfillcb->currentItem(),sfcolor->color());
		Graph3D *ng = new Graph3D(fun,fun,range,type,style,symbol,ptr,g->Number()/n,1);
		ng->setNumberX((int)(g->NX()/n));
		ng->setNumberY((int)(g->NY()));
		p->addGraph3D(ng);	

	}
	else if (s == GRAPHM) {		// PSURFACE and P3D
		GraphM *g = gl->getGraphM(item);
		int N = g->Number();
		int nx = g->NX();
		int ny = g->NY();
		double *ptr = new double[N];
		double *a = g->getData();

		// do the average
		int n = (nle->text()).toInt();
		double zmin=0, zmax=1;
		for (int i = 0;i<nx/n;i++) {
			for (int j = 0;j<ny/n;j++) {
				double z = 0;
		
				for (int l=0;l<n;l++) {
					int a1 = n*i+l;
					for (int k=0;k<n;k++) {
						int a2 = n*j+k;
						z += a[a2+nx*a1];
					}
				}
				z=z/(n*n);
				// new ranges
				if (i==0) {
					zmin=zmax=z;
				}
				else {
					z<zmin?zmin=z:0;
					z>zmax?zmax=z:0;
				}

				ptr[j+(nx/n)*i]=z;
			}
			cout<<endl;
		}

		// create the new Graph
		LRange range[3];
		range[0] = LRange(1,nx);
		range[1] = LRange(1,ny);
		range[2] = LRange(zmin,zmax);
		
		QString fun = QString(i18n("average (")+QString::number(n)+i18n(") of ")+g->Label());
		
		Style style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color());
		Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),
			ssize->text().toInt(),(FType)symbolfillcb->currentItem(),sfcolor->color());
		GraphM *ng = new GraphM(fun,fun,range,type,style,symbol,ptr,nx/n,ny/n);
		p->addGraphM(ng);	
	}

	updateList();
}
