/*=========================================================================

  Program:   VtkQt
  Module:    $RCSfile: vtkQtImageViewer.h,v $
  Language:  C++
  Date:      $Date: 2002/11/12 10:52:38 $
  Version:   $Revision: 1.1.1.1 $

  Copyright (c) 2002 Denis Shamonin
  Section Computational Science
  University of Amsterdam
  Kruislaan 403, 1098 SJ Amsterdam
  the Netherlands

  E-mail        : dshamoni@science.uva.nl
  URL           : http://www.science.uva.nl/~dshamoni/
  
  All rights reserved.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#ifndef __vtkQtImageViewer_h
#define __vtkQtImageViewer_h

#include <vtkImageViewer.h>
#include <qgl.h> 

class VTK_RENDERING_EXPORT vtkQtImageViewer : public QGLWidget, public vtkImageViewer
{ 
  Q_OBJECT
public:
  static vtkQtImageViewer *New( QWidget *parent, const char *name ) {return new vtkQtImageViewer(parent, name);};
  static vtkQtImageViewer *New() {return new vtkQtImageViewer(NULL, "VtkQt");};
  
  // Description:
  // Set name of rendering window.
  void SetWindowName(const char *);
  
  // Description:
  // Move the window to a new position on the display.
  void SetPosition(int,int);
  void SetPosition(int a[2]) {this->SetPosition(a[0], a[1]);};
  
  void SetInitializeResize(bool var) {InitializeResize = var;};
  
public slots:
  // Description:
  // Updates the widget by calling Render(). 
  void updateGL() { this->Render();};
  
protected:
  vtkQtImageViewer(QWidget *parent, const char *name );
  ~vtkQtImageViewer();
  
  // Description:
  // This function is called whenever the widget needs to be painted. 
  void paintGL();
    
  void resizeGL(int w, int h);
  bool InitializeResize;
  
private:
  vtkQtImageViewer(const vtkQtImageViewer&);  // Not implemented.
  void operator=(const vtkQtImageViewer&);  // Not implemented.
};

#endif
