/*=========================================================================

  Program:   VtkQt
  Module:    $RCSfile: simple2.cpp,v $
  Language:  C++
  Date:      $Date: 2002/11/12 10:52:38 $
  Version:   $Revision: 1.1.1.1 $

  Copyright (c) 2002 Denis Shamonin
  Section Computational Science
  University of Amsterdam
  Kruislaan 403, 1098 SJ Amsterdam
  the Netherlands

  E-mail        : dshamoni@science.uva.nl
  URL           : http://www.science.uva.nl/~dshamoni/
  
  All rights reserved.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtkQtRenderWindow.h"
#include "vtkQtRenderWindowInteractor.h"

#include <qapplication.h> 
#include <vtkRenderer.h> 
#include <vtkConeSource.h>
#include <vtkPolyDataMapper.h>
#include <vtkActor.h>
#include <vtkProperty.h>

int main( int argc, char* argv[] ) 
{ 
  QApplication::setColorSpec(QApplication::CustomColor); 
  QApplication myapp( argc, argv ); 
  
  vtkRenderer *ren = vtkRenderer::New();
  vtkQtRenderWindow *renWindow = vtkQtRenderWindow::New(); 
   renWindow->AddRenderer(ren);
   renWindow->SetWindowName("VtkQt-vtkQtRenderWindowInteractor");

  vtkQtRenderWindowInteractor *iren = vtkQtRenderWindowInteractor::New();
   iren->SetRenderWindow(renWindow);

  vtkConeSource *cone = vtkConeSource::New();
   cone->SetResolution(8);

  vtkPolyDataMapper *coneMapper = vtkPolyDataMapper::New();
   coneMapper->SetInput(cone->GetOutput());
  
  vtkActor *coneActor = vtkActor::New();
   coneActor->SetMapper(coneMapper);          
   coneActor->GetProperty()->SetColor(1,1,1);

  ren->AddActor(coneActor);
  
  myapp.setMainWidget(iren); 

  iren->show(); 
 
  int nReturn = myapp.exec(); 

  renWindow->Delete();
  ren->Delete();
  iren->Delete();
  cone->Delete();
  coneMapper->Delete();
  coneActor->Delete();
   
  return nReturn; 
} 
