/***************************************************************************
 *   Copyright (C) 2004 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <qpainter.h>
#include <qlineedit.h>
#include <qspinbox.h>
#include <qpushbutton.h>
#include <qstring.h>
#include <kfontcombo.h>
#include <kapplication.h>
#include "texttooldialog.h"
#include "editview.h"

TextToolDialog::TextToolDialog(QWidget* parent) : TextToolDlg(parent,"TextToolDlg",true)
{
  connect(TextTool_Text,SIGNAL(textChanged(const QString&)),this,SLOT(slotTextChanged(const QString&)));
  connect(TextTool_Help,SIGNAL(clicked()),this,SLOT(slotContextHelp()));
  connect(TextTool_Font,SIGNAL(highlighted(int)),this,SLOT(slotFontSelected(int)));
  connect(TextTool_Size,SIGNAL(valueChanged(int)),this,SLOT(slotSizeChanged(int)));
  TextTool_Font->setCurrentItem(1);
  slotFontSelected(1);
  TextTool_OK->setEnabled(false);
}

TextToolDialog::~TextToolDialog()
{
  // nothing to do here
}

QByteArray TextToolDialog::pattern()
{
  QPixmap *pm = new QPixmap(1000,100,1);
  QPainter *p = new QPainter;
  p->begin(pm);
  QFont f = p->font();
  f.setFamily(m_font);
  f.setPixelSize(m_size);
  p->setFont(f);
  p->setPen(QPen(Qt::color0,1));
  QRect br = p->boundingRect(0,0,1000,100,AlignAuto,m_text);
  m_width = br.width();
  m_height = br.height();
  p->end();
  pm->resize(m_width,m_height);
  p->begin(pm);
  p->setFont(f);
  pm->fill(Qt::color0);
  p->setPen(QPen(Qt::color1,1));
  p->drawText(0,0,m_width,m_height,AlignCenter,m_text);
  p->end();
  QImage im;
  QByteArray a(m_width*m_height);
  im = pm->convertToImage();
  for (int y = 0 ; y < m_height ; y++)
    for (int x = 0 ; x < m_width ; x++)
      a[y*m_width+x] = ((im.pixelIndex(x,y))?1:0);
  delete p;
  delete pm;
  return a;
}

void TextToolDialog::accept()
{
  m_font = TextTool_Font->currentFont();
  m_text = TextTool_Text->text();
  m_size = TextTool_Size->value();
  m_width = 0;
  m_height = 0;
  TextToolDlg::accept();
}

int TextToolDialog::boundingWidth()
{
  return m_width;
}

int TextToolDialog::boundingHeight()
{
  return m_height;
}

void TextToolDialog::slotContextHelp()
{
  kapp->invokeHelp("TextDialog");
}

void TextToolDialog::slotTextChanged(const QString& s)
{
  TextTool_OK->setEnabled(!s.isEmpty());
}

void TextToolDialog::slotFontSelected(int)
{
  QFont f = TextTool_Text->font();
  f.setFamily(TextTool_Font->currentFont());
  TextTool_Text->setFont(f);
}

void TextToolDialog::slotSizeChanged(int s)
{
  QFont f = TextTool_Text->font();
  f.setPointSize(s);
  TextTool_Text->setFont(f);
}

