/***************************************************************************
                          kwcentryedit.cpp  -  description
                             -------------------
    begin                : Sam Feb 1 2003
    copyright            : (C) 2003 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kwcentryedit.h"

/*!
	\fn KWCEntryEdit::KWCEntryEdit( const QString & inscr, KSingleTabWidget *parent, const char *name )
 */
KWCEntryEdit::KWCEntryEdit( const QString & inscr, KSingleTabWidget *parent, const char *name ) : KWCEntry( inscr, parent, name )
{
	valueEdit = new KLineEdit( parent );
	valueEdit->show();
	
	valueEdit->setMaximumHeight( inscriptionLabel->height() + 4 );
	valueEdit->setFixedWidth( 140 );
	
	applyButton = new QToolButton( parent );
	applyButton->setTextLabel( "apply", true );
	applyButton->setIconSet( QIconSet( KGlobal::iconLoader()->loadIcon( "ok", KIcon::Small ) ) );
	applyButton->adjustSize();
	
	setValueWidget( valueEdit );
	setRightWidget( applyButton );
	
	QObject::connect( valueEdit, SIGNAL( textChanged( const QString & ) ), this, SLOT( changedSlot( const QString & ) ) );
	QObject::connect( valueEdit, SIGNAL( returnPressed() ), this, SLOT( returnPressedSlot() ) );
	QObject::connect( applyButton, SIGNAL( clicked() ), this, SLOT( returnPressedSlot() ) );
}


/*!
	\fn KWCEntryEdit::~KWCEntryEdit()
 */
KWCEntryEdit::~KWCEntryEdit()
{
}


/*!
	\fn KWCEntryEdit::setValue( const QString & value )
 */
void KWCEntryEdit::setValue( const QString & value )
{
	valueEdit->setText( value );
	valueEdit->adjustSize();
}


/*!
	\fn KWCEntryEdit::changedSlot( const QString & text )
 */
void KWCEntryEdit::changedSlot( const QString & text )
{
	changed( text );
}


/*!
	\fn KWCEntryEdit::returnPressedSlot()
 */
void KWCEntryEdit::returnPressedSlot()
{
	// clear focus to allow updating
	valueEdit->clearFocus();
	returnPressed( valueEdit->text() );
}


/*!
	\fn KWCEntryEdit::getText()
 */
QString KWCEntryEdit::getText()
{
	return valueEdit->text();
}
