/**************************************************************************
*   Copyright (C) 2004 by  Thomas Renninger                               *
*                            <trenn@suse.de> and                          *
*                          Danny Kukawka                                  *
*                            <dkukawka@suse.de>, <danny.kukawka@web.de>   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of version 2 of the GNU General Public License     *
*   as published by the Free Software Foundation.                         *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.          *
***************************************************************************/

#ifndef _KPOWERSAVE_DEBUG_H
#define _KPOWERSAVE_DEBUG_H

// Global Header
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Default Header
#include <stdio.h>
#include <stdlib.h>

// QT - Header
#include <qdatetime.h>

/*! 
*  \file 	kpowersave_debug.h
*  \brief 	Headerfile for debug releated defines/macros. Currently this file
*		contains the myDebug(...) macro.
*/

/* #define ENABLE_DEBUG_MSG_MODE 1 for debugging or call ./configure --enable-debug-msg */
#ifdef ENABLE_DEBUG_MSG_MODE
#define myDebug(x, y...) do {							\
	fprintf(stderr, " %s:%d:\t", QTime::currentTime().toString().ascii(), 	\
				   QTime::currentTime().msec());		\
	qDebug(x, ## y);							\
} while (0)
#else
#define myDebug(x, y...) do{} while(0)
#endif 

#endif //_KPOWERSAVE_DEBUG_H
