 /**************************************************************************
 *   Copyright (C) 2004 by  Holger Macht                                   *
 *                            <hmacht@suse.de>                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.          *
 ***************************************************************************/

#ifndef _SCHEMES_H_
#define _SCHEMES_H_

#include <qstringlist.h>

 /*! 
 *  \file 	schemes.h
 *  \brief 	Headerfile for schemes.cpp and the class \ref Schemes.
 */
 
 /*! 
 *  \class 	Schemes
 *  \brief 	manages a list of schemes
 *  \author	Holger Macht, <hmacht@suse.de> (2005)
 *  \date    	2005
 */
class Schemes {

public:
	 //! returns the number of schemes available
	 int count();

	 //! returns the list of schemes available
	 QStringList schemeList();
	 //! returns the current active scheme
	 QString currentScheme();
	 //! returns the battery scheme
	 QString batteryScheme();
	 //! returns the ac scheme
	 QString acScheme();

	 //! sets the current active scheme
	 void setCurrentScheme( char *current_scheme );
	 //! sets the battery scheme
	 void setBatteryScheme( char *battery_scheme );
	 //! sets the ac scheme
	 void setAcScheme( char *ac_scheme );
	 //! appends one scheme to the list of schemes
	 void append( char *scheme );
	 //! clears the object, removes all schemes
	 void clear();

	 //! checks wether the given schemelist differs from ours
	 bool differ( QStringList other_schemes );

private:
	//! contains the available schemes
	/*! This QStringList contains the untranslated names of the available powersave schemes. */
	QStringList scheme_list;
	//! the name of the current scheme
	/*! This QString contains the name of the currently active powersave scheme */
	QString current_scheme;
	//! the name of the battery scheme
	/*! This QString contains the name of the default scheme if the machine is on battery */
	QString battery_scheme;
	//! the name of the AC scheme
	/*! This QString contains the name of the default scheme if the machine is on AC */
	QString ac_scheme;
};
#endif
