#include <qvbox.h>
#include <qlabel.h>
#include <qvbuttongroup.h>
#include <qhbuttongroup.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qsettings.h>
#include <qlayout.h>
#include <qdialog.h>

#include "callaudio.h"
#include "dspoutoss.h"
#include "audiocontrol.h"

AudioControl::AudioControl( CallAudio *callaudio, QWidget *parent, const char *name )
	: QDialog( parent, QString( name ) + tr("Audio Properties"), true )
{
	a = callaudio;
	QVBox *vbox = new QVBox( this );
	vbox->setMargin( 3 );
	vbox->setSpacing( 3 );
	QVBoxLayout *vboxl = new QVBoxLayout( this, 5 );
	vboxl->addWidget( vbox );
	
	bg2 = new QHButtonGroup( tr("OSS Device Mode"), vbox );
	rwButton = new QRadioButton( tr("ReadWrite"), bg2 );
	bg2->insert( rwButton, rw );
	rowoButton = new QRadioButton( tr("ReadOnly / WriteOnly"), bg2 );
	bg2->insert( rowoButton, rowo );
	connect( rwButton, SIGNAL( clicked() ), this, SLOT( rwButtonClicked() ) );
	connect( rowoButton, SIGNAL( clicked() ), this, SLOT( rowoButtonClicked() ) );

	(void) new QLabel( tr("Device for WriteOnly or ReadWrite:"), vbox );
	dspdev = new QLineEdit( a->getOSSFilename(), vbox );
	dspdev->setMinimumWidth( fontMetrics().maxWidth() * 20 );
	dspdev->setText( a->getOSSFilename() );

	(void) new QLabel( tr("Device for ReadOnly:"), vbox );
	dspdev2 = new QLineEdit( a->getOSSFilename2(), vbox );
	dspdev2->setMinimumWidth( fontMetrics().maxWidth() * 20 );
	dspdev2->setText( a->getOSSFilename2() );

	bg1 = new QHButtonGroup( tr("Preferred Codec"), vbox );
	QRadioButton *ulawButton = new QRadioButton( tr("G711u"), bg1 );
	bg1->insert( ulawButton, ulaw );
	QRadioButton *gsmButton = new QRadioButton( tr("GSM"), bg1 );
	bg1->insert( gsmButton, gsm );
	QRadioButton *ilbcButton = new QRadioButton( tr("iLBC"), bg1 );
	bg1->insert( ilbcButton, ilbc );

	QSettings settings;
	QString mode = settings.readEntry( "/kphone/audio/mode", "readwrite" );
	if( mode == "readwrite" ) {
		rwButton->setChecked(TRUE);
		dspdev2->setEnabled(FALSE);
	} else {
		rowoButton->setChecked(TRUE);
		dspdev2->setEnabled(TRUE);
	}
	
	QString codec = settings.readEntry( "/kphone/audio/Codec", "ULAW" );
	if( codec == "ULAW" ) {
		ulawButton->setChecked(TRUE);
	} else if( codec == "GSM" ) {
		gsmButton->setChecked(TRUE);
	} else if( codec == "ILBC" ) {
		ilbcButton->setChecked(TRUE);
	}

	// Size of Payload
	bg3 = new QHButtonGroup( tr("Size of Payload"), vbox );
	QRadioButton *s80 = new QRadioButton( tr("80 (10 ms Sample)"), bg3 );
	bg3->insert( s80, size80 );
	QRadioButton *s160 = new QRadioButton( tr("160 (20 ms Sample)"), bg3 );
	bg3->insert( s160, size160 );
	switch( settings.readNumEntry( "/kphone/dsp/SizeOfPayload", 80 ) ) {
		case 80: s80->setChecked(TRUE); break;
		case 160: s160->setChecked(TRUE); break;
	}

	// Ringing tone
	ringing = new QHButtonGroup( tr("Ringing tone  (system bell)"), vbox );
	QRadioButton *noRingingtone = new QRadioButton( tr("Don't use ringing tone"), ringing );
	ringing->insert( noRingingtone, ringingtoneNo );
	QRadioButton *yesRingingtone = new QRadioButton( tr("Use ringing tone"), ringing );
	ringing->insert( yesRingingtone, ringingtoneYes );
	if( settings.readEntry( "/kphone/General/ringingtone", "No" ) == "Yes" ) {
		ringing->setButton( ringingtoneYes );
	} else {
		ringing->setButton( ringingtoneNo );
	}

	QHBoxLayout *buttonBox;
	buttonBox = new QHBoxLayout( vboxl, 6 );
	okPushButton = new QPushButton( this, tr("ok button") );
	okPushButton->setText( tr("OK") );
	okPushButton->setDefault( TRUE );
	buttonBox->addWidget( okPushButton );
	cancelPushButton = new QPushButton( this, tr("cancel button") );
	cancelPushButton->setText( tr("Cancel")  );
	cancelPushButton->setAccel( Key_Escape );
	buttonBox->addWidget( cancelPushButton );
	connect( okPushButton, SIGNAL( clicked() ), this, SLOT( slotOk() ) );
	connect( cancelPushButton, SIGNAL( clicked() ), this, SLOT( slotCancel() ) );
}

AudioControl::~AudioControl( void )
{
}

void AudioControl::rwButtonClicked( void )
{
	dspdev2->setEnabled(FALSE);
}

void AudioControl::rowoButtonClicked( void )
{
	dspdev2->setEnabled(TRUE);
}

void AudioControl::slotOk( void )
{
	slotApply();
	QDialog::accept();
}

void AudioControl::slotApply( void )
{
	a->setOSSFilename( dspdev->text() );
	a->setOSSFilename2( dspdev2->text() );
	a->saveAudioSettings();
	QSettings settings;

	switch( bg1->id( bg1->selected() ) ) {
		case ulaw:
			settings.writeEntry( "/kphone/audio/Codec", "ULAW");
			a->setCodec( codecULAW );
			break;
		case gsm:
			settings.writeEntry( "/kphone/audio/Codec", "GSM");
			a->setCodec( codecGSM );
			break;
		case ilbc:
			settings.writeEntry( "/kphone/audio/Codec", "ILBC");
			a->setCodec( codecILBC );
			break;
	}

	switch( bg2->id( bg2->selected() ) ) {
		case rw:
			settings.writeEntry( "/kphone/audio/mode", "readwrite");
			break;
		case rowo:
			settings.writeEntry( "/kphone/audio/mode", "readonly_writeonly");
			break;
	}

	int payload;
	switch( bg3->id( bg3->selected() ) ) {
		case size80:
			payload = 80;
			break;
		case size160:
		default:
			payload = 160;
			break;
	}
	a->setPayload( payload );
	settings.writeEntry( "/kphone/dsp/SizeOfPayload", payload );

	switch( ringing->id( ringing->selected() ) ) {
		case ringingtoneYes:
			settings.writeEntry( "/kphone/General/ringingtone", "Yes" );
			break;
		default:
			settings.writeEntry( "/kphone/General/ringingtone", "No" );
			break;
	}
}

void AudioControl::slotCancel( void )
{
	dspdev->setText( a->getOSSFilename() );
	dspdev2->setText( a->getOSSFilename2() );
	QDialog::reject();
}

VideoControl::VideoControl( CallAudio *callaudio,
	QWidget *parent, const char *name )
	: QDialog( parent, QString( name ) +  tr("Video Properties"), true )
{
	a = callaudio;
	QVBox *vbox = new QVBox( this );
	vbox->setMargin( 3 );
	vbox->setSpacing( 3 );
	QVBoxLayout *vboxl = new QVBoxLayout( this, 5 );
	vboxl->addWidget( vbox );
	QSettings settings;
	(void) new QLabel( "/kphone/video/Video SW:", vbox );
	QString videosw = settings.readEntry(
		"/kphone/video/videoSW", "/usr/local/bin/vic" );
	QString codec = settings.readEntry( "/kphone/video/codec", "h261" );
	videoSW = new QLineEdit( videosw, vbox );
	videoSW->setMinimumWidth( fontMetrics().maxWidth() * 20 );
	bg1 = new QHButtonGroup( tr("Preferred Video Codec"), vbox );
	QRadioButton *h261Button = new QRadioButton( tr("H261"), bg1 );
	bg1->insert( h261Button, h261 );
	QRadioButton *h263Button = new QRadioButton( tr("H263"), bg1 );
	bg1->insert( h263Button, h263 );
	if( codec == "h261" ) {
		h261Button->setChecked(TRUE);
	} else if( codec == "h263" ) {
		h263Button->setChecked(TRUE);
	}

	QHBoxLayout *buttonBox;
	buttonBox = new QHBoxLayout( vboxl, 6 );
	okPushButton = new QPushButton( this, tr("ok button") );
	okPushButton->setText( tr("OK") );
	okPushButton->setDefault( TRUE );
	buttonBox->addWidget( okPushButton );
	cancelPushButton = new QPushButton( this, tr("cancel button") );
	cancelPushButton->setText( tr("Cancel") );
	cancelPushButton->setAccel( Key_Escape );
	buttonBox->addWidget( cancelPushButton );
	connect( okPushButton, SIGNAL( clicked() ),
		this, SLOT( slotOk() ) );
	connect( cancelPushButton, SIGNAL( clicked() ),
		this, SLOT( slotCancel() ) );

}

VideoControl::~VideoControl( void )
{
}

void VideoControl::slotOk( void )
{
	slotApply();
	QDialog::accept();
}

void VideoControl::slotApply( void )
{
	a->setVideoSW( videoSW->text() );
	QSettings settings;
	settings.writeEntry( "/kphone/video/videoSW", videoSW->text() );
	switch( bg1->id( bg1->selected() ) ) {
		case h261:
			settings.writeEntry( "/kphone/video/codec", "h261");
			a->setVideoCodec( codecH261 );
			break;
		case h263:
			settings.writeEntry( "/kphone/video/codec", "h263");
			a->setVideoCodec( codecH263 );
			break;
	}
}

void VideoControl::slotCancel( void )
{
	QDialog::reject();
}
