#ifndef KSIPAUTHENTICATION_H_INCLUDED
#define KSIPAUTHENTICATION_H_INCLUDED
#include <qdialog.h>
#include <qlistview.h>
#include <qcheckbox.h>
#include <qbutton.h>
#include <qlabel.h>

#include "../dissipate2/sipcall.h"
#include "ksipregistrations.h"


class KSipAuthenticationRequest : public QDialog
{
	Q_OBJECT
public:
	KSipAuthenticationRequest( const QString &server, const QString &sipuri,
		const QString &caption, QWidget *parent = 0, const char *name = 0 );
	~KSipAuthenticationRequest( void );
	void setUsername( const QString &newUsername );
	void setPassword( const QString &newPassword );
	QString getUsername( void );
	QString getPassword( void );

private:
	QLineEdit *username;
	QLineEdit *password;
	QPushButton *okPushButton;
	QPushButton *cancelPushButton;
};

class KSipAuthentication : public QObject
{
	Q_OBJECT
public:
	KSipAuthentication( void );
	~KSipAuthentication( void );

public slots:
	void authRequest( SipCallMember *member );

private:
	void setRegisterState( void );
	void save( void );
	SipClient *c;
	KSipIdentityEdit *edit;
	KPhoneView *v;
	QString userPrefix;
	SipUser *u;
	SipRegister *sipreg;
	bool autoRegister;
	int expires;
	QWidget *parent;
	bool useStun;
	QString stunSrv;
	KSipAuthenticationRequest *authreq;
	bool execAuthreq;
};

#endif // KSIPAUTHENTICATION_H_INCLUDED
