#include <stdio.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qlayout.h>
#include <qsplitter.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qmessagebox.h>
#include <qsettings.h>
#include <qvbox.h>
#include <qdir.h>

#include "../dissipate2/sipcall.h"
#include "../dissipate2/sipclient.h"
#include "../dissipate2/sipstatus.h"
#include "../dissipate2/siptransaction.h"
#include "../dissipate2/sipmessage.h"
#include "calllistview.h"
#include "kcallwidget.h"
#include "callaudio.h"
#include "kphone.h"
#include "ksipauthentication.h"
#include "kphonebook.h"
#include "kphoneview.h"

ContactParser::ContactParser( void )
	: QXmlDefaultHandler()
{
}

bool ContactParser::startDocument()
{
	return TRUE;
}

bool ContactParser::startElement( const QString&, const QString&,
		const QString& qName,
		const QXmlAttributes& attributes)
{
	if( qName == "identity" ) {
		QString description = attributes.value( "description" );
		QString uri = attributes.value( "uri" );
		QString contact = attributes.value( "contact" );
		if( uri.left( 4 ).lower() != "tel:" && uri.left( 4 ).lower() != "sip:" ) {
			uri = "sip:" + uri;
		}
		if( contact.lower() != "no" ) {
			if( !description.isEmpty() ) {
				uri += ";" + description;
			}
			contacts.append( uri );
		}
	}
	return TRUE;
}

bool ContactParser::endElement( const QString&, const QString&, const QString& )
{
	return TRUE;
}

KPhoneView::KPhoneView( CallAudio *callaudio, SipClient *c, SipUser *u, QWidget *parent, const char *name )
	: QWidget( parent, name ), client( c ), user( u )
{
	reg = 0;
	buttonSetOffline = false;
	setSubscribeOffline = false;
	callAudio = callaudio;
	connect( client, SIGNAL( updateSubscribes() ),
		this, SLOT( updateSubscribes() ) );
	connect( client, SIGNAL( incomingInstantMessage( SipMessage * ) ),
		this, SLOT( incomingInstantMessage( SipMessage * ) ) );
	connect( client, SIGNAL( incomingSubscribe( SipCallMember *, bool ) ),
		this, SLOT( incomingSubscribe( SipCallMember *, bool ) ) );
	connect( client, SIGNAL( incomingCall( SipCall *, QString ) ),
		this, SLOT( incomingCall( SipCall *, QString ) ) );
	connect( client, SIGNAL( hideCallWidget( SipCall * ) ),
		this, SLOT( hideCallWidget( SipCall * ) ) );
	QVBoxLayout *vbox = new QVBoxLayout( this );
	QGridLayout *headergrid = new QGridLayout( 4, 5 );
	vbox->insertLayout( 0, headergrid );
	buttonSipUri = new QPushButton( "Set Identity", this );
	buttonSipUri->setMinimumWidth( kphoneMinimunWidht );
	headergrid->addMultiCellWidget( buttonSipUri, 0, 0, 0, 4 );
	connect( buttonSipUri, SIGNAL( clicked() ),
		this, SLOT( showIdentities() ) );
	lineeditCall = new QLineEdit( this );
	lineeditCall->setFocus();
	connect( lineeditCall, SIGNAL( returnPressed() ),
		this, SLOT( makeNewCall() ) );
	headergrid->addMultiCellWidget( lineeditCall, 1, 1, 0, 2 );
	buttonNewCall = new QPushButton( "", this );
	buttonNewCall->setFixedWidth( 30 );
	QIconSet icon;
	icon.setPixmap(SHARE_DIR "/icons/mini-kphone.png", QIconSet::Automatic );
	buttonNewCall->setIconSet( icon );
	headergrid->addWidget( buttonNewCall, 1, 3 );
	connect( buttonNewCall, SIGNAL( clicked() ),
		this, SLOT( makeNewCall() ) );
	buttonVideoCall = new QPushButton( "", this );
	buttonVideoCall->setFixedWidth( 30 );
	QIconSet icon3;
	icon3.setPixmap(SHARE_DIR "/icons/videocall.png", QIconSet::Automatic );
	buttonVideoCall->setIconSet( icon3 );
	headergrid->addWidget( buttonVideoCall, 1, 4 );
	connect( buttonVideoCall, SIGNAL( clicked() ),
		this, SLOT( makeVideoCall() ) );
	callcount = 1;
	clist = new ContactsListView( client, this );
	headergrid->addMultiCellWidget( clist, 3, 3, 0, 4 );
	clist->addMenuItem( "Send Message", this, SLOT( contactSendMessage() ) );
	clist->addMenuItem( "Call", this, SLOT( contactCall() ) );
	clist->addMenuItem( "Video Call", this, SLOT( contactVideoCall() ) );
	clist->addMenuItem( "Phone Book", this, SLOT( showPhoneBook() ) );
	connect( clist, SIGNAL( doubleClicked( QListViewItem * ) ),
		this, SLOT( contactDoubleClicked( QListViewItem * ) ) );
	connect( client, SIGNAL( callListUpdated() ),
		clist, SLOT( auditList() ) );
	buttonOffOnline = new QPushButton( "", this );
	buttonOffOnline->setFixedWidth( 30 );
	QIconSet icon1;
	icon1.setPixmap(SHARE_DIR "/icons/offline.png", QIconSet::Automatic );
	buttonOffOnline->setIconSet( icon1 );
	connect( buttonOffOnline, SIGNAL( clicked() ),
		this, SLOT( buttonOffOnlineClicked() ) );
	headergrid->addWidget( buttonOffOnline, 4, 0 );
	stateComboBox = new QComboBox( TRUE, this, "" );
	static const char* items[] = {
		"Online", "Busy", "Be Right Back", "Away",
		"On The Phone", "Out To Lunch", 0 };
	stateComboBox->insertStrList( items );
	connect( stateComboBox, SIGNAL( activated( const QString & )  ),
		this, SLOT( buttonUpdateClicked() ) );
	headergrid->addMultiCellWidget( stateComboBox, 4, 4, 1, 3 );
	buttonUpdate = new QPushButton( "", this );
	buttonUpdate->setFixedWidth( 30 );
	QIconSet icon2;
	icon2.setPixmap(SHARE_DIR "/icons/enter.png", QIconSet::Automatic );
	buttonUpdate->setIconSet( icon2 );
	connect( buttonUpdate, SIGNAL( clicked() ),
		this, SLOT( buttonUpdateClicked() ) );
	headergrid->addWidget( buttonUpdate, 4, 4 );
	QString label;
	QString uristr;
	sipauthentication = new KSipAuthentication();
	QSettings settings;
	QString codec = settings.readEntry(
		"/kphone/audio/Codec", "ULAW" );
	if( codec == "ULAW" ) {
		callAudio->setCodec( codecULAW );
	} else if( codec == "GSM" ) {
		callAudio->setCodec( codecGSM );
	} else if( codec == "ILBC" ) {
		callAudio->setCodec( codecILBC );
	}
	QString videoCodec = settings.readEntry(
		"/kphone/video/codec", "h261" );
	if( videoCodec == "h261" ) {
		callAudio->setVideoCodec( codecH261 );
	} else if( videoCodec == "h263" ) {
		callAudio->setVideoCodec( codecH263 );
	}
	SipCall *newcall;
	SipCallMember *member;
	QString p = "/kphone/" + getUserPrefix() + "/local/";
	QString file = settings.readEntry( p + "/PhoneBook", "" );
	if( file.isEmpty() ) {
		if( getUserPrefix().isEmpty() ) {
			file = QDir::homeDirPath() + "/.kphone-phonebook.xml";
		} else {
			file = QDir::homeDirPath() + "/.kphone" +
				getUserPrefix() + "phonebook.xml";
		}
	}
	QFile xmlFile( file );
	QXmlInputSource source( xmlFile );
	QXmlSimpleReader reader;
	ContactParser parser;
	reader.setContentHandler( &parser );
	reader.parse( source );
	QStringList sl = parser.getListContacts();
	for ( QStringList::Iterator it = sl.begin(); it != sl.end(); ++it ) {
		QString contact = QString(*it);
		if( contact.contains( ";" ) ) {
			uristr = contact.left( contact.find( ";" ) );
			contact = contact.mid( contact.find( ";" ) + 1 );
		} else {
			uristr = contact;
		}
		if( !uristr.isEmpty() ) {
			newcall = new SipCall( user, QString::null, SipCall::outSubscribeCall );
			newcall->setSubject( uristr );
			newcall->setContactStr( contact );
			SipUri remoteuri( uristr );
			member = new SipCallMember( newcall, remoteuri );
			connect( member, SIGNAL( statusUpdated( SipCallMember * ) ),
				clist, SLOT( auditList() ) );
			connect( member, SIGNAL( statusUpdated( SipCallMember * ) ),
				sipauthentication, SLOT( authRequest( SipCallMember * ) ) );
		}
	}
	clist->auditList();
	atomId = 1000;
	p = "/kphone/" + getUserPrefix() + "/local/";
	subscribeExpiresTime = settings.readNumEntry(
		p + "/SubscribeExpiresTime", constSubscribeExpiresTime );
	if( subscribeExpiresTime == 0 ) {
		subscribeExpiresTime = -1;
	}
	subscribeTimer = new QTimer( this );
	connect( subscribeTimer, SIGNAL( timeout() ),
		this, SLOT( localStatusUpdate() ) );
	isOnline = false;
	p = "/kphone/" + getUserPrefix() + "/presence/";

	int count = 0;
	label.setNum( count );
	label = p + "/Rejected" + label;
	QString s = settings.readEntry( label, "" );
	while( !s.isEmpty() ) {
		rejectedContactList.append( s );
		label.setNum( ++count );
		label = p + "/Rejected" + label;
		s = settings.readEntry( label, "" );
	}
	cwList.setAutoDelete( true );
	imwList.setAutoDelete( true );
}

KPhoneView::~KPhoneView( void )
{
}

void KPhoneView::incomingInstantMessage( SipMessage *message )
{
	printf( "KPhoneView: Incoming Instant Message\n" );
	QString subject;
	QString remote;
	KInstantMessageWidget *imwidget;
	SipCall *c;
	subject = user->getUri().uri();
	remote = message->getHeaderData( SipHeader::From );
	for( imwidget = imwList.first(); imwidget != 0; imwidget = imwList.next() ) {
		c = imwidget->getCall();
		if( c->getSubject() == subject &&
				remote.contains( imwidget->getRemote() ) ) {
			imwidget->instantMessage( message );
			imwidget->show();
			return;
		}
	}
	c = new SipCall( user );
	c->setSubject( user->getUri().uri() );
	imwidget = new KInstantMessageWidget( sipauthentication, c, this );
	imwList.append( imwidget );
	imwidget->instantMessage( message );
	imwidget->show();
}

void KPhoneView::incomingSubscribe( SipCallMember *member, bool sendSubscribe )
{
	clist->auditList();
	if( member == 0 ) {
		return;
	}
	printf( "KPhoneView: Incoming Subscribe\n" );
	bool remove_subscribe = false;
	SipUri uri = member->getUri();
	QString uristr = member->getUri().reqUri();
	for ( QStringList::Iterator it = rejectedContactList.begin(); it != rejectedContactList.end(); ++it ) {
		if( uristr == QString(*it) ) {
			printf( "KPhoneView: Incoming Subscribe Rejected\n" );
			remove_subscribe = true;
		}
	}
	SipCallIterator it( client->getCallList() );
	bool find = false;
	if( !remove_subscribe ) {
		for( it.toFirst(); it.current(); ++it ) {
			if( it.current()->getCallType() == SipCall::outSubscribeCall ) {
				if( it.current()->getMember( uri ) ) {
					find = true;
				}
			}
		}
	}
	if( !find && !remove_subscribe) {
		QString uristr = member->getUri().reqUri();
		QMessageBox mb( getUserPrefix() + "KPhone",
			"Subscribe message from uri:\n" + uristr +
			"\n\nDo you want to accept and create a contact ?",
			QMessageBox::Information,
			QMessageBox::Yes | QMessageBox::Default,
			QMessageBox::No,
			QMessageBox::Cancel | QMessageBox::Escape );
		mb.setButtonText( QMessageBox::Yes, "Accept" );
		mb.setButtonText( QMessageBox::No, "Reject permanently" );
		mb.setButtonText( QMessageBox::Cancel, "Reject this time" );
		switch( mb.exec() ) {
			case QMessageBox::Yes:
				addContactToPhoneBook( member );
				sendSubscribe = false;
				break;
			case QMessageBox::No:
				rejectedContactList.append( member->getUri().reqUri() );
				saveRejectContactList();
				remove_subscribe = true;
				break;
			case QMessageBox::Cancel:
				remove_subscribe = true;
				break;
		}
	}
	if( remove_subscribe ) {
		for( it.toFirst(); it.current(); ++it ) {
			if( it.current()->getCallType() == SipCall::inSubscribeCall ) {
				if( it.current()->getMember( uri ) ) {
					delete it.current();
				}
			}
		}
		return;
	}
	if( isOnline ) {
		connect( member, SIGNAL( statusUpdated( SipCallMember * ) ),
			sipauthentication, SLOT( authRequest( SipCallMember * ) ) );
		sendNotify( ONLINE, member );
	}

	for( it.toFirst(); it.current(); ++it ) {
		if( it.current()->getCallType() == SipCall::outSubscribeCall ) {
			if( it.current()->getCallStatus() != SipCall::callDead ) {
				if( it.current()->getMember( uri ) ) {
					if( sendSubscribe ) {
						if( reg->getRegisterState() == SipRegister::Connected ) {
							QString uristr = it.current()->getSubject();
							QString contactStr = it.current()->getContactStr();
							if( it.current()->getCallStatus() == SipCall::callInProgress ) {
								it.current()->getMember( uri )->requestClearSubscribe();
							}
							delete it.current();
							SipCall *newcall = new SipCall( user, QString::null,
								 SipCall::outSubscribeCall );
							newcall->setSubject( uristr );
							SipUri remoteuri( uristr );
							member = new SipCallMember( newcall, remoteuri );
							connect( member, SIGNAL( statusUpdated( SipCallMember * ) ),
								clist, SLOT( auditList() ) );
							connect( member, SIGNAL( statusUpdated( SipCallMember * ) ),
								sipauthentication, SLOT( authRequest( SipCallMember * ) ) );
							member->requestSubscribe( subscribeExpiresTime );
							newcall->setContactStr( contactStr );
							break;
						}
					}
				}
			}
		}
	}

}

void KPhoneView::incomingCall( SipCall *call, QString body )
{
	updateWidgetList();
	if( call->getSubject() == QString::null ) {
		call->setSdpMessageMask( body );
		call->setSubject( "Incoming call" );
		KCallWidget *widget = new KCallWidget( 0, callAudio, call, this );
		cwList.append( widget );
		connect( widget, SIGNAL( redirectCall( const SipUri &, const QString & ) ),
			this, SLOT( redirectCall( const SipUri &, const QString & ) ) );
		widget->show();
	}
}

void KPhoneView::hideCallWidget( SipCall *call )
{
	KCallWidget *widget;
	SipCall *c;
	for( widget = cwList.first(); widget != 0; widget = cwList.next() ) {
		c = widget->getCall();
		if( c == call ) {
			widget->setHide();
		}
	}
}

void KPhoneView::contactDoubleClicked( QListViewItem *i )
{
	if( !buttonSipUri->text().compare( "Set Identity" ) ){
		QMessageBox::information( this, "KPhone", "Set First Identity." );
		return;
	}
	QString subject = ( (ContactsListViewItem *) i )->getCall()->getSubject();
	SipUri uri = SipUri( buttonSipUri->text() );
	KInstantMessageWidget *imwidget;
	for( imwidget = imwList.first(); imwidget != 0; imwidget = imwList.next() ) {
		if( imwidget->getCall()->getSubject() == uri.uri() &&
		    imwidget->getRemote() == subject ) {
			imwidget->show();
			return;
		}
	}
	SipCall *initcall = new SipCall( user );
	initcall->setSubject( uri.uri() );
	imwidget = new KInstantMessageWidget( sipauthentication, initcall, this );
	imwList.append( imwidget );
	imwidget->setRemote( subject );
	imwidget->show();
}

void KPhoneView::contactSendMessage()
{
	QString subject = "";
	if( clist->currentItem() != 0 ) {
		subject = ((ContactsListViewItem *)clist->currentItem())->getCall()->getSubject();
	}
	if( !buttonSipUri->text().compare( "Set Identity" ) ){
		QMessageBox::information( this, "KPhone", "Set First Identity." );
		return;
	}
	SipUri uri = user->getUri();
	KInstantMessageWidget *imwidget;
	if( clist->currentItem() ) {
		QString subject = ( (ContactsListViewItem *)clist->currentItem() )->getCall()->getSubject();
		if( clist->currentItem() != 0 ) {
			for( imwidget = imwList.first(); imwidget != 0; imwidget = imwList.next() ) {
				if( imwidget->getCall()->getSubject() == uri.uri() &&
				    imwidget->getRemote() == subject ) {
					imwidget->show();
					return;
				}
			}
		}
	}
	SipCall *initcall = new SipCall( user );
	initcall->setSubject( uri.uri() );
	imwidget = new KInstantMessageWidget( sipauthentication, initcall, this );
	imwList.append( imwidget );
	imwidget->setRemote( subject );
	imwidget->show();
}

void KPhoneView::contactCall()
{
	updateWidgetList();
	QString subject = "";
	if( clist->currentItem() != 0 ) {
		subject = ((ContactsListViewItem *)clist->currentItem())->getCall()->getSubject();
	}
	if( !buttonSipUri->text().compare( "Set Identity" ) ){
		QMessageBox::information( this, "KPhone", "Set First Identity." );
		return;
	}
	SipCall *newcall = new SipCall( user, QString::null, SipCall::StandardCall );
	newcall->setSubject( user->getUri().uri() );
	KCallWidget *widget = new KCallWidget( sipauthentication, callAudio, newcall, this );
	cwList.append( widget );
	widget->setRemote( subject );
	connect( widget, SIGNAL( redirectCall( const SipUri &, const QString & ) ),
		this, SLOT( redirectCall( const SipUri &, const QString & ) ) );
	widget->show();
}

void KPhoneView::contactVideoCall()
{
	updateWidgetList();
	QString subject = "";
	if( clist->currentItem() != 0 ) {
		subject = ((ContactsListViewItem *)clist->currentItem())->getCall()->getSubject();
	}
	if( !buttonSipUri->text().compare( "Set Identity" ) ){
		QMessageBox::information( this, "KPhone", "Set First Identity." );
		return;
	}
	SipCall *newcall = new SipCall( user, QString::null, SipCall::videoCall );
	newcall->setSubject( user->getUri().uri() );
	KCallWidget *widget = new KCallWidget( sipauthentication, callAudio, newcall, this );
	cwList.append( widget );
	widget->setRemote( subject );
	connect( widget, SIGNAL( redirectCall( const SipUri &, const QString & ) ),
		this, SLOT( redirectCall( const SipUri &, const QString & ) ) );
	widget->show();
}


void KPhoneView::showPhoneBook()
{
	QSettings settings;
	QString p = "/kphone/" + getUserPrefix() + "/local/";
	QString file = settings.readEntry( p + "/PhoneBook", "" );
	if( file.isEmpty() ) {
		if( getUserPrefix().isEmpty() ) {
			file = QDir::homeDirPath() + "/.kphone-phonebook.xml";
		} else {
			file = QDir::homeDirPath() + "/.kphone" +
				getUserPrefix() + "phonebook.xml";
		}
	}
	QPtrList<IncomingCall> r;
	QPtrList<IncomingCall> m;
	PhoneBook *phoneBook = new PhoneBook(file, this, getUserPrefix() +
		"Phone Book", r, m, rejectedContactList );
	phoneBook->exec();
	rejectedContactList = phoneBook->getRejectedContactsList();
	saveRejectContactList();
	updateContacts( file );
}

void KPhoneView::addContactToPhoneBook( SipCallMember *member )
{
	QSettings settings;
	QString p = "/kphone/" + getUserPrefix() + "/local/";
	QString file = settings.readEntry( p + "/PhoneBook", "" );
	if( file.isEmpty() ) {
		if( getUserPrefix().isEmpty() ) {
			file = QDir::homeDirPath() + "/.kphone-phonebook.xml";
		} else {
			file = QDir::homeDirPath() + "/.kphone" +
				getUserPrefix() + "phonebook.xml";
		}
	}
	QPtrList<IncomingCall> r;
	QPtrList<IncomingCall> m;
	QStringList s;
	PhoneBook *phoneBook = new PhoneBook(
		file, this, getUserPrefix() + "Phone Book", r, m, s );
	phoneBook->addContact( member );
	updateContacts( file );
}

void KPhoneView::updateSubscribes( void )
{
	QSettings settings;
	QString p = "/kphone/" + getUserPrefix() + "/local";
	QString file = settings.readEntry( p + "/PhoneBook", "" );
	if( file.isEmpty() ) {
		if( getUserPrefix().isEmpty() ) {
			file = QDir::homeDirPath() + "/.kphone-phonebook.xml";
		} else {
			file = QDir::homeDirPath() + "/.kphone" +
				getUserPrefix() + "phonebook.xml";
		}
	}
	updateContacts( file );
}

void KPhoneView::updateContacts( QString file )
{
	QString uristr;
	SipCallMember *member;
	SipCall *newcall;
	QFile xmlFile( file );
	QXmlInputSource source( xmlFile );
	QXmlSimpleReader reader;
	ContactParser parser;
	reader.setContentHandler( &parser );
	reader.parse( source );
	SipCallIterator it( client->getCallList() );
	QStringList::Iterator itStr;
	QStringList sl = parser.getListContacts();
	bool find;
	it.toFirst();
	while ( it.current() ) {
		find = true;
		if( it.current()->getCallType() == SipCall::outSubscribeCall ) {
			find = false;
			for ( itStr = sl.begin(); itStr != sl.end(); ++itStr ) {
				QString subject = QString(*itStr);
				if( subject.contains( ";" ) ) {
					subject = subject.left( subject.find( ";" ) );
				}
				if( subject == it.current()->getSubject() ) {
					find = true;
					break;
				}
			}
			if( !find ) {
				disconnect( it.current(), 0, 0, 0 );
				delete it.current();
			}
		}
		if( find ) {
			++it;
		}
	}
	for ( QStringList::Iterator itStr = sl.begin(); itStr != sl.end(); ++itStr ) {
		uristr = QString(*itStr);
		if( !uristr.isEmpty() ) {
			find = false;
			QString subject = QString(*itStr);
			QString contactStr = "";
			if( subject.contains( ";" ) ) {
				contactStr = subject.mid( subject.find( ";" ) + 1 );
				subject = subject.left( subject.find( ";" ) );
			}
			for ( it.toFirst(); it.current(); ++it ) {
				if( subject == it.current()->getSubject() &&
				    it.current()->getCallStatus() != SipCall::callDead ) {
					if( !contactStr.isEmpty() ) {
						it.current()->setContactStr( contactStr );
					} else {
						it.current()->setContactStr( subject );
					}
					find = true;
					break;
				}
			}
			if( !find ) {
				newcall = new SipCall( user, QString::null, SipCall::outSubscribeCall );
				newcall->setSubject( uristr );
				SipUri remoteuri( uristr );
				member = new SipCallMember( newcall, remoteuri );
				connect( member, SIGNAL( statusUpdated( SipCallMember * ) ),
					clist, SLOT( auditList() ) );
				connect( member, SIGNAL( statusUpdated( SipCallMember * ) ),
					sipauthentication, SLOT( authRequest( SipCallMember * ) ) );
				member->requestSubscribe( subscribeExpiresTime );
				if( !contactStr.isEmpty() ) {
					newcall->setContactStr( contactStr );
				} else {
					newcall->setContactStr( subject );
				}
			}
		}
	}
	clist->auditList();
}

void KPhoneView::localStatusUpdate( void )
{
	QString subject;
	QIconSet icon;
	SipCallIterator it( client->getCallList() );
	if( reg == 0 ) {
		return;
	}
	if( setSubscribeOffline && reg->getRegisterState() == SipRegister::Connected ) {
		setSubscribeOffline = false;
		isOnline = false;
		QIconSet icon;
		icon.setPixmap(SHARE_DIR "/icons/offline.png", QIconSet::Automatic );
		buttonOffOnline->setIconSet( icon );
		buttonUpdate->setEnabled( false );
		buttonOffOnline->setEnabled( false );
		it.toFirst();
		for( it.toFirst(); it.current(); ++it ) {
			if( it.current()->getCallType() == SipCall::outSubscribeCall ) {
				if( it.current()->getCallStatus() == SipCall::callInProgress ) {
					SipCallMember *member = it.current()->getMemberList().toFirst();
					if( member ) {
						member->requestClearSubscribe();
					}
				}
			}
		}
	} else {
		if( reg->getRegisterState() == SipRegister::NotConnected ) {
			isOnline = false;
			QIconSet icon1;
			icon1.setPixmap(SHARE_DIR "/icons/offline.png", QIconSet::Automatic );
			buttonOffOnline->setIconSet( icon1 );
			buttonUpdate->setEnabled( false );
			buttonOffOnline->setEnabled( false );
		} else if( reg->getRegisterState() == SipRegister::Connected ) {
			if( buttonSetOffline ) {
				buttonOffOnline->setEnabled( true );
			} else {
				isOnline = true;
				QIconSet icon2;
				icon2.setPixmap(SHARE_DIR "/icons/online.png", QIconSet::Automatic );
				buttonOffOnline->setIconSet( icon2 );
				buttonUpdate->setEnabled( true );
				buttonOffOnline->setEnabled( true );
				it.toFirst();
				for( it.toFirst(); it.current(); ++it ) {
					if( it.current()->getCallType() == SipCall::outSubscribeCall ) {
						if( it.current()->getCallStatus() != SipCall::callDead ) {
							SipCallMember *member = it.current()->getMemberList().toFirst();
							if( member ) {
								member->requestSubscribe( subscribeExpiresTime );
							}
						}
					}
				}
			}
		}
	}
}

void KPhoneView::buttonOffOnlineClicked( void )
{
	if( isOnline ) {
		buttonSetOffline = true;
		isOnline = false;
		buttonUpdate->setEnabled( false );
		stateComboBox->setEnabled( false );
		QIconSet icon1;
		icon1.setPixmap(SHARE_DIR "/icons/offline.png", QIconSet::Automatic );
		buttonOffOnline->setIconSet( icon1 );
		stateUpdated( OFFLINE );
	} else {
		buttonSetOffline = false;
		isOnline = true;
		buttonUpdate->setEnabled( true );
		stateComboBox->setEnabled( true );
		QIconSet icon2;
		icon2.setPixmap(SHARE_DIR "/icons/online.png", QIconSet::Automatic );
		buttonOffOnline->setIconSet( icon2 );
		stateUpdated( ONLINE );
	}
}

void KPhoneView::buttonUpdateClicked( void )
{
	if( isOnline ) {
		stateUpdated( ONLINE );
	}
}

void KPhoneView::stateUpdated( int id )
{
	QString subject;
	if( id == OFFLINE ) {
		isOnline = false;
		buttonUpdate->setEnabled( false );
		QIconSet icon;
		icon.setPixmap(SHARE_DIR "/icons/offline.png", QIconSet::Automatic );
		buttonOffOnline->setIconSet( icon );
	}
	SipCallIterator it( client->getCallList() );
	it.toFirst();
	for( it.toFirst(); it.current(); ++it ) {
		if( it.current()->getCallType() == SipCall::inSubscribeCall ) {
			if( it.current()->getCallStatus() == SipCall::callInProgress ) {
				SipCallMember *member = it.current()->getMemberList().toFirst();
				if( member ) {
					sendNotify( id, member );
				}
			} else {
				delete it.current();
			}
		}
	}
}

QString KPhoneView::stateText( QString text )
{
  QString state;
  if( text == "Online" ) {
		state = "online";
	} else if( text == "Busy" ) {
		state = "busy";
	} else if( text == "Be Right Back" ) {
		state = "berightback";
	} else if( text == "Away" ) {
		state = "away";
	} else if( text == "On The Phone" ) {
		state = "onthephone";
	} else if( text == "Out To Lunch" ) {
		state = "outtolunch";
	} else {
		state = text;
	}
  return state;
}


void KPhoneView::sendNotify( int id, SipCallMember *member )
{
	QString s;
	QString tmp;
	s =  "<?xml version=\"1.0\"?>\n";
	s += "<!DOCTYPE presence\n";
	s += "PUBLIC \"-//IETF//DTD RFCxxxx XPIDF 1.0//EN\" \"xpidf.dtd\">\n";

	s += "<presence>\n";
	s += "<presentity uri=\"";
	s += member->getUri().reqUri();
	s += ";method=SUBSCRIBE\"/>\n";
	s += "<atom id=\"";
	s += tmp.setNum( atomId++ ).latin1();
	s += "\">\n";
	s += "<address uri=\"";
	s += client->getContactUri().reqUri();
	s += ";user=ip\" priority=\"0,800000\">\n";
	s += "<status status=\"open\"/>\n";
	if( id == ONLINE ) {
		if( stateComboBox->currentText().isEmpty() ) {
			s += "<msnsubstatus substatus=\"online\"/>\n";
		} else {
			s += "<msnsubstatus substatus=\"";
			s += stateText( stateComboBox->currentText() );
			s += "\" />\n";
		}
	} else {  
		s += "<msnsubstatus substatus=\"\"/>\n";
	}
	s += "</address>\n";
	s += "</atom>\n";
	s += "</presence>\n";
	if( stateComboBox->currentText().lower() == "busy" ) {
		client->setBusy( true );
	} else {
		client->setBusy( false );
	}
	if( member != 0 ) {
		if( id == OFFLINE ) {
			member->requestClearNotify( s.latin1(), MimeContentType( "application/xpidf+xml" ) );
		} else {
			if( !buttonSetOffline ) {
				member->requestNotify( s.latin1(), MimeContentType( "application/xpidf+xml" ) );
			}
		}
	}
}

void KPhoneView::redirectCall( const SipUri &calluri, const QString &subject )
{
	SipCall *newcall = new SipCall( user );
	newcall->setSubject( subject );
	KCallWidget *widget = new KCallWidget( sipauthentication, callAudio, newcall, this );
	cwList.append( widget );
	widget->pleaseDial( calluri );
	connect( widget, SIGNAL( redirectCall( const SipUri &, const QString & ) ),
		this, SLOT( redirectCall( const SipUri &, const QString & ) ) );
	widget->show();
}

void KPhoneView::makeNewCall( void )
{
	updateWidgetList();
	if( !buttonSipUri->text().compare( "Set Identity" ) ){
		QMessageBox::information( this, "KPhone", "Set First Identity." );
		return;
	}
	SipCall *newcall = new SipCall( user, QString::null, SipCall::StandardCall );
	QString subject;
	subject.sprintf( user->getUri().uri() );
	newcall->setSubject( subject );
	KCallWidget *widget = new KCallWidget( sipauthentication, callAudio, newcall, this );
	cwList.append( widget );
	widget->setRemote( lineeditCall->text() );
	if( !lineeditCall->text().isEmpty() ) {
		widget->clickDial();
	}
	lineeditCall->setText("");
	connect( widget, SIGNAL( redirectCall( const SipUri &, const QString & ) ),
		this, SLOT( redirectCall( const SipUri &, const QString & ) ) );
	widget->show();
}

void KPhoneView::makeVideoCall( void )
{
	updateWidgetList();
	if( !buttonSipUri->text().compare( "Set Identity" ) ){
		QMessageBox::information( this, "KPhone", "Set First Identity." );
		return;
	}
	SipCall *newcall = new SipCall( user, QString::null, SipCall::videoCall );
	QString subject;
	subject.sprintf( user->getUri().uri() );
	newcall->setSubject( subject );
	KCallWidget *widget = new KCallWidget( sipauthentication, callAudio, newcall, this );
	cwList.append( widget );
	widget->setRemote( lineeditCall->text() );
	if( !lineeditCall->text().isEmpty() ) {
		widget->clickDial();
	}
	lineeditCall->setText("");
	connect( widget, SIGNAL( redirectCall( const SipUri &, const QString & ) ),
		this, SLOT( redirectCall( const SipUri &, const QString & ) ) );
	widget->show();
}

void KPhoneView::updateIdentity( SipUser *newUser, SipRegister *newReg )
{
	if( newReg != 0 ) {
		if( reg != 0 ) {
			disconnect( reg, SIGNAL( statusUpdated() ), this, SLOT( localStatusUpdate() ) );
		}
		reg = newReg;
		connect( reg, SIGNAL( statusUpdated() ), this, SLOT( localStatusUpdate() ) );
		localStatusUpdate();
	}
	buttonSipUri->setText( newUser->getUri().uri() );
	user = newUser;
}

void KPhoneView::busyToggled( bool onoff )
{
	client->setBusy( onoff );
}

void KPhoneView::showIdentities( void )
{
	identitiesDialog->showIdentity();
}

void KPhoneView::identities( KSipRegistrations *i )
{
	identitiesDialog = i;
}

void KPhoneView::setContactsOffline( void )
{
	stateUpdated( KPhoneView::OFFLINE );
	setSubscribeOffline = true;
	localStatusUpdate();
}

void KPhoneView::setContactsOnline( void )
{
	stateUpdated( KPhoneView::ONLINE );
}

void KPhoneView::kphoneQuit( void )
{
	KCallWidget *widget;
	for( widget = cwList.first(); widget != 0; widget = cwList.next() ) {
		if( widget->isHided() ) {
			cwList.remove( widget );
		} else {
			widget->clickHangup();
		}
	}
	setContactsOffline();
	identitiesDialog->unregAllRegistration();
}

QString KPhoneView::getUserPrefix( void )
{
	return ((KPhone *)parentWidget())->getUserPrefix();
}

void KPhoneView::saveRejectContactList( void )
{
	QSettings settings;
	QString p = "/kphone/" + getUserPrefix() + "/presence/";
	QString label;
	int count = 0;
	label.setNum( count );
	label = p + "/Rejected" + label;
	QString s = settings.readEntry( label, "" );
	while( !s.isEmpty() ) {
		settings.writeEntry( label, "");
		label.setNum( ++count );
		label = p + "/Rejected" + label;
		s = settings.readEntry( label, "" );
	}
	count = 0;
	for ( QStringList::Iterator it = rejectedContactList.begin(); it != rejectedContactList.end(); ++it ) {
		label.setNum( count++ );
		label = p + "/Rejected" + label;
		settings.writeEntry( label, QString(*it) );
	}
}

void KPhoneView::updateWidgetList( void )
{
	KCallWidget *widget;
	for( widget = cwList.first(); widget != 0; widget = cwList.next() ) {
		if( widget->isHided() ) {
			cwList.remove( widget );
		}
	}
}
