/*
   Copyright (C) 2006 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

// settings.cpp

#include "settings.h"

#include <kconfig.h>
#include <kglobal.h>


#define KOA_DEFAULT_CD_DEVICE "/dev/cdrom"
#define KOA_DEFAULT_CDDB_SERVER "http://freedb.freedb.org"
#define KOA_DEFAULT_CDDB_PORT 80


namespace KoverArtist
{

Settings* Settings::sInstance = 0;


Settings::Settings()
:localImages(true)
,removeImageBorders(true)
,cdDevice(KOA_DEFAULT_CD_DEVICE)
,cddbServer(KOA_DEFAULT_CDDB_SERVER)
,cddbPort(KOA_DEFAULT_CDDB_PORT)
,cddbAutoSetTitle(true)
{
}


void Settings::load()
{
   KConfig *cfg = KGlobal::config();

   cfg->setGroup("Globals");
   localImages = cfg->readBoolEntry("local_images", true);
   removeImageBorders = cfg->readBoolEntry("remove_image_borders", true);

   cfg->setGroup("AudioCD");
   cdDevice = cfg->readEntry("cd_device", KOA_DEFAULT_CD_DEVICE);
   cddbServer = cfg->readEntry("cddb_server", KOA_DEFAULT_CDDB_SERVER);
   cddbPort = cfg->readNumEntry("cddb_port", KOA_DEFAULT_CDDB_PORT);
   cddbAutoSetTitle = cfg->readBoolEntry("cddb_auto_set_title", true);
}


void Settings::sync()
{
   KConfig *cfg = KGlobal::config();

   cfg->setGroup("Globals");
   cfg->writeEntry("local_images", localImages);
   cfg->writeEntry("remove_image_borders", removeImageBorders);

   cfg->setGroup("AudioCD");
   cfg->writeEntry("cd_device", cdDevice);
   cfg->writeEntry("cddb_server", cddbServer);
   cfg->writeEntry("cddb_port", cddbPort);
   cfg->writeEntry("cddb_auto_set_title", cddbAutoSetTitle);

   cfg->sync();
}


} //namespace
