/*
 * Copyright (C) 2006 Bernhard Beschow <bbeschow @ cs.tu-berlin.de>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */
#include "thinklightplugin.h"

#include <kopete/kopetechatsessionmanager.h>
#include <kopete/kopeteuiglobal.h>
#include "thinklightconfig.h"

#include <kgenericfactory.h>
#include <kpassivepopup.h>
#include <knotifyclient.h>
#include <kiconloader.h>

#include <qfileinfo.h>
#include <qpixmap.h>

ThinkLightPlugin *ThinkLightPlugin::s_pPlugin = 0;

typedef KGenericFactory<ThinkLightPlugin> ThinkLightPluginFactory;
K_EXPORT_COMPONENT_FACTORY( kopete_thinklight, ThinkLightPluginFactory( "kopete_thinklight" )  )

ThinkLightPlugin::ThinkLightPlugin( QObject *parent, const char *name, const QStringList & /* args */ ) :
	Kopete::Plugin( ThinkLightPluginFactory::instance(), parent, name ),
	m_toggles( 0 ),
	m_msecs( ThinkLightConfig::self()->duration() * 100 ),
	m_numFlashes( ThinkLightConfig::self()->numFlashes() ),
	m_initProcess( ThinkLightConfig::self()->initScript() )
{
	if ( s_pPlugin != 0 )
		return;

	s_pPlugin = this;

	connect( Kopete::ChatSessionManager::self() , SIGNAL( aboutToReceive( Kopete::Message & ) ) , this, SLOT( handleEvent() ) );

	connect( this , SIGNAL( settingsChanged() ) , this , SLOT( settingsChanged() ) );

	connect( &m_timer, SIGNAL( timeout() ), SLOT( toggle() ) );

	connect( &m_initProcess, SIGNAL( processExited() ), SLOT( initFinished() ) );

	m_initProcess.launch( QByteArray() );
}

void ThinkLightPlugin::settingsChanged()
{
	ThinkLightConfig::self()->readConfig();

	/*
	 * Apply duration changes
	 */
	m_msecs = ThinkLightConfig::self()->duration() * 100;

	if ( m_timer.isActive() )
		m_timer.changeInterval( m_msecs );

	/*
	 * Apply number of flashes changes
	 */
	m_toggles = ( m_toggles / m_numFlashes ) * ThinkLightConfig::self()->numFlashes() + ( m_toggles % 2 );

	m_numFlashes = ThinkLightConfig::self()->numFlashes();

	/// @todo rerun init script

	handleEvent();
}

void ThinkLightPlugin::initFinished()
{
#if 0
	if ( m_initProcess.exitStatus() != 0 )
	{
		KPassivePopup::message( i18n( "Kopete Thinklight" ),
		                        i18n( "The program \"kopete_thinklght_fixpermissons\" could not successfully set the device permissions for the Thinklight device.\n\n"
		                              "There's something wrong with your setup. Please contact your system administrator." ),
		                        QPixmap(),
		                        Kopete::UI::Global::mainWidget() );
#endif

	QString appName = QString::fromAscii( KNotifyClient::instance()->instanceName() );
	KIconLoader iconLoader( appName );
	KConfig eventsFile( QString::fromAscii( KNotifyClient::instance()->instanceName()+"/eventsrc" ), true, false, "data");
	KConfigGroup config( &eventsFile, "!Global!" );
	QString iconName = config.readEntry( "IconName", appName );
	QPixmap icon = iconLoader.loadIcon( iconName, KIcon::Small );
	QString title = config.readEntry( "Comment", appName );

	if ( !QFileInfo( ThinkLightConfig::self()->path() ).exists() )
		KPassivePopup::message( i18n( "Kopete Thinklight" ),
		                        i18n( "%1 does not exist!\n\n"
		                              "Please do a \"modprobe ibm_acpi\" as root." ).arg( ThinkLightConfig::self()->path() ),
		                        icon,
		                        Kopete::UI::Global::mainWidget() );
	else if ( !QFileInfo( ThinkLightConfig::self()->path() ).isWritable() )
		KPassivePopup::message( i18n( "Kopete Thinklight" ),
		                        i18n( "%1 cannot be written to!\n\n"
		                              "There's something wrong with your setup. Please contact your system administrator." ).arg( ThinkLightConfig::self()->path() ),
		                        icon,
		                        Kopete::UI::Global::mainWidget() );
}

void ThinkLightPlugin::handleEvent()
{
	m_toggles += 2 * m_numFlashes;

	if ( !m_timer.isActive() )
		m_timer.start( m_msecs );

	toggle();
}

void ThinkLightPlugin::toggle()
{
	QFile lightFile( ThinkLightConfig::self()->path() );
	lightFile.open( IO_ReadWrite );

	QString str = QTextStream( &lightFile ).readLine();

	if ( str.find( "on" ) != -1 )
		lightFile.writeBlock( "off\n", 4 );
	else if ( str.find( "off" ) != -1 )
		lightFile.writeBlock( "on\n", 3 );

	m_toggles--;

	if ( m_toggles == 0 )
		m_timer.stop();
}

#include "thinklightplugin.moc"
