/***************************************************************************
 *   Copyright (C) 2005 by Daniel Stöckel                                  *
 *   the_docter@gmx.net                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MENU_H
#define MENU_H

#include <qbuttongroup.h>
#include <qptrlist.h>

#include "roundbutton.h"

#define BUTTON_DESELECT -1000


class Menu : public QButtonGroup
{
	Q_OBJECT
	public:
		Menu(Menu* parentMenu=NULL);
		virtual ~Menu();
		
		virtual Menu* parentMenu(){ return mParentMenu; }
		virtual void setParentMenu(Menu* menu){ mParentMenu=menu; }
		
		virtual void addChild(Menu* menu);
		virtual void selectButton(int num);
		virtual void selectButton(QButton* button);
		virtual int childCount(){ return children.count(); }
		virtual void showButtons();
		virtual void hideButtons();
		virtual void arrangeButtons();

		virtual Menu* execute();

		virtual int insert ( QButton * button, int id = -1 );

		void setIconPath(const QString& theValue){ mIconPath = theValue; }
		QString IconPath() const{ return mIconPath; }

		int selectedButtonNum() const { return mSelectedButtonNum; }
		virtual QButton* selectedButton();

	signals:
		virtual void buttonSelected(int type);
		
	protected:
		Menu* mParentMenu;
		QString mIconPath;
		QPtrList<Menu> children;
		int mSelectedButtonNum;

	protected slots:
		void slotMouseIn(RoundButton* emitter);
		void slotMouseOut();
};

#endif
