/***************************************************************************
 *   Copyright (C) 2005 by Daniel Stöckel                                  *
 *   the_docter@gmx.net                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "configuration.h"

#include <qfile.h>
#include <stdlib.h>

#include "menulistviewitem.h"

Config::Config()
	:doc(NULL),mTintColor(Qt::black),mOpacity(0.2f)
{
}

Config::~Config()
{
	if(doc){
		delete doc;
	}
}

bool Config::readConfigFile( )
{
	QFile file(mConfigPath);
	if(!file.open(IO_ReadOnly)){
		return false;
	}
	if(doc){
		delete doc;
	}
	doc = new QDomDocument();
	doc->setContent( &file );
	file.close();
	
	return true;
}

bool Config::writeConfigFile( )
{
	if(!doc){
		return false;
	}
	QFile file(mConfigPath);
	if(!file.open(IO_WriteOnly)){
		return false;
	}
	QTextStream str(&file);
	str << *doc;
	file.close();
	return true;
}

void Config::fromConfigDlg( const QListView* listView )
{
	if(doc){
		delete doc;
	}
	doc = new QDomDocument();
	QDomElement root=doc->createElement("root");
	doc->appendChild(root);
	
	QDomElement node = doc->createElement("access");
	node.setAttribute("method","shortcut");
	node.appendChild(doc->createTextNode(Shortcut()));
	root.appendChild(node);

	node=doc->createElement("tintcolor");
	node.appendChild(doc->createTextNode(tintColor().name()));
	root.appendChild(node);

	node=doc->createElement("opacity");
	char str_buf[20];
	sprintf(str_buf,"%f",mOpacity);
	node.appendChild(doc->createTextNode(str_buf));
	root.appendChild(node);
	
	node=doc->createElement("menu");
	QListViewItem* temp = listView->firstChild();
	while(temp){
		static_cast<MenuListViewItem*>(temp)->toXML(*doc,node);
		temp=temp->nextSibling();
	}
	root.appendChild(node);
}

void Config::toConfigDlg(QListView* listView )
{
	if(doc){
		QDomNode topLevelNode = doc->documentElement().firstChild();
		while(!topLevelNode.isNull()){
			if(topLevelNode.isElement()){
				if((topLevelNode.toElement().tagName()=="menu")&&topLevelNode.hasChildNodes())
				{
					QDomNode menuNode=topLevelNode.firstChild();
					MenuListViewItem* temp;
					while(!menuNode.isNull()){
						if(menuNode.isElement()){
							QDomElement elemNode =menuNode.toElement();
							if(elemNode.tagName()=="menu")
							{
								temp = new MenuListViewItem(listView,"Menu",MenuListViewItem::Menu);
								temp->setOpen(true);
								temp->fromXML(menuNode.toElement());
							} else if(elemNode.tagName()=="button"){
								temp = new MenuListViewItem(listView,"Button",MenuListViewItem::Button);
								temp->fromXML(menuNode.toElement());
							}
						}
						menuNode = menuNode.nextSibling();
					}
				} else if(topLevelNode.toElement().tagName()=="access"){
					setShortcut(topLevelNode.toElement().text());
				} else if(topLevelNode.toElement().tagName()=="tintcolor"){
					mTintColor.setNamedColor(topLevelNode.toElement().text());
				} else if(topLevelNode.toElement().tagName()=="opacity"){
					mOpacity=atof(topLevelNode.toElement().text());
				}
			}
			topLevelNode = topLevelNode.nextSibling();
		}
	}
}

void Config::toKommandoMenu(Kommando* buttonParent)
{
	if(doc){
		Menu* mainMenu= new Menu();
		buttonParent->setMainMenu(mainMenu);
		QDomNode node = doc->documentElement().firstChild();
		
		while(!node.isNull()){
			if(node.isElement()&&(node.toElement().tagName()=="menu")){
				break;
			}
			node=node.nextSibling();
		}
		mainMenu->fromXML(node.toElement(),buttonParent);				//recursive parsing of the menu structure
		buttonParent->setActMenu(mainMenu);
		buttonParent->setTintColor(mTintColor);
		buttonParent->setOpacity(opacity());
	}
}

void Config::setDefaultValues( QListView* listView )
{
	new MenuListViewItem(listView,"Button",MenuListViewItem::Button,"konsole","konsole --workdir $HOME");
	new MenuListViewItem(listView,"Button",MenuListViewItem::Button,"kwrite","kwrite");
	new MenuListViewItem(listView,"Button",MenuListViewItem::Button,"konqueror","konqueror");
	new MenuListViewItem(listView,"Button",MenuListViewItem::Button,"kcalc","kcalc");
	new MenuListViewItem(listView,"Button",MenuListViewItem::Button,"gimp","gimp");
	new MenuListViewItem(listView,"Button",MenuListViewItem::Button,"kfm_home","kfmclient openProfile filemanagement");
	new MenuListViewItem(listView,"Button",MenuListViewItem::Button,"kfind","kfind");
	MenuListViewItem* submenu = new MenuListViewItem(listView,"Menu",MenuListViewItem::Menu,"kmix");
	submenu->setOpen(true);
	new MenuListViewItem(submenu,"Button",MenuListViewItem::Button,"kmix","kmix");
	new MenuListViewItem(submenu,"Button",MenuListViewItem::Button,"k3b","k3b");
	new MenuListViewItem(submenu,"Button",MenuListViewItem::Button,"amarok","amarok");
	new MenuListViewItem(submenu,"Button",MenuListViewItem::Button,"kaffeine","kaffeine");
	setTintColor(Qt::black);
	setOpacity(0.2f);
	setShortcut("Alt+Ctrl+H");
}
