/* This file is part of the KDE project
   Copyright (C) 2006 Martin Pfeiffer <hubipete@gmx.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "MultiscriptElement.h"
#include <KoXmlWriter.h>

MultiscriptElement::MultiscriptElement( BasicElement* parent ) : BasicElement( parent )
{
    m_baseElement = new BasicElement( this );
    m_preSubscript = new BasicElement( this );
    m_preSuperscript = new BasicElement( this );
    m_postSubscript = new BasicElement( this );
    m_postSuperscript = new BasicElement( this );
}

MultiscriptElement::~MultiscriptElement()
{
    delete m_baseElement;
    delete m_preSubscript;
    delete m_preSuperscript;
    delete m_postSubscript;
    delete m_postSuperscript;
}

void MultiscriptElement::paint( QPainter& painter, AttributeManager* am )
{
}

void MultiscriptElement::layout( const AttributeManager* am )
{
}

BasicElement* MultiscriptElement::acceptCursor( CursorDirection direction )
{
    return 0;
}

const QList<BasicElement*> MultiscriptElement::childElements()
{
    return QList<BasicElement*>();
}

QString MultiscriptElement::attributesDefaultValue( const QString& attribute ) const
{
    return QString();
}

ElementType MultiscriptElement::elementType() const
{
    return MultiScript;
}

bool MultiscriptElement::readMathMLContent( const KoXmlElement& element )
{
    return false;
}

void MultiscriptElement::writeMathMLContent( KoXmlWriter* writer ) const
{
    m_baseElement->writeMathML( writer );
}
