/***************************************************************************
                          knutrwvar.cpp  -  description
                             -------------------
    begin                : So rj 26 2002
    copyright            : (C) 2002 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 
#include "knutrwvar.h"
#include "knutvardata.h"
#include "knutprintupsvar.h"

//Od verze 3 je kapp jen odkaz na kapplication
//#include <kapplication.h>
#include <kapp.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <klocale.h>


#include <qframe.h>
#include <qlabel.h>
#include <qstring.h>
#include <qlayout.h>


//#include <iostream>

KNutRWVar::KNutRWVar(QString* userName, QString* userPassword, const QString uName, const QString password, KNutNet* const initUpsNet, QWidget* parent, const char* name, const bool modal)
: KDialogBase(Plain, i18n("RW variables"),Ok|Cancel|Default,Ok, parent, name, modal, true), myUpsNet(initUpsNet){
  struct upsVar myStructVar;

//  int error;

  if (myUpsNet->getState() != KNutNet::Connected) {
    KNutVarData::showError (KNutNet::NotConnection);
    upsConnectOk = false;
    }
  else {
    oldUserName = userName;
    oldUserPassword = userPassword;

    upsConnectOk = true;
    QFrame *page = plainPage();
    QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );
    QLabel *label1 = new QLabel (i18n("SET RW VARIABLE"),page,"label1");
    label1->setAlignment(Qt::AlignHCenter);
    topLayout->addWidget(label1);


    QLabel *label2 = new QLabel (i18n("Variable:"),page,"label2");
    rWVarBox = new KComboBox(page,"rwvarbox");

    QLabel *label3 = new QLabel (i18n("Value:"),page,"label2");
    valueVarBox = new KComboBox(page,"valuevarbox");
    valueVarLine = new KLineEdit(page,"valuevarLine");
    valueVarLine->hide();
   
    passLayout = new QGridLayout (4,2,5,"passLayout");
    QLabel *labelName = new QLabel (i18n("User name:"),page,"labelName");
    QLabel *labelPassword = new QLabel (i18n("Password:"),page,"labelPassword");
    lineEditName = new KLineEdit( page, "LineEditName" );
    lineEditPassword = new KLineEdit( page, "LineEditName" );


    if (((*oldUserName) == "") && ((*oldUserPassword) == "")) {
      lineEditName->setText(uName);
      lineEditPassword->setText(password);
      }
    else {
      lineEditName->setText(*oldUserName);
      lineEditPassword->setText(*oldUserPassword);
      }

    if (!((*oldUserName) == "") || !((*oldUserPassword) == "")) {
      lineEditName->setDisabled(true);
      lineEditPassword->setDisabled(true);
      }

    lineEditPassword->setEchoMode(QLineEdit::Password);

    topLayout->addLayout(passLayout);

    passLayout->addWidget(label2,0,0);
    passLayout->addWidget(rWVarBox,0,1);
    passLayout->addWidget(label3,1,0);
    passLayout->addWidget(labelName,2,0);
    passLayout->addWidget(labelPassword,3,0);
    passLayout->addWidget(lineEditName,2,1);
    passLayout->addWidget(lineEditPassword,3,1);

    topLayout->addStretch(10);
   //naplnime ComboBox
    int n;
    if (( n = (myUpsNet->readNumberVars( KNutNet::RWVars )+1)) > 1 ) { // zvetsime si pocet o 1
      for (int i =1; i < n ; i++) {
        if (!myUpsNet->readVars(i, myStructVar,KNutNet::RWVars))
          rWVarBox->insertItem(myStructVar.upsVarName);
        }
      slotChangeVar(0);
      }
    else {
      passLayout->addWidget(valueVarLine,1,1);
      valueVarLine->setMaxLength(myStructVar.upsVarMax);
      valueVarBox->hide();
      valueVarLine->show();
      upsValueType=true;
      }
    connect (rWVarBox,SIGNAL(activated(int)),this,SLOT(slotChangeVar(int)));
    }
  }

int KNutRWVar::findItem(const KComboBox *myBox, const QString text) {
  int n;

  if ((n=myBox->count())) {
    for (int i =0; i < n; i++)
      if (text == myBox->text(i)) return i;
    }
  return myBox->currentItem();  
  }

            
void KNutRWVar::slotDefault () {
  struct upsVar myStructVar;
  int error;
  
  QString varName = rWVarBox->currentText();
  if (!( error = myUpsNet->readVars(varName,myStructVar))) {
    if (myStructVar.upsValueType) valueVarLine->setText(myStructVar.upsValue);
    else valueVarBox->setCurrentItem(myStructVar.upsValue);
    }
  else KNutVarData::showError (error);
  }  

void KNutRWVar::slotChangeVar(int item) {
  struct upsVar myStructVar;

  QString varName = rWVarBox->text(item);
  int error = myUpsNet->readVars(varName,myStructVar);
  upsValueType=myStructVar.upsValueType;
  if (error || (myStructVar.upsValueType)) {
    // char
    valueVarBox->hide();
    valueVarLine->show();
    passLayout->addWidget(valueVarLine,1,1);
    valueVarLine->setText(myStructVar.upsValue);
    }
  else {
    //enum
    valueVarLine->hide();
    valueVarBox->show();
    passLayout->addWidget(valueVarBox,1,1);
    valueVarBox->clear();
    if (myStructVar.upsVarMax) {
      for (int i = 0 ; i < myStructVar.upsVarMax; i++)
        valueVarBox->insertItem(myUpsNet->readEnumValueVar(myStructVar.upsVarName,i+1));
      }
    valueVarBox->setCurrentItem(myStructVar.upsValue);
    }
  }



KNutRWVar::~KNutRWVar(){
}

bool KNutRWVar::upsOk (void) { return upsConnectOk; }


void KNutRWVar::slotOk() {
  QString value;
  int error =0;
  if (upsValueType) value=valueVarLine->text();
  else value=valueVarBox->currentText();

  if (((*oldUserName) == "") && ((*oldUserPassword) == "")) {
    //the first connection sets name and password
    //prvni propojeni nastavime jmeno a heslo
    if (!(error = myUpsNet->setVariable(rWVarBox->currentText(), value, lineEditName->text(),lineEditPassword->text(),false))) {
      // vzhledem k asynchronimu spracovani asi zbytecne
//      myUpsNet->getUpsValues(true);
      emit signalChangeRWVars(rWVarBox->currentText()); //dame prikaz k natazeni promene
                                                        // a pripadne k prekresleni panelu
      (*oldUserName) = lineEditName->text();
      (*oldUserPassword) = lineEditPassword->text();
      accept();
      }
    }
  else {
    if (((*oldUserName) == lineEditName->text()) && ((*oldUserPassword) == lineEditPassword->text())) {
      if (!(error = myUpsNet->setVariable(rWVarBox->currentText(), value, lineEditName->text(),lineEditPassword->text(),true))) {
      // next line isn't needed, maybe
      // vzhledem k asynchronimu spracovani asi zbytecne
//        myUpsNet->getUpsValues(true);
        emit signalChangeRWVars(rWVarBox->currentText()); //dame prikaz k natazeni promene
                                                      // a pripadne k prekresleni panelu
        accept();
        }
      }
    }
  //Nahlasime chybu
  if (error) KNutVarData::showError (error);
  }

#include "knutrwvar.moc"
