/***************************************************************************
                          knutinstcomms.cpp  -  description
                             -------------------
    begin                : ct rj 24 2002
    copyright            : (C) 2002 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutinstcomms.h"
#include "knutprintupsvar.h"
#include "knutvardata.h"

#include <kcombobox.h>
#include <kmessagebox.h>


#include <qlayout.h> 
#include <qframe.h>
#include <qlabel.h>
#include <qstring.h>


KNutInstComms::KNutInstComms(QString* userName, QString* userPassword, const QString uName, const QString password, KNutNet* const upsNet, QWidget* parent,  const char* name, const bool modal)
: KDialogBase(Plain, i18n("Instant commands"),Ok|Cancel,Ok, parent, name, modal, true), myUpsNet(upsNet) {
  upsIComm myStructIComm;

   
   if (myUpsNet->getState() != KNutNet::Connected) {
     KNutVarData::showError (KNutNet::NotConnection);
     upsConnectOk=false;
     }
  else {
    oldUserName = userName;
    oldUserPassword = userPassword;

    upsConnectOk=true;
    QFrame *page = plainPage();
    QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );
    QLabel *label1 = new QLabel (i18n("RUN INSTANT COMMAND"),page,"label1");
    label1->setAlignment(Qt::AlignHCenter);
    topLayout->addWidget(label1);
   
    QLabel *label2 = new QLabel (i18n("Command:"),page,"label2");
    instCommBox = new KComboBox(page,"instcommbox");

    QGridLayout *passLayout = new QGridLayout (3,2,5,"passLayout");
    QLabel *labelName = new QLabel (i18n("User name:"),page,"labelName");
    QLabel *labelPassword = new QLabel (i18n("Password:"),page,"labelPassword");
    lineEditName = new KLineEdit( page, "LineEditName" );
    lineEditPassword = new KLineEdit( page, "LineEditName" );
    if (((*oldUserName) == "") && ((*oldUserPassword) == "")) {
      lineEditName->setText(uName);
      lineEditPassword->setText(password);
      }
    else {
      lineEditName->setText(*oldUserName);
      lineEditPassword->setText(*oldUserPassword);
      }

    if (!((*oldUserName) == "") || !((*oldUserPassword) == "")) {
      lineEditName->setDisabled(true);
      lineEditPassword->setDisabled(true);
      }

    lineEditPassword->setEchoMode(QLineEdit::Password);
     
    topLayout->addLayout(passLayout);

    passLayout->addWidget(label2,0,0);
    passLayout->addWidget(instCommBox,0,1);

    passLayout->addWidget(labelName,1,0);
    passLayout->addWidget(labelPassword,2,0);
    passLayout->addWidget(lineEditName,1,1);
    passLayout->addWidget(lineEditPassword,2,1);

    topLayout->addStretch(10);

   //naplnime ComboBox
    int n = myUpsNet->readNumberComms()+1;
    for (int i =1; i < n ; i++) { // for se testuje na zacatku pokud je n < 1 neprovede se ani jednou
      if (!myUpsNet->readIComm(i, myStructIComm))
        instCommBox->insertItem(myStructIComm.upsCommName);
      }
    }                        
  }

KNutInstComms::~KNutInstComms(){
}


void KNutInstComms::slotOk() {
  int error =0;

  if (((*oldUserName) == "") && ((*oldUserPassword) == "")) {
    // prvni propojeni nastavime jmeno a heslo
    if (!( error = myUpsNet->instantCommand(instCommBox->currentText(),lineEditName->text(),lineEditPassword->text(),false))) {
      (*oldUserName) = lineEditName->text();
      (*oldUserPassword) = lineEditPassword->text();
      accept();
      }
    }
  else {
    if (((*oldUserName) == lineEditName->text()) && ((*oldUserPassword) == lineEditPassword->text())) {
      // jen posleme prikaz
      if (!( error = myUpsNet->instantCommand(instCommBox->currentText(),lineEditName->text(),lineEditPassword->text(),true))) accept();
      }
// az v pristi verzi
//    else
//      {
//      // odpojime a pripojime
//      // nastavime jmeno a heslo
//      if (!( error = myUpsNet->instantCommand(instCommBox->currentText(),lineEditName->text(),lineEditPassword->text(),false))) {
//        (*oldUserName) = lineEditName->text();
//        (*oldUserPassword) = lineEditPassword->text();
//        accept();
//        }
//      }
    }
  if (error) KNutVarData::showError (error);
  }

bool KNutInstComms::upsOk (void) { return upsConnectOk; }


