/***************************************************************************
 *   Copyright (C) 2005 by Judd Baileys                                    *
 *   jbaileys@bigpond.net.au                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

 #ifndef _DEVICES_H_
#define _DEVICES_H_

#include "knetconfig.h"

static const char *devices[] = {
#ifdef __FreeBSD__
  "/dev/cuaa0",
  "/dev/cuaa1",
  "/dev/cuaa2",
  "/dev/cuaa3",
  "/dev/cuaa4",
#elif defined(__NetBSD__)
  "/dev/tty00",                /* "normal" modem lines */
  "/dev/tty01",
  "/dev/tty02",
  "/dev/tty03",
  "/dev/dty00",                /* Dial out devices */
  "/dev/dty01",
  "/dev/dty02",
  "/dev/dty03",
  "/dev/ttyU0",                /* USB stuff modems */
  "/dev/ttyU1",
  "/dev/ttyU2",
  "/dev/ttyU3",
  "/dev/dtyU0",                /* USB stuff, too (dial out device) */
  "/dev/dtyU1",
  "/dev/dtyU2",
  "/dev/dtyU3",
#elif defined (__linux__)
  "/dev/modem",
  "/dev/ttyS0",
  "/dev/ttyS1",
  "/dev/ttyS2",
  "/dev/ttyS3",
  "/dev/ttyS4",
#ifdef ISDNSUPPORT
  "/dev/ttyI0",
  "/dev/ttyI1",
  "/dev/ttyI2",
  "/dev/ttyI3",
#endif
  "/dev/usb/ttyACM0",          /* USB stuff modems */
  "/dev/usb/ttyACM1",
  "/dev/usb/ttyACM2",
  "/dev/usb/ttyACM3",
  "/dev/usb/ttyUSB0",          /* USB stuff modems */
  "/dev/usb/ttyUSB1",
  "/dev/usb/ttyUSB2",
  "/dev/usb/ttyUSB3",
  "/dev/usb/tts/0",          /* USB stuff modems with devfs*/
  "/dev/usb/tts/1",
  "/dev/usb/tts/2",
  "/dev/usb/tts/3",
  "/dev/rfcomm0",	       /* BlueTooth */
  "/dev/rfcomm1",
  "/dev/rfcomm2",
  "/dev/rfcomm3",
  "/dev/ircomm0",	       /* IrDA */
  "/dev/ircomm1",
  "/dev/ircomm2",
  "/dev/ircomm3",
  "/dev/ttySL0",           /* necessary for slmodem driver http://www.smlink.com*/
  "/dev/ttySL1",
  "/dev/ttySL2",
  "/dev/ttySL3",  
#elif defined(__svr4__)
  "/dev/cua/a",
  "/dev/cua/b",
  "/dev/ttya",
  "/dev/ttyb",
#endif
  0};

// default device number from the list above
const int DEV_DEFAULT = 0;

#endif
