/***************************************************************************
    Copyright (C) 2004 Christian Hubinger
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//
// C++ Interface: kmfruleoptioneditiip
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@gmail.com>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KMFRULEOPTIONEDITMAC_H
#define KMFRULEOPTIONEDITMAC_H

#include "../../interfaces/kmfruleoptioneditinterface.h"

// KDE includes
#include <kparts/part.h>
#include <kparts/plugin.h>
#include <kparts/factory.h>
#include <kxmlgui.h>

#include <qstring.h>
#include <qptrlist.h>

class IPTRule;
class KMFRuleEditMac;
/**
@author Christian Hubinger
*/
class KMFRuleOptionEditMAC : public KMFRuleOptionEditInterface {
	Q_OBJECT
public:
	KMFRuleOptionEditMAC(QObject *parent = 0, const char *name = 0);

	~KMFRuleOptionEditMAC();
	void loadRule( IPTRule* rule );	
	QWidget* editWidget();
	const QString& optionEditName() const;
	const QString& description() const;

private slots:
	void slotAddRuleOption(QString*, QPtrList< QString >* );
	void slotAddTargetOption(QString*, QPtrList< QString >* );
	void slotShowOverview();

private:
	KMFRuleEditMac *m_edit;
	IPTRule *m_rule;
	
};

class KInstance;

class KMFRuleOptionEditMACFactory : public KLibFactory {
	Q_OBJECT
public:
	KMFRuleOptionEditMACFactory( QObject *parent = 0, const char *name = 0 );
	virtual ~KMFRuleOptionEditMACFactory() {
/* 		delete s_instance; */
	};
	virtual QObject* createObject( QObject* parent = 0, const char* pname = 0,
	                               const char* name = "QObject",
	                               const QStringList &args = QStringList() );
	/*     static KInstance* instance(); */

/*private:
	static KInstance* s_instance;*/
};









#endif
