/***************************************************************************
 begin                : Wed May 22 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@gmail.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfruleedittargetlog.h" 

// QT includes
#include <qstring.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlineedit.h>

// kde includes
#include <kapplication.h>
#include <kdebug.h>

// MY includes
#include "../../core/iptrule.h"
#include "../../core/iptruleoption.h"
#include "../../core/iptchain.h"
#include "../../core/iptable.h"
#include "../../core/kmfdoc.h"
#include "../../core/kmfiptdoc.h"


KMFRuleEditTargetLog::KMFRuleEditTargetLog( QWidget *parent, const char *name, WFlags fl ) : KMyFirewallRuleEditorTargetLog( parent, name, fl ) {}
KMFRuleEditTargetLog::~KMFRuleEditTargetLog() {}

void KMFRuleEditTargetLog::loadRule( IPTRule* rule ) {
	kdDebug() << "void KMFRuleEditTargetLog::loadRule( IPTRule* rule )" << endl;
	c_log_tcp_seq->setChecked( false );
	c_log_tcp_options-> setChecked( false );
	c_log_ip_options->setChecked( false );
	c_log_prefix-> setChecked( false );
	c_log_level ->setChecked( false );
	cb_log_level->setCurrentItem( 0 );
	t_log_prefix->clear();
	m_rule = rule;
	IPTRuleOption *opt = 0;
	opt = m_rule->getOptionForName("target_log_opt");
	if (opt) {
		QStringList vals = opt->getValues();
		QString prefix = "";
		QString level = "";
		QString tcp_seq = "";
		QString tcp_opt = "";
		QString ip_opt = "";
		prefix = *vals.at(0);
		level = *vals.at(1);
		tcp_seq = *vals.at(2);
		tcp_opt = *vals.at(3);
		ip_opt =* vals.at(4);
		if ( !prefix.isEmpty() && prefix != "UNDEFINED" && prefix != "bool:off" ) {
			c_log_prefix->setChecked( true );
			prefix = prefix.right( prefix.length() -1);
			prefix = prefix.left( prefix.length() -1 );
			t_log_prefix->setText( prefix );
		} else {
			c_log_prefix->setChecked( false );
 			t_log_prefix->setText( "" );
		}
		if ( !level.isEmpty() && level != "UNDEFINED" && prefix != "bool:off") {
			c_log_level->setChecked( true );
			cb_log_level ->setCurrentText( level );
		} else {
			c_log_level->setChecked( false );
			cb_log_level ->setCurrentText( "" );
		}

		if ( tcp_seq == "bool:on" )
			c_log_tcp_seq->setChecked( true );
		else
			c_log_tcp_seq->setChecked( false );

		if ( tcp_opt == "bool:on" )
			c_log_tcp_options->setChecked( true );
		else
			c_log_tcp_options->setChecked( false );

		if ( ip_opt == "bool:on" )
			c_log_ip_options->setChecked( true );
		else
			c_log_ip_options->setChecked( false );
	}
}

void KMFRuleEditTargetLog::accept() {
	m_rule->chain()->table()->kmfDoc()->startTransaction();
	m_rule->saveState();
	QPtrList<QString>* args = new QPtrList<QString>;
	QString* name = new QString( "target_log_opt" );

	if ( c_log_prefix->isChecked() ) {
		QString val = t_log_prefix->text();
		val.prepend("\"");
		val.append("\"");
		args->append( ( new QString( val ) ) );
	} else {
		args->append( ( new QString("") ) );
	}

	if ( c_log_level->isChecked() ) {
		QString val = cb_log_level->currentText();
		args->append( ( new QString( val ) ) );
	} else {
		args->append( ( new QString("") ) );
	}

	if ( c_log_tcp_seq->isChecked() ) {
		QString val = "bool:on";
		args->append( ( new QString( val ) ) );
	} else {
		args->append( ( new QString("") ) );
	}

	if ( c_log_tcp_options->isChecked() ) {
		QString val = "bool:on";
		args->append( ( new QString( val ) ) );
	} else {
		args->append( ( new QString("") ) );
	}

	if ( c_log_ip_options->isChecked() ) {
		QString val = "bool:on";
		args->append( ( new QString( val ) ) );
	} else {
		args->append( ( new QString("") ) );
	}

	emit sigAddTargetOpt(name,args);
	emit sigDocumentChanged();
	m_rule->chain()->table()->kmfDoc()->endTransaction();
	emit sigHideMe();
}

void KMFRuleEditTargetLog::slotHelp() {
	kdDebug() << "void KMFRuleEditTargetLog::slotHelp()" << endl;
	kapp->invokeHelp( "targets" );
}
void KMFRuleEditTargetLog::reject() {
	kdDebug() << "void KMFRuleEditTargetLog::slotreject()" << endl;
	emit sigHideMe();
}
#include "kmfruleedittargetlog.moc"
