/***************************************************************************
 begin                : Wed Aug 21 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@gmail.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfxmlparser.h"

// qt includes
#include <qfile.h>
#include <qstring.h>
#include <qmessagebox.h>
#include <qregexp.h>

// kde includes
#include <klocale.h>
#include <kdebug.h>
#include <kurl.h>
#include <kapplication.h>
#include <kconfig.h> 
// project includes
#include "core/kmfdoc.h"
#include "core/kmfiptdoc.h"
#include "core/kmferror.h"
#include "core/kmferrorhandler.h"
#include "core/kmfconfig.h"
#include "core/iptable.h"
#include "core/iptchain.h"
#include "core/iptrule.h"


KMFXMLParser::KMFXMLParser() {
	kdDebug() << "KMFXMLParser::KMFXMLParser()" << endl;
	m_err = new KMFError();
	m_err_handler = new KMFErrorHandler( "KMFXMLParser" );
}
KMFXMLParser::~KMFXMLParser() {}

KMFIPTDoc* KMFXMLParser::parseKMFRS( const QString& fileName ) {
	kdDebug() << "KMFIPTDoc* KMFXMLParser::parseKMFRS(const QString& fileName)" << endl;
	kmfdoc = new KMFIPTDoc( 0, "kmfdoc_parser_output" );
	QFile kmfrsFile( fileName );
	if ( !kmfrsFile.open( IO_ReadOnly ) ) {
		return 0;
	}
	if ( !domTree.setContent( &kmfrsFile ) ) {
		kmfrsFile.close();
		return 0;
	}
	kmfrsFile.close();

	kdDebug() << "############ Start Parsing ############" << endl;
	kmfdoc->loadXML( domTree );
	kdDebug() << "########## Finished Parsing ###########" << endl;

/*	// parse document abstract
	QDomElement root = domTree.documentElement();
	QDomNode node;
	node = root.firstChild();
	while ( !node.isNull() ) {
		if ( node.isElement() && node.nodeName() == "abstract" ) {
			QDomElement abstract = node.toElement();
			parseDocumenmtAbstract( abstract );
		}
		node = node.nextSibling();
	}
	// parse document chains
	node = root.firstChild();
	while ( !node.isNull() ) {
		if ( node.isElement() && node.nodeName() == "chain" ) {
			QDomElement chain = node.toElement();
			m_err = parseIPTChain( chain );
			if ( m_err->errNum() > 0 ) {
				m_err_handler->showError( m_err );
			}
		}
		node = node.nextSibling();
	}
	// parse document rules
	node = root.firstChild();
	while ( !node.isNull() ) {
		if ( node.isElement() && node.nodeName() == "rule" ) {
			QDomElement rule = node.toElement();
			m_err = parseIPTRule( rule );
			if ( m_err->errNum() > 0 ) {
				m_err_handler->showError( m_err );
			}
		}
		node = node.nextSibling();
	}
*/
	return kmfdoc;
}

void KMFXMLParser::parseDocumenmtAbstract( const QDomElement &/*abstract*/ ) {
	kdDebug() << "void KMFXMLParser::parseDocumenmtAbstarct( const QDomElement &abstract )" << endl;
/*
	QDomNode node = abstract.firstChild();
	while ( !node.isNull() ) {
		if ( node.isElement() ) {
			kdDebug() << "Found Tag: " << node.nodeName() << endl;
			if ( node.nodeName() == "usefilter" ) {
				QDomText textChild = node.firstChild().toText();
				if ( node.toElement().attribute( "val" ) == "yes" )
					kmfdoc->setUseFilter( true );
				else
					kmfdoc->setUseFilter( false );
			} else if ( node.nodeName() == "usenat" ) {
				QDomText textChild = node.firstChild().toText();
				if ( node.toElement().attribute( "val" ) == "yes" )
					kmfdoc->setUseNat( true );
				else
					kmfdoc->setUseNat( false );
			} else if ( node.nodeName() == "usemangle" ) {
				QDomText textChild = node.firstChild().toText();
				if ( node.toElement().attribute( "val" ) == "yes" )
					kmfdoc->setUseMangle( true );
				else
					kmfdoc->setUseMangle( false );
			} else if ( node.nodeName() == "useipfwd" ) {
				QDomText textChild = node.firstChild().toText();
				if ( node.toElement().attribute( "val" ) == "yes" )
					kmfdoc->setUseIPFwd( true );
				else
					kmfdoc->setUseIPFwd( false );
			} else if ( node.nodeName() == "userpfilter" ) {
				QDomText textChild = node.firstChild().toText();
				if ( node.toElement().attribute( "val" ) == "yes" )
					kmfdoc->setUseRPFilter( true );
				else
					kmfdoc->setUseRPFilter( false );
			} else if ( node.nodeName() == "usemartians" ) {
				QDomText textChild = node.firstChild().toText();
				if ( node.toElement().attribute( "val" ) == "yes" )
					kmfdoc->setUseMartians( true );
				else
					kmfdoc->setUseMartians( false );
			} else if ( node.nodeName() == "usesyncookies" ) {
				QDomText textChild = node.firstChild().toText();
				if ( node.toElement().attribute( "val" ) == "yes" )
					kmfdoc->setUseSynCookies( true );
				else
					kmfdoc->setUseSynCookies( false );
			} else if ( node.nodeName() == "usemodules" ) {
				QDomText textChild = node.firstChild().toText();
				if ( node.toElement().attribute( "val" ) == "yes" )
					kmfdoc->setUseModules( true );
				else
					kmfdoc->setUseModules( false );
			} else {
				m_err->setErrType( KMFError::NORMAL );
				m_err->setErrMsg( i18n ( "Parsing Error\n Unknown tag: " ) + node.nodeName() );
				m_err_handler->showError( m_err );
			}
			kmfdoc->changed();
			node = node.nextSibling();
		}
	}
	kdDebug() << "Finished Parsing Rule" << endl;*/
}
KMFError* KMFXMLParser::parseIPTRule( const QDomElement &/*rule*/ ) {
	kdDebug() << "void KMFXMLParser::parseIPTRule( const QDomElement &rule )" << endl;
// 	QPtrList<QString> options;
// 	QPtrList<QString> target_options;
// 	QString rule_option = "";
// 	QString rule_targetoption = "";
// 	QString rule_name = "";
// 	QString rule_target = "";
// 	QString rule_chain = "";
// 	QString rule_table = "";
// 	QString rule_enabled = "";
// 	QString rule_custom = "";
// 	QString rule_logging = "";
//   QString rule_desc = "";
//
// 	QDomNode node = rule.firstChild();
// 	while ( !node.isNull() ) {
// 		if ( node.isElement() ) {
// 			//       kdDebug() << "Found Tag: " << node.nodeName() << endl;
// 			if ( node.nodeName() == "rulename" ) {
// 				QDomText textChild = node.firstChild().toText();
// 				rule_name = node.toElement().attribute( "val" );
// 				//  			kdDebug() << "Found Rule Name: " << rule_name << endl;
// 
// 			} else if ( node.nodeName() == "ruledesc" ) {
// 				QDomText textChild = node.firstChild().toText();
// 				rule_desc = node.toElement().attribute( "val" );
// 				//  			kdDebug() << "Found RuleChain: " << rule_chain << endl;
// 
// 			} else if ( node.nodeName() == "rulechain" ) {
// 				QDomText textChild = node.firstChild().toText();
// 				rule_chain = node.toElement().attribute( "val" );
// 				//  			kdDebug() << "Found RuleChain: " << rule_chain << endl;
// 
// 			} else if ( node.nodeName() == "ruletable" ) {
// 				QDomText textChild = node.firstChild().toText();
// 				rule_table = node.toElement().attribute( "val" );
// 				//  			kdDebug() << "Found Rule Table: " << rule_table << endl;
// 
// 			} else if ( node.nodeName() == "ruletarget" ) {
// 				QDomText textChild = node.firstChild().toText();
// 				rule_target = node.toElement().attribute( "val" );
// 				//  			kdDebug() << "Found Rule Target: " << rule_target << endl;
// 
// 			} else if ( node.nodeName() == "ruleenabled" ) {
// 				QDomText textChild = node.firstChild().toText();
// 				rule_enabled = node.toElement().attribute( "val" );
// 				//  			kdDebug() << "Found RuleChain: " << rule_chain << endl;
// 
// 			} else if ( node.nodeName() == "customrule" ) {
// 				QDomText textChild = node.firstChild().toText();
// 				rule_custom = node.toElement().attribute( "val" );
// 				//  			kdDebug() << "Found RuleChain: " << rule_chain << endl;
// 
// 			} else if ( node.nodeName() == "rulelogging" ) {
// 				QDomText textChild = node.firstChild().toText();
// 				rule_logging = node.toElement().attribute( "val" );
// 				//  			kdDebug() << "Found RuleChain: " << rule_chain << endl;
// 
// 			} else if ( node.nodeName() == "ruleoption" ) {
// 				QDomText textChild = node.firstChild().toText();
// 				QString curr_option = node.toElement().attribute( "val" );
// 				QString *ptr_curr_option = new QString( curr_option );
// 				options.append( ptr_curr_option );
// 				//  			kdDebug() << "Found Rule Option: " << curr_option << endl;
// 
// 			} else if ( node.nodeName() == "ruletargetoption" ) {
// 				QDomText textChild = node.firstChild().toText();
// 				QString curr_option = node.toElement().attribute( "val" );
// 				QString *ptr_curr_option = new QString( curr_option );
// 				target_options.append( ptr_curr_option );
// 				//  			kdDebug() << "Found Rule Target Option: " << curr_option << endl;
// 
// 			}
// 			node = node.nextSibling();
// 		}
// 	}
// 	//	kdDebug() << "Finished Parsing Rule" << endl;
// 	//  kdDebug() << "rule_name: " << rule_name << endl;
// 	//  kdDebug() << "rule_chain: " << rule_chain << endl;
// 	//  kdDebug() << "rule_target: " << rule_target << endl;
// 	//  kdDebug() << "rule_table: " << rule_table << endl;
// 
// 	if ( !rule_name.isEmpty() && !rule_chain.isEmpty() && !rule_target.isEmpty() && !rule_table.isEmpty() ) {
// 		kdDebug() << "Orig Rule Name: " << rule_name << endl;
// 		if ( rule_name.startsWith( "KMFWizard: " ) )
// 			rule_name = rule_name.right( rule_name.length() - 11 );
// 		if ( rule_name.length() > 19 ) {
// 			QString ending = rule_name.right( 4 );
// 			rule_name.left( 15 );
// 			rule_name += ending;
// 		}
// 		kdDebug() << "New Rule Name: " << rule_name << endl;
// 
// 		IPTRule * curr_rule = kmfdoc->table( rule_table ) ->chainForName( rule_chain ) ->addRule( rule_name );
// 		if ( curr_rule == 0 ) {
// 			m_err -> setErrType( KMFError::FATAL );
// 			const QString& msg = i18n( "<P><b>Fatal error during file parsing.</b>"
// 			                           "<p>Unable to add rule: %1 to chain: %2 in table: %3." ).arg( rule_name ).arg( rule_chain ).arg( rule_table );
// 			m_err -> setErrMsg( msg );
// 			return m_err;
// 
// 		}
// 		curr_rule->setTarget( rule_target );
// 		if ( rule_enabled == "no" )
// 			curr_rule->setEnabled( false );
// 		else
// 			curr_rule->setEnabled( true );
// 
// 		if ( rule_logging == "yes" )
// 			curr_rule->setLogging( true );
// 		else
// 			curr_rule->setLogging( false );
// 
// 		if ( rule_custom == "yes" )
// 			curr_rule->setCustomRule( true );
// 		else
// 			curr_rule->setCustomRule( false );
// 
// 		curr_rule->setDescription( rule_desc );
// 		
// 		if ( !options.isEmpty() ) {
// 			QString * op;
// 			for ( op = options.first(); op; op = options.next() ) {
// 				QString o_name;
// 				QPtrList<QString>* o_option = new QPtrList<QString>;
// 				int pos;
// 				int l;
// 				pos = op->find( '|' );
// 				o_name = op->left( pos );
// 				//  			kdDebug() << "Option name: " << *o_name << endl;
// 				l = o_name.length();
// 				*op = op->remove
// 				      ( 0, l + 1 );
// 
// 				if ( op->isEmpty() ) {
// 					QString * no = new QString( "" );
// 					o_option->append( no );
// 				}
// 				while ( !op->isEmpty() ) {
// 					pos = op->find( '|' );
// 					QString* opt = new QString( op->left( pos ) );
// 					o_option->append( opt );
// 					//  				kdDebug() << "Option Value: " << *opt << endl;
// 					l = opt->length();
// 					*op = op->remove
// 					      ( 0, l + 1 );
// 				}
// 				//  			kdDebug() << "Adding Rule Option to Rule: " << curr_rule->name() << endl;
// 				curr_rule->addRuleOption( o_name, *o_option );
// 			}
// 		}
// 		if ( !target_options.isEmpty() ) {
// 			QString * op;
// 			for ( op = target_options.first(); op; op = target_options.next() ) {
// 				QString * o_name = new QString();
// 				QPtrList<QString>* o_option = new QPtrList<QString>;
// 				int pos;
// 				int l;
// 				pos = op->find( '|' );
// 				*o_name = op->left( pos );
// 				//  			kdDebug() << "Option name: " << *o_name << endl;
// 				l = o_name->length();
// 				*op = op->remove
// 				      ( 0, l + 1 );
// 				if ( op->isEmpty() ) {
// 					QString * no = new QString( "" );
// 					o_option->append( no );
// 				}
// 				while ( !op->isEmpty() ) {
// 					pos = op->find( '|' );
// 					QString* opt = new QString( op->left( pos ) );
// 					o_option->append( opt );
// 					//                kdDebug() << "Option Value: " << *opt << endl;
// 					l = opt->length();
// 					*op = op->remove
// 					      ( 0, l + 1 );
// 				}
// 				//              kdDebug() << "Found Option Values: ";
// 				for ( uint i = 0;i < o_option->count();i++ ) {
// 					QString* val = new QString();
// 					val = o_option->at( i );
// 					kdDebug() << " " << *val ;
// 				}
// 				//              kdDebug() << endl;
// 				curr_rule->addTargetOption( *o_name, *o_option );
// 			}
// 			//                        kmfdoc->addChainRule(*curr_rule);
// 		}
// 	} else {
// 		m_err -> setErrType( KMFError::FATAL );
// 		const QString& msg = i18n( "<P><b>Fatal error during file parsing.</b>"
// 		                           "<p>Not enough data to insert rule" );
// 		m_err -> setErrMsg( msg );
// 		return m_err;
// 	}
// 	m_err -> setErrType( KMFError::OK );
// 	const QString& msg = "";
// 	m_err -> setErrMsg( msg );
	return m_err;
}


KMFError* KMFXMLParser::parseIPTChain( const QDomElement &/*chain*/ ) {
// 	kdDebug() << "void KMFXMLParser::parseIPTChain( const QDomElement &chain )" << endl;
// 	QString ch_table = "";
// 	QString ch_name = "";
// 	QString ch_buildin = "";
// 	QString ch_target = "";
// 	QString ch_logging = "";
// 	QString ch_loglimit = "";
// 	QString ch_logprefix = "";
// 	QString ch_logburst = "";
// 
// 	QDomNode node = chain.firstChild();
// 	while ( !node.isNull() ) {
// 		if ( node.isElement() ) {
// 			//      kdDebug() << "Founf Tag: " << node.nodeName() << endl;
// 			if ( node.nodeName() == "chainname" ) {
// 				QDomText textChild = node.firstChild().toText();
// 				ch_name = node.toElement().attribute( "val" );
// 				//  			kdDebug() << "Founf Chain Name: " << ch_name << endl;
// 
// 			} else if ( node.nodeName() == "chaintable" ) {
// 				QDomText textChild = node.firstChild().toText();
// 				ch_table = node.toElement().attribute( "val" );
// 				//  			kdDebug() << "Founf Chain Table: " << ch_table << endl;
// 
// 			} else if ( node.nodeName() == "chainbuildin" ) {
// 				QDomText textChild = node.firstChild().toText();
// 				ch_buildin = node.toElement().attribute( "val" );
// 				//  			kdDebug() << "Founf Chain Buildin: " << ch_buildin << endl;
// 
// 			} else if ( node.nodeName() == "chaintarget" ) {
// 				QDomText textChild = node.firstChild().toText();
// 				ch_target = node.toElement().attribute( "val" );
// 				//  			kdDebug() << "Founf Chain Target: " << ch_target << endl;
// 
// 			} else if ( node.nodeName() == "chainlogging" ) {
// 				QDomText textChild = node.firstChild().toText();
// 				ch_logging = node.toElement().attribute( "val" );
// 				//  			kdDebug() << "Founf Chain Logging: " << ch_loglimit << endl;
// 
// 			} else if ( node.nodeName() == "chainloglimit" ) {
// 				QDomText textChild = node.firstChild().toText();
// 				ch_loglimit = node.toElement().attribute( "val" );
// 				//  			kdDebug() << "Founf Chain Log Limit: " << ch_loglimit << endl;
// 
// 			} else if ( node.nodeName() == "chainlogprefix" ) {
// 				QDomText textChild = node.firstChild().toText();
// 				ch_logprefix = node.toElement().attribute( "val" );
// 				//  			kdDebug() << "Founf Chain Log Prefix: " << ch_logprefix << endl;
// 
// 			} else if ( node.nodeName() == "chainlogburst" ) {
// 				QDomText textChild = node.firstChild().toText();
// 				ch_logburst = node.toElement().attribute( "val" );
// 				//  			kdDebug() << "Founf Chain Log Burst: " << ch_logburst << endl;
// 			}
// 			node = node.nextSibling();
// 		}
// 	}
// 
// 	kdDebug() << "Finished Parsing Chain" << endl;
// 	if ( !ch_name.isEmpty() && !ch_buildin.isEmpty() ) {
// 		bool build_in_chain;
// 		if ( ch_buildin == "yes" )
// 			build_in_chain = true;
// 		else
// 			build_in_chain = false;
// 
// 		if ( !build_in_chain ) {
// 			kdDebug() << "Adding New Custon Chain: " << ch_name << endl;
// 			m_err = kmfdoc->table( ch_table )->addChain( ch_name, ch_target, false );
// 			if ( m_err->errNum() > 0 )
// 				return m_err;
// 		}
// 		IPTChain* curr_chain = kmfdoc->table( ch_table )->chainForName( ch_name );
// 		if ( curr_chain == 0 ) {
// 			kdDebug() << "Null Pointer Returned for curr_chain !!!" << endl;
// 			m_err -> setErrType( KMFError::FATAL );
// 			const QString& msg = i18n( "<P><b>Fatal error during file parsing.</b>"
// 			                           "<p>IPTChain* curr_chain = kmfdoc->chain(ch_name,ch_table) "
// 			                           "returned 0." );
// 			m_err -> setErrMsg( msg );
// 			return m_err;
// 		}
// 		curr_chain->setBuildIn( build_in_chain );
// 		if ( !ch_target.isEmpty() ) {
// 			curr_chain->setDefaultTarget( ch_target );
// 		}
// 
// 		if ( ch_logging == "yes" ) {
// 			curr_chain->setDropLogging( true, ch_loglimit, ch_logburst, ch_logprefix );
// 		}
// 	} else {
// 		m_err -> setErrType( KMFError::FATAL );
// 		const QString& msg = i18n( "<P><b>Fatal error during file parsing.</b>"
// 		                           "<p>No chain name or table given." );
// 		m_err -> setErrMsg( msg );
// 		return m_err;
// 	}
// 	m_err -> setErrType( KMFError::OK );
// 	const QString& msg = "";
// 	m_err -> setErrMsg( msg );
 	return m_err;
}


const QString& KMFXMLParser::writeKMFRS( KMFIPTDoc* kmfdoc ) {
  kdDebug() << "KMFXMLParser::writeKMFRS( KMFIPTDoc* kmfdoc )" << endl;
	kdDebug() << "\nNew Recursice Generated Document XML:" << endl;
	kdDebug() << kmfdoc->getXMLSniplet() << endl;
	kdDebug() << "######## END NEW XML ########\n" << endl;

	QDomDocument doc( "kmfrs" );
	QDomElement kmfrs = doc.createElement( "kmyfirewallruleset" );
	doc.appendChild( kmfrs );

	for ( int i = 0; i < 3; i++ ) {
		QPtrList<IPTChain> tmp_chains;
		if ( i == 0 )
			tmp_chains = kmfdoc->table( "filter" ) ->chains();
		if ( i == 1 )
			tmp_chains = kmfdoc->table( "nat" ) ->chains();
		if ( i == 2 )
			tmp_chains = kmfdoc->table( "mangle" ) ->chains();


		IPTChain* ch;
		for ( ch = tmp_chains.first(); ch; ch = tmp_chains.next() ) {
			kdDebug() << "XML For Chain: " << ch->name() << endl;
			kdDebug() << ch->getXMLSniplet() << endl;
			QDomElement chain = doc.createElement( "chain" );

			kmfrs.appendChild( chain );


			QDomElement chainname = doc.createElement( "chainname" );
			chain.appendChild( chainname );
			chainname.setAttribute( "val", ch->name() );
      kdDebug() << "Writing Chain: " << ch->name() << endl;

			QDomElement chaintable = doc.createElement( "chaintable" );
			chain.appendChild( chaintable );
			chaintable.setAttribute( "val", ch->table() ->name() );

			QString n;
			QDomElement chainlogging = doc.createElement( "chainlogging" );
			chain.appendChild( chainlogging );

			if ( ch->logging() ) {
				chainlogging.setAttribute( "val", "yes" );

				n = ch->logLimit();
				if ( !n.isEmpty() ) {
					QDomElement chainloglimit = doc.createElement( "chainloglimit" );
					chain.appendChild( chainloglimit );
					chainloglimit.setAttribute( "val", n );


					n = ch->logBurst();
					if ( !n.isEmpty() ) {
						QDomElement chainlogburst = doc.createElement( "chainlogburst" );
						chain.appendChild( chainlogburst );
						chainlogburst.setAttribute( "val", n );
					}
				}
				n = ch->logPrefix();
				if ( !n.isEmpty() ) {
					QDomElement chainlogprefix = doc.createElement( "chainlogprefix" );
					chain.appendChild( chainlogprefix );
					chainlogprefix.setAttribute( "val", n );
				}
			} else {
				chainlogging.setAttribute( "val", "no" );
			}

			if ( ch->hasDefaultTarget() ) {
				n = ch->defaultTarget();
				QDomElement chaintarget = doc.createElement( "chaintarget" );
				chain.appendChild( chaintarget );
				chaintarget .setAttribute( "val", n );
			}

			QDomElement chainbuildin = doc.createElement( "chainbuildin" );
			chain.appendChild( chainbuildin );
			bool bi = ch->isBuildIn();
			if ( bi ) {
				chainbuildin.setAttribute( "val", "yes" );
			} else {
				chainbuildin.setAttribute( "val", "no" );
			}
		}
	}

	for ( int i = 0; i < 3; i++ ) {
		QPtrList<IPTChain> tmp_chains;
		if ( i == 0 )
			tmp_chains = kmfdoc->table( "filter" ) ->chains();
		if ( i == 1 )
			tmp_chains = kmfdoc->table( "nat" ) ->chains();
		if ( i == 2 )
			tmp_chains = kmfdoc->table( "mangle" ) ->chains();
		IPTChain* ch;
		for ( ch = tmp_chains.first(); ch; ch = tmp_chains.next() ) {
			QString n;
			QPtrList<IPTRule> rules = ch->chainRuleset();
			IPTRule* ru;
			for ( ru = rules.first(); ru; ru = rules.next() ) {
				QDomElement rule = doc.createElement( "rule" );
				kmfrs.appendChild( rule );

				QDomElement rulename = doc.createElement( "rulename" );
				rule.appendChild( rulename );
				rulename.setAttribute( "val", ru->name() );
				kdDebug() << "Writing Rule: " << ru->name() << endl;

        
        if ( !ru->description().isEmpty() ) {
					QDomElement ruledesc = doc.createElement( "ruledesc" );
					rule.appendChild( ruledesc );
					ruledesc.setAttribute( "val", ru->description() );
				}

				QDomElement ruleenabled = doc.createElement( "ruleenabled" );
				rule.appendChild( ruleenabled );
				if ( ru->enabled() )
					ruleenabled.setAttribute( "val", "yes" );
				else
					ruleenabled.setAttribute( "val", "no" );

				QDomElement customrule = doc.createElement( "customrule" );
				rule.appendChild( customrule );
				if ( ru->customRule() )
					customrule.setAttribute( "val", "yes" );
				else
					customrule.setAttribute( "val", "no" );

				QDomElement rulelogging = doc.createElement( "rulelogging" );
				rule.appendChild( rulelogging );
				if ( ru->logging() )
					rulelogging.setAttribute( "val", "yes" );
				else
					rulelogging.setAttribute( "val", "no" );

				QDomElement rulechain = doc.createElement( "rulechain" );
				rule.appendChild( rulechain );
				rulechain.setAttribute( "val", ru->chain() ->name() );
				//      	kdDebug() << " for Chain: " << n << endl;


				QDomElement ruletarget = doc.createElement( "ruletarget" );
				rule.appendChild( ruletarget );
				ruletarget.setAttribute( "val", ru->target() );

				QDomElement ruletable = doc.createElement( "ruletable" );
				rule.appendChild( ruletable );
				ruletable.setAttribute( "val", ru->table() ->name() );
				// the ruleoptions
// 				QPtrList<QPtrList<QString> > opts_list = ru->ruleOptions();
// 				if ( !opts_list.isEmpty() ) {
// 					if ( opts_list.count() > 0 ) {
// 						QPtrList<QString>* opts;
// 						for ( opts = opts_list.first(); opts; opts = opts_list.next() ) {
// 							if ( !opts->isEmpty() && opts->count() > 0 ) {
// 								n = "";
// 								QString opt_name = *opts->at( 0 );
// 								n.append( opt_name );
// 								for ( uint l = 1;l < opts->count();l++ ) {
// 									QString opt_str = *opts->at( l );
// 									n.append( "|" );
// 									n.append( opt_str );
// 								}
// 								QDomElement ruleoption = doc.createElement( "ruleoption" );
// 								rule.appendChild( ruleoption );
// 								ruleoption.setAttribute( "val", n );
// 							}
// 						}
// 					}
// 				}
// 				QPtrList<QPtrList<QString> > target_opts_list = ru->ruleTargetOptions();
// 				if ( !target_opts_list.isEmpty() ) {
// 					if ( target_opts_list.count() > 0 ) {
// 						QPtrList<QString>* opts;
// 						for ( opts = target_opts_list.first(); opts; opts = target_opts_list.next() ) {
// 							if ( !opts->isEmpty() && opts->count() > 0 ) {
// 								n = "";
// 								QString opt_name = *opts->at( 0 );
// 								n.append( opt_name );
// 								for ( uint l = 1;l < opts->count();l++ ) {
// 									QString opt_str = *opts->at( l );
// 									n.append( "|" );
// 									n.append( opt_str );
// 								}
// 								QDomElement ruletargetoption = doc.createElement( "ruletargetoption" );
// 								rule.appendChild( ruletargetoption );
// 								ruletargetoption.setAttribute( "val", n );
// 							}
// 						}
// 					}
// 				}
			}
		}
	}

	QDomElement abstract = doc.createElement( "abstract" );
	kmfrs.appendChild( abstract );
  kdDebug() << "Writing document info" << endl;
	QString tmp;

	if ( kmfdoc->useFilter() )
		tmp = "yes";
	else
		tmp = "no";

	QDomElement usefilter = doc.createElement( "usefilter" );
	abstract.appendChild( usefilter );
	usefilter.setAttribute( "val", tmp );

	if ( kmfdoc->useNat() )
		tmp = "yes";
	else
		tmp = "no";

	QDomElement usenat = doc.createElement( "usenat" );
	abstract.appendChild( usenat );
	usenat.setAttribute( "val", tmp );

	if ( kmfdoc->useMangle() )
		tmp = "yes";
	else
		tmp = "no";

	QDomElement usemangle = doc.createElement( "usemangle" );
	abstract.appendChild( usemangle );
	usemangle.setAttribute( "val", tmp );


	if ( kmfdoc->useIPFwd() )
		tmp = "yes";
	else
		tmp = "no";

	QDomElement useipfwd = doc.createElement( "useipfwd" );
	abstract.appendChild( useipfwd );
	useipfwd.setAttribute( "val", tmp );

	if ( kmfdoc->useRPFilter() )
		tmp = "yes";
	else
		tmp = "no";

	QDomElement userpfilter = doc.createElement( "userpfilter" );
	abstract.appendChild( userpfilter );
	userpfilter.setAttribute( "val", tmp );

	if ( kmfdoc->useMartians() )
		tmp = "yes";
	else
		tmp = "no";

	QDomElement usemartians = doc.createElement( "usemartians" );
	abstract.appendChild( usemartians );
	usemartians.setAttribute( "val", tmp );

	if ( kmfdoc->useSynCookies() )
		tmp = "yes";
	else
		tmp = "no";

	QDomElement usesyncookies = doc.createElement( "usesyncookies" );
	abstract.appendChild( usesyncookies );
	usesyncookies.setAttribute( "val", tmp );


	if ( kmfdoc->useModules() )
		tmp = "yes";
	else
		tmp = "no";

	QDomElement usemodules = doc.createElement( "usemodules" );
	abstract.appendChild( usemodules );
	usemodules.setAttribute( "val", tmp );

	kdDebug() << "\nFinished writing document" << endl;
	return *( new QString( doc.toString() ) );
}



KMFError* KMFXMLParser::writeKMFRS( KMFIPTDoc* kmfdoc, const QString& file ) {
	const QString & xmlfile = file;
	QString xml = writeKMFRS( kmfdoc );
	//  kdDebug() << "QDomDocument liefert: \n" << xml << endl;

	if ( xmlfile != QString::null ) {
		QFile f( xmlfile );
		f.remove();
		bool isWriteable = f.open( IO_ReadWrite );
		if ( isWriteable ) {
			KMFConfig::setCurrentConfiguration( xmlfile );
// 			Config().m_currentConfiguration = xmlfile;
			QTextStream ts( &f );
			ts << xml << endl;
			f.flush();
			f.close();

			// generate retrun error object
			kmfdoc->isSaved();
			m_err -> setErrType( KMFError::OK );
			m_err -> setErrMsg( "" );
			return m_err;
		} else {
			// generate retrun error object
			m_err -> setErrType( KMFError::NORMAL );
			const QString& msg = i18n( "Opening file %1 for writing failed.\n"
			                           "Please make sure that you are logged in as root" ).arg( xmlfile );
			m_err -> setErrMsg( msg );
			return m_err;
		}
	} else {
		// generate retrun error object
		m_err -> setErrType( KMFError::NORMAL );
		const QString& msg = i18n( "Opening file %1 for writing failed.\n"
		                           "Please make sure that you are logged in as root" ).arg( xmlfile );
		m_err -> setErrMsg( msg );
		return m_err;

	}
	// generate retrun error object
	m_err -> setErrType( KMFError::FATAL );
	const QString& msg = i18n( "File to save = QString::null. This is a bug." );
	m_err -> setErrMsg( msg );
	return m_err;
}
