/***************************************************************************
 begin                : Thu Feb 7  2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@gmail.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMFRULEEDIT_H
#define KMFRULEEDIT_H
#include "kmyfirewallruleeditor.h"

// qt includes
#include <qvariant.h>
#include <qdialog.h>
#include <qpixmap.h>
#include <qstring.h>
#include <qvaluelist.h>
#include <qguardedptr.h>

// kde includes
#include <kconfig.h>
#include <kiconloader.h>
#include <kstandarddirs.h> 

// project includes
#include "../interfaces/kmfruleeditinterface.h"

class KMFIPTDoc;
class KMFListView;
class QListViewItem;
class KListViewItem;
class KMFListViewItem;
class NetfilterObject;
class IPTRule;
class IPTChain;
class IPTable;
class QString;
class KPopupMenu;
class KMFErrorHandler;
class KMFError;
class KMFCheckInput;
class KMFChainEdit;
class KMFNewChainDlg;
class KMFObjectInfo;
class KMFRuleOptionEditInterface;
class KMFRuleTargetOptionEditInterface;

class KMFRuleEdit : public KMyFirewallRuleEditor, public KMFRuleEditInterface {
	Q_OBJECT

public:
	KMFRuleEdit( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	~KMFRuleEdit();
	IPTRule* currRule() const {
		return m_rule;
	};

// 	void showRuleOptionLeds( IPTRule* );
// 	bool updateCurrRule();
	void loadDoc( KMFIPTDoc* doc );
	void editChain( IPTChain* );
	void addRuleOption(QString*, QPtrList< QString >* );
	void addRuleTargetOption(QString*, QPtrList< QString >* ); 
	void showOverview(); 
	
		
public slots:
	void slotAddRule();
 	void slotEditRule();
	void slotDelRule();
	void slotAddChain();
	void slotDelChain();
	void slotEditChain();
	void slotLoadDocument( KMFIPTDoc* );
	void slotUpdateView();
	void slotSelectionInvalid();

protected:
	bool event( QEvent* );

private:
	// members
	void createRBM( NetfilterObject* );
	void loadIcons();
	void enableRuleEdit( bool on );
	KMFListView* currTableView();
	void setCurrTableView( KMFListView* );
	void loadPlugins();
	void registerRuleOptionPlugin( KMFRuleOptionEditInterface* );
	void registerRuleTargetOptionPlugin( KMFRuleTargetOptionEditInterface* );

	// data

	KMFObjectInfo *m_object_info;
	KMFChainEdit *m_editchain;
	KMFNewChainDlg *m_new_chain;
	KMFListView *m_lv_table_filter, *m_lv_table_nat, *m_lv_table_mangle;
	KMFIPTDoc *kmfdoc;
	QGuardedPtr<IPTRule> m_rule;
	QGuardedPtr<IPTChain> m_chain;
	QGuardedPtr<IPTable> m_table;
	
	
	QPtrList<KMFRuleOptionEditInterface> m_editPlugins;
	QPtrList<KMFRuleTargetOptionEditInterface> m_editTargetPlugins;
	
	KMFError *m_err;
	KMFErrorHandler *m_err_handler;
	KMFCheckInput *m_check_input;
	KPopupMenu *m_contextMenu;
	QPixmap icon_up, icon_down, icon_del, icon_edit, icon_rule, icon_filter, icon_rename,
	icon_chain, icon_log, icon_accept, icon_drop, icon_cmd, icon_reject, icon_return,
	        icon_target, icon_queue, icon_new, icon_copy, icon_move;


private slots:
	void slotNewItemSelected( QListViewItem* );


	void slotRuleRBM( QListViewItem*, const QPoint &, int );
	void slotRenameRule();
	void slotRenameRule( QListViewItem*, int, const QString& );
	void slotNewOptionType( int index );
	void slotShowOverview();

	void slotEditRuleInfo();
	void slotEditChainInfo();
	void slotEditTargetOption();


	void slotFragChanged();
	void slotLogRuleChanged();
	void slotEnableRuleChanged();
	void slotTargetChanged( const QString& );

	void slotNewTableSelected();

	void slotAddRuleOption( QString*, QPtrList<QString>* );
	void slotAddTargetOption( QString*, QPtrList<QString>* );

	void slotMoveRuleUp();
	void slotMoveRuleDown();
	void slotMoveRule( int );
	void slotCopyRule( int );

	void slotHelp();

	signals:
	void sigFragToggled();
	void sigUpdateView();
	void sigUpdateView( NetfilterObject* );
};

#endif // KMFRULEEDIT_H
