/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@gmail.com>, (C) 2001-2004
*/


#ifndef _KMFINSATLLERPART_H_
#define _KMFINSATLLERPART_H_


#include <qstring.h>
#include <kparts/part.h>
#include <kparts/plugin.h>
#include <kparts/factory.h>
#include <kxmlgui.h>

class QWidget;
class QPainter;
class KURL;
class KMFDoc;
class KMFProcOut;
// class KMFIPTInstaller;
class KMFCompilerInterface;
class KAction;
class KActionMenu;
class KMyFirewall;
class KMFCompilerPlugin;
// Project Plugins
#include "../interfaces/kmfplugin.h"

/**
 * This is a "Part".  It that does all the real work in a KPart
 * application.
 *
 * @short Main Part
 * @author Chris <chubinger@gmail.com>
 * @version 0.1
 */
class KMFInstallerPlugin : public KMFPlugin {
	Q_OBJECT
public:
	/**
	 * Default constructor
	 */
	KMFInstallerPlugin( QObject *parent, const char *name );

	/**
	 * Destructor
	 */
	virtual ~KMFInstallerPlugin();

	void installFW();
	void uninstallFW();
	void startFW();
	void stopFW();
	void showConfig();
	void showScript();
	void showFilter();
	void showNat();
	void showMangle();

public slots:
	void slotEnableActions( bool );

public slots:
	void slotStopFirewall();
	void slotStartFirewall();
	void slotShowScript();
	void slotShowConfig();
	void slotShowFilter();
	void slotShowNat();
	void slotShowMangle();
	void slotInstallFW();
	void slotUninstallFW();

private:
// 	KMFProcOut *m_execWidget;
	// KMFIPTInstaller *m_iptInstaller;
	// KMFCompilerPlugin *m_compiler;
	
	
	KMFDoc* m_doc;
	KAction* m_actionStopFw;
	KAction* m_actionRunFw;
	KAction* m_actionPreviewScript;
	KAction* m_actionShowConfig;
	KAction* m_actionShowFilter;
	KAction* m_actionShowNat;
	KAction* m_actionShowMangle;
	KActionMenu* m_actionMenu;
	KAction* m_actionInstallFW;
	KAction* m_actionUninstallFW;
	enum { IPT, GENERIC };
	int m_docType;
// 	KMFPlugin* m_installerPlugin;
// 	KMFPlugin* installer();
	KMFProcOut *m_execWidget;
	KMFProcOut* execWidget();
};

class KInstance;

class KMFInstallerPluginFactory : public KLibFactory {
	Q_OBJECT
public:
	KMFInstallerPluginFactory( QObject *parent = 0, const char *name = 0 );
	virtual ~KMFInstallerPluginFactory() {
		delete s_instance;
	};
	virtual QObject* createObject( QObject* parent = 0, const char* pname = 0,
	                               const char* name = "QObject",
	                               const QStringList &args = QStringList() );
	/*     static KInstance* instance(); */

private:
	static KInstance* s_instance;
};

#endif // _KMFINSATLLERPART_H_
