//
//
// C++ Implementation: $MODULE$
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@gmail.com>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "kmfgenericinterfacehost.h"

// QT includes
#include <qstring.h>
#include <qcheckbox.h>
#include <qtextedit.h>
#include <qlabel.h>
#include <qtimer.h>

// KDE includes
#include <klocale.h>
#include <kdebug.h>
#include <klistview.h>
#include <kpopupmenu.h>
#include <kpushbutton.h>
#include <kiconloader.h>
#include <knuminput.h>
#include <kmessagebox.h>
#include <kstdguiitem.h>

// Project includes
#include "../core/kmfgenericdoc.h"
#include "../core/kmfnetzone.h"
#include "../core/kmfnethost.h"

#include "../kmfwidgets/kmflistviewitem.h"


KMFGenericInterfaceHost::KMFGenericInterfaceHost( QWidget *parent, const char *name, WFlags f )
		: KMyFirewallGenericInterfaceHostWidget( parent, name, f ) {
	m_lv_zones->setFullWidth( true );
	m_contextMenu = new KPopupMenu( this, "Popup" );
	m_contextMenu->hide();
	loadIcons();
	connect( m_lv_zones, SIGNAL( pressed( QListViewItem* ) ) ,
	         this, SLOT( slotNewItemSelected( QListViewItem* ) ) );
	connect( m_lv_zones, SIGNAL( contextMenuRequested ( QListViewItem*, const QPoint&, int ) ),
	         this, SLOT( slotZoneRBM( QListViewItem*, const QPoint&, int ) ) );
	connect( m_lv_zones, SIGNAL( itemRenamed ( QListViewItem *, int, const QString & ) ) ,
	         this, SLOT( slotHostRenamed( QListViewItem*, int , const QString  & ) ) );

	connect( m_sb_host_1, SIGNAL( valueChanged( const QString& ) ),
		this, SLOT( slotAddressChanged( const QString& ) ) );
	connect( m_sb_host_2, SIGNAL( valueChanged( const QString& ) ),
		this, SLOT( slotAddressChanged( const QString& ) ) );
	connect( m_sb_host_3, SIGNAL( valueChanged( const QString& ) ),
		this, SLOT( slotAddressChanged( const QString& ) ) );
	connect( m_sb_host_4, SIGNAL( valueChanged( const QString& ) ),
		this, SLOT( slotAddressChanged( const QString& ) ) );

	b_newHost->setIconSet( icon_new );
	b_delHost->setIconSet( icon_del );

	connect( b_newHost, SIGNAL( clicked() ),
		this, SLOT( slotNewHost() ) );

	connect( b_delHost, SIGNAL( clicked() ),
		this, SLOT( slotDelHost() ) );

	QTimer *timer = new QTimer( this );
	connect( timer, SIGNAL( timeout() ),
		this, SLOT( slotTimerShot() ) );
	timer->start( 1000, FALSE );

}


KMFGenericInterfaceHost::~KMFGenericInterfaceHost() {}

/*!
    \fn KMFGenericInterfaceHost::slotUpdateView()
 */
void KMFGenericInterfaceHost::slotUpdateView() {
	m_lv_zones->clear();
	itemTrustedHosts = new KMFListViewItem( m_lv_zones, 0, m_doc->trustedHostsZone() );
	itemMaliciousHosts = new KMFListViewItem( m_lv_zones, 0, m_doc->maliciousHostsZone() );
	itemBadServers = new KMFListViewItem( m_lv_zones, 0, m_doc->badServersHostsZone() );
	itemBadClients = new KMFListViewItem( m_lv_zones, 0, m_doc->badClientsHostsZone() );

	itemTrustedHosts->deleteChildren();
	itemTrustedHosts->setupZoneView();

	itemMaliciousHosts->deleteChildren();
	itemMaliciousHosts->setupZoneView();

	itemBadServers->deleteChildren();
	itemBadServers->setupZoneView();

	itemBadClients->deleteChildren();
	itemBadClients->setupZoneView();

	KMFListViewItem* it = 0;
	if ( m_host ) {
		it = findKMFItem( m_host->objectID() );
	} else if ( m_zone ) {
		it = findKMFItem( m_zone->objectID() );
	}
	if ( it ) {
		m_lv_zones->setSelected( it, true );
		slotNewItemSelected( it );
	}
}

/*!
    \fn KMFGenericInterfaceHost::loadDoc( KMFGenericDoc* )
 */
void KMFGenericInterfaceHost::loadDoc( KMFGenericDoc* doc ) {
	kdDebug() << "void KMFGenericInterfaceHost::loadDoc( KMFGenericDoc* )" << endl;
	m_doc = doc;
	slotUpdateView();
}

/*!
    \fn KMFGenericInterfaceHost::slotAddHost()
 */
void KMFGenericInterfaceHost::slotNewHost() {
	kdDebug() << "void KMFGenericInterfaceHost::slotNewHost()" << endl;
	if ( m_zone ) {
		KMFNetHost *host = new KMFNetHost( m_zone, "asdfasf");
		KMFNetHost *host2 = 0;
		host2 = m_zone->addHost( i18n("New Host") , host->getDOMTree() );
		slotUpdateView();

		KMFListViewItem* it = findKMFItem(  i18n("New Host"), host2->objectID() );
		if ( it ) {
			it->setRenameEnabled( 0, true );
			it->startRename( 0 );
		}
		m_host = host2;
		m_zone = host2->zone();
	}
}

/*!
    \fn KMFGenericInterfaceHost::slotDelHost()
 */
void KMFGenericInterfaceHost::slotDelHost() {
	kdDebug() << "void KMFGenericInterfaceHost::slotDelHost()" << endl;
	if ( ! m_host || ! m_zone )
		return;
	if ( KMessageBox::questionYesNo(this, i18n("<qt>Are you sure that you want to delete host "
														"<b>%1</b> from <b>%2</b>?</qt>").arg(m_host->guiName() ).arg( m_zone->guiName() ),
														 i18n("Are you sure?"), KStdGuiItem::yes(), KStdGuiItem::cancel(),
														 "genericgui_hostpage_hostdelete") == KMessageBox::Yes ) {
		m_zone->delHost( m_host );
		m_host = 0;
		slotUpdateView();
	}
}

/*!
    \fn KMFGenericInterfaceHost::slotNewItemSelected( QListViewItem* )
 */
void KMFGenericInterfaceHost::slotNewItemSelected( QListViewItem* item ){
	kdDebug() << "void KMFGenericInterfaceHost::slotNewItemSelected( QListViewItem* )" << endl;
	if ( ! item )
		return ;
	KMFListViewItem* kmfitem = dynamic_cast<KMFListViewItem*> ( item );
	if ( kmfitem != 0  && kmfitem->type() == KMFListViewItem::NETZONE ) {
		m_host = 0;
		m_zone = kmfitem->zone();
		m_sb_host_1->setEnabled(false);
		m_sb_host_2->setEnabled(false);
		m_sb_host_3->setEnabled(false);
		m_sb_host_4->setEnabled(false);
		m_host_desc->setReadOnly( true );
		c_log_in->setEnabled(false);
		c_log_out->setEnabled(false);
		c_log_in->setChecked( false );
		c_log_out->setChecked( false );
		m_host_desc->clear();
	} else if ( kmfitem != 0  && kmfitem->type() == KMFListViewItem::NETHOST ) {
		m_host = kmfitem->host();
		m_zone = kmfitem->host()->zone();
		m_sb_host_1->setEnabled(true);
		m_sb_host_2->setEnabled(true);
		m_sb_host_3->setEnabled(true);
		m_sb_host_4->setEnabled(true);
		m_sb_host_1->blockSignals(true);
		m_sb_host_2->blockSignals(true);
		m_sb_host_3->blockSignals(true);
		m_sb_host_4->blockSignals(true);
		m_sb_host_1->setValue( m_host->address()->getDigit( 0 ) );
		m_sb_host_2->setValue( m_host->address()->getDigit( 1 ) );
		m_sb_host_3->setValue( m_host->address()->getDigit( 2 ) );
		m_sb_host_4->setValue( m_host->address()->getDigit( 3 ) );
		m_sb_host_1->blockSignals(false);
		m_sb_host_2->blockSignals(false);
		m_sb_host_3->blockSignals(false);
		m_sb_host_4->blockSignals(false);
		m_host_desc->setText( m_host->description() );
		m_host_desc->setReadOnly( false );
		c_log_in->setEnabled(true);
		c_log_out->setEnabled(true);
		c_log_in->setChecked( m_host->logIncoming() );
		c_log_out->setChecked( m_host->logOutgoing() );
		l_currHost->setText( i18n( "Host: %1").arg( m_host->guiName() ) );

	} else {
		kdDebug() << "KMFGenericInterfaceHost::slotNewItemSelected( QListViewItem* item ): WARNING unknown ListView Type!!!" << endl;
	}

}

/*!
    \fn KMFGenericInterfaceHost::slotRenameHost()
 */
void KMFGenericInterfaceHost::slotRenameHost() {
	kdDebug() << "void KMFGenericInterfaceHost::slotRenameHost()" << endl;
	if ( m_host ) {
		KMFListViewItem* it = findKMFItem(  m_host->guiName(), m_host->objectID() );
		if ( it ) {
			it->setRenameEnabled( 0, true );
			it->startRename( 0 );
		}
	}
}

void KMFGenericInterfaceHost::slotHostRenamed( QListViewItem* item, int , const QString& text ) {
	kdDebug() << "void KMFGenericInterfaceHost::slotHostRenamed( QListViewItem* item, int , const QString& text )" << endl;
	if ( ! item || text.isNull() )
		return ;
	KMFListViewItem* kmfitem = dynamic_cast<KMFListViewItem*> ( item );
	if ( kmfitem != 0  && kmfitem->type() == KMFListViewItem::NETHOST ) {
		m_host = kmfitem->host();
		m_zone = kmfitem->host()->zone();
		m_host->setGuiName( text );
		kdDebug() << "Setting GuiName: " << m_host->guiName() << "\ninternal Name: " << m_host->name() << endl;
		slotUpdateView();
	}

}
void KMFGenericInterfaceHost::slotAddressChanged( const QString& ) {
	kdDebug() << "void KMFGenericInterfaceProtocol::slotAddressChanged( const QString& )" << endl;
	if ( ! m_host )
		return;

	QString address  = "[" + m_sb_host_1->text() + "." +
									 m_sb_host_2->text() + "." +
									 m_sb_host_3->text() + "." +
									  m_sb_host_4->text()  + "]";

	m_host->address()->setAddress( m_sb_host_1->text() +"."+
													m_sb_host_2->text()+"."+
													m_sb_host_3->text()+"."+
													m_sb_host_4->text() );
	KMFListViewItem *it = findKMFItem( m_host->guiName(), m_host->objectID() );
	if ( it ) {
		it->setText( 1 ,  address );
	}
}

void KMFGenericInterfaceHost::slotTimerShot() {
// 	kdDebug() << "void KMFGenericInterfaceHost::slotTimerShot()" << endl;
	if ( m_host ) {
		m_host->setDescription( m_host_desc->text() );
		m_host->setLogIncoming( c_log_in->isChecked() );
		m_host->setLogOutgoing( c_log_out->isChecked() );
	}
}

/*!
    \fn KMFGenericInterfaceHost::slotRBM( QListViewItem*, const QPoint&, int )
 */
void KMFGenericInterfaceHost::slotZoneRBM( QListViewItem* item, const QPoint& point, int ){
	kdDebug() << "void KMFGenericInterfaceHost::slotRBM( QListViewItem*, const QPoint&, int )" << endl;
	if ( ! item )
		return ;
	KMFListViewItem* kmfitem = dynamic_cast<KMFListViewItem*> ( item );
	if ( kmfitem != 0  && kmfitem->type() == KMFListViewItem::NETZONE ) {
		kdDebug() << "Setting up Zone RBM:" << endl;
		m_host = 0;
		m_zone = 0;
		m_zone = kmfitem->zone();
		if ( m_zone ) {
			m_contextMenu->clear();
			QString name = m_zone->name();
			QString lab_str = i18n("Special Host Type: %1").arg( m_zone->guiName() );
			m_contextMenu->insertTitle( icon_chain, lab_str );
			m_contextMenu->insertItem( icon_new, i18n( "New Host..." ), this, SLOT( slotNewHost() ) );
			m_contextMenu->popup( point );
		}
	} else if (  kmfitem != 0  && kmfitem->type() == KMFListViewItem::NETHOST ) {
		m_host = 0;
		m_zone = 0;
		m_host = kmfitem->host();
		m_zone = kmfitem->host()->zone();
		if ( m_host ) {
			m_contextMenu->clear();
			QString name = m_zone->name();
			QString lab_str = i18n("Special Host: %1").arg( m_host->guiName() );
			m_contextMenu->insertTitle( icon_chain, lab_str );
			m_contextMenu->insertItem( icon_new, i18n( "New Host..." ), this, SLOT( slotNewHost() ) );
			m_contextMenu->insertItem( icon_rename, i18n( "Rename Host..." ), this, SLOT( slotRenameHost() ) );
			m_contextMenu->insertSeparator();
			m_contextMenu->insertItem( icon_del, i18n( "Delete Host" ), this, SLOT( slotDelHost() ) );

			m_contextMenu->popup( point );

		}
	}
}

KMFListViewItem* KMFGenericInterfaceHost::findKMFItem( const QString& text, int obj_id ) {
	if ( obj_id < -1 )
		return 0;
	QListViewItemIterator it( m_lv_zones );
	while ( it.current() ) {
		QListViewItem * qitem = it.current();
		++it;
		KMFListViewItem * item = 0;
		item = dynamic_cast<KMFListViewItem*> ( qitem );
		if ( item ) {
			if ( item->text( 0 ) == text && item->objectID() == obj_id )
			return item;
		} else {
			kdDebug() << "CAST ERROR: Item not of type KMFListViewItem" << endl;
		}
	}
// 	kdDebug() << "Couldn't find Item " << text << "  column: " << column << ", int obj_id: " << obj_id << endl;
	return 0;
}
KMFListViewItem* KMFGenericInterfaceHost::findKMFItem( int obj_id ) {
	if ( obj_id < -1 )
		return 0;
	QListViewItemIterator it( m_lv_zones );
	while ( it.current() ) {
		QListViewItem * qitem = it.current();
		++it;
		KMFListViewItem * item = 0;
		item = dynamic_cast<KMFListViewItem*> ( qitem );
		if ( item ) {
			if ( item->objectID() == obj_id )
			return item;
		} else {
			kdDebug() << "CAST ERROR: Item not of type KMFListViewItem" << endl;
		}
	}
// 	kdDebug() << "Couldn't find Item " << text << "  column: " << column << ", int obj_id: " << obj_id << endl;
	return 0;
}

void KMFGenericInterfaceHost::loadIcons() {
	kdDebug() << "void KMFGenericInterfa::loadIcons()" << endl;
	KIconLoader *loader = KGlobal:: iconLoader();
	QString icon_name;

	icon_name = "up";
	icon_up = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "down";
	icon_down = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "editdelete";
	icon_del = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "filenew";
	icon_new = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "edit";
	icon_edit = loader->loadIcon( icon_name, KIcon::Small );


	icon_name = "filter";
	icon_filter = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "text";
	icon_rename = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "rule-22";
	icon_rule = loader->loadIcon( icon_name, KIcon::User );

	icon_name = "view_tree";
	icon_chain = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "reject";
	icon_reject = loader->loadIcon( icon_name, KIcon::User );

	icon_name = "target";
	icon_target = loader->loadIcon( icon_name, KIcon::User );

	icon_name = "stop";
	icon_drop = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "button_ok";
	icon_accept = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "filesaveas";
	icon_log = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "undo";
	icon_return = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "editclear";
	icon_cmd = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "filter";
	icon_filter = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "pipe";
	icon_queue = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "editcopy";
	icon_copy = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "forward";
	icon_move = loader->loadIcon( icon_name, KIcon::Small );

}


#include "kmfgenericinterfacehost.moc"
