/***************************************************************************
                                 qsworkbook.cpp
                             -------------------                                         
    begin                :
    copyright            : (C) 2001 by Kamil Dobkowski
    email                : kamildobk@poczta.onet.pl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include"qsworkbook.h"
#include"qsdrvqt.h"
#include"qsaxes.h"
#include<qpaintdevicemetrics.h>
#include<qprinter.h>
#include<qwidget.h>
#include"qschildlist.h"
#include"qsconsole.h"


//---------------------------------------------------------------------------------------------------//

QSPage::QSPage( QObject *parent )
: QObject( parent )
 {
  m_title = QString::null;
  m_objects = new QSCObjectCollection( this );
  connect( m_objects, SIGNAL(sigChanged()), this, SLOT(slot_collection_changed()) );
 }

//---------------------------------------------------------------------------------------------------//

QSPage::~QSPage()
 {
  m_objects->stop();
 }

//---------------------------------------------------------------------------------------------------//

void QSPage::setTitle( const QString& title )
 {
  if ( m_title != title ) {
  	m_title = title;
	emit sigTitleChanged( m_title );
	}
 }

 //---------------------------------------------------------------------------------------------------//

void QSPage::paint( QPainter *p, double dpi, bool blocking )
 {
  m_objects->stop();
  m_objects->paint( p, dpi, blocking, true );
 }

//---------------------------------------------------------------------------------------------------//

void QSPage::slot_collection_changed()
 {
  emit sigPageChanged();
 }



//---------------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------------//





QSWorkbook::QSWorkbook( QObject *parent  )
:QObject( parent )
 {
  m_printer = NULL;
  m_page_list = new QSChildList<QSPage>();
 }

//-------------------------------------------------------------//

QSWorkbook::~QSWorkbook()
 {
  delete m_page_list;
 }

//-------------------------------------------------------------//

int QSWorkbook::pageCount() const
 {
  return m_page_list->count();
 }

//-------------------------------------------------------------//

void QSWorkbook::clear()
 {
  QSPage *curr_page = page(0);
  while( curr_page ) {
	pageDelete(0);
	curr_page = page(0);
	}
 }

//-------------------------------------------------------------//

void QSWorkbook::print( QPainter *painter, QPrinter *printer, double dpi )
 {
  int page_nr;
  int page_step;

  printer->setFullPage( TRUE );
  int page_min = QMAX( QMIN( printer->fromPage(), printer->toPage() ), 1 );
  int page_max = QMIN( QMAX( printer->fromPage(), printer->toPage() ), pageCount() );
  if ( printer->pageOrder() == QPrinter::FirstPageFirst ) {
	 page_step = 1;
	 page_nr = page_min;
	} else {
	 page_step = -1;
	 page_nr = page_max;
	}

  while( page_nr >= page_min && page_nr <= page_max ) {
	 QSConsole::write( tr("Printing page %1 ...").arg(page_nr) );
	 QSPage *curr_page = page(page_nr-1);	
	 curr_page->paint( painter, dpi, true );
	 page_nr += page_step;
	 if ( page_nr >= page_min && page_nr <= page_max ) printer->newPage();
	}
 }

//-------------------------------------------------------------//

void QSWorkbook::pageAdd( QSPage *page )
 {
  if ( page ) {
	static int page_nr = 1;
	if ( page->title().isNull() ) page->setTitle( tr("Page %1").arg(page_nr++) );
  	m_page_list->add( page );
	connect( page->objects(), SIGNAL(sigAdded(QSCObject*)),   this, SLOT(slot_object_added(QSCObject*)) );
	connect( page->objects(), SIGNAL(sigRemoved(QSCObject*)), this, SLOT(slot_object_removed(QSCObject*)) );
	connect( page->objects(), SIGNAL(sigOrderChanged()), this, SLOT(slot_object_order()) );
	connect( page, SIGNAL(sigTitleChanged(const QString&)), this, SLOT(slot_page_title_changed(const QString&)) );
	connect( page, SIGNAL(sigPageChanged()), this, SLOT(slot_page_changed()) );
        emit sigPageAdded( page );
        emit sigPageListChanged();
	emit sigWorkbookChanged();
	}
 }

//-------------------------------------------------------------//

void QSWorkbook::pageInsert( int position, QSPage *page )
 {
  if ( page ) {
	if ( page->title().isNull() ) page->setTitle( tr("Page %1").arg(pageCount()+1) );
  	m_page_list->insert( position, page );
	connect( page->objects(), SIGNAL(sigAdded(QSCObject*)),   this, SLOT(slot_object_added(QSCObject*)) );
	connect( page->objects(), SIGNAL(sigRemoved(QSCObject*)), this, SLOT(slot_object_removed(QSCObject*)) );
	connect( page->objects(), SIGNAL(sigOrderChanged()), this, SLOT(slot_object_order()) );
	connect( page, SIGNAL(sigTitleChanged( const QString& )), this, SLOT(slot_page_title_changed( const QString& )) );
	connect( page, SIGNAL(sigPageChanged()), this, SLOT(slot_page_changed()) );
        emit sigPageAdded( page );
        emit sigPageListChanged();
	emit sigWorkbookChanged();
	}
 }

//-------------------------------------------------------------//

void QSWorkbook::pageRemove( int index )
 {
  QSPage *removed_page = page( index );
  if ( removed_page ) {
	disconnect( removed_page->objects(), SIGNAL(sigAdded(QSCObject*)),   this, SLOT(slot_object_added(QSCObject*)) );
	disconnect( removed_page->objects(), SIGNAL(sigRemoved(QSCObject*)), this, SLOT(slot_object_removed(QSCObject*)) );
	disconnect( removed_page->objects(), SIGNAL(sigOrderChanged()), this, SLOT(slot_object_order()) );
	disconnect( removed_page, SIGNAL(sigTitleChanged( const QString& )), this, SLOT(slot_page_title_changed( const QString& )) );
	disconnect( removed_page, SIGNAL(sigPageChanged()), this, SLOT(slot_page_changed()) );
	m_page_list->remove( index );
	emit sigPageRemoved( removed_page );
	emit sigPageListChanged();
	emit sigWorkbookChanged();
	}
 }

//-------------------------------------------------------------//

void QSWorkbook::pageDelete( int index )
 {
  QSPage *curr_page = page( index );
  if ( curr_page ) {
	pageRemove( index );
	delete curr_page;
	}
 }

//-------------------------------------------------------------//

void QSWorkbook::pageRaise( int index )
 {
  m_page_list->raise( index );
  emit sigPageOrder();
  emit sigPageListChanged();
  emit sigWorkbookChanged();
 }

//-------------------------------------------------------------//

void QSWorkbook::pageLower( int index )
 {
  m_page_list->lower( index );
  emit sigPageOrder();
  emit sigPageListChanged();
  emit sigWorkbookChanged();
 }

//-------------------------------------------------------------//

void QSWorkbook::pageReorder( int position, int index )
 {
  m_page_list->reorder( position, index );
  emit sigPageOrder();
  emit sigPageListChanged();
  emit sigWorkbookChanged();
 }

//-------------------------------------------------------------//

void QSWorkbook::pageToFront( int index )
 {
  m_page_list->toFront( index );
  emit sigPageOrder();
  emit sigPageListChanged();
  emit sigWorkbookChanged();
 }

//-------------------------------------------------------------//

void QSWorkbook::pageToBack( int index )
 {
  m_page_list->toBack( index );
  emit sigPageOrder();
  emit sigPageListChanged();
  emit sigWorkbookChanged();
 }

//-------------------------------------------------------------//

int QSWorkbook::pageFind( QSPage *page ) const
 {
  return m_page_list->find(page);
 }

//-------------------------------------------------------------//

QSPage *QSWorkbook::pageFind( QSCObject *object ) const
 {
  for( int page_nr=0; page_nr<pageCount(); page_nr++ ) {
	QSPage *curr_page = page(page_nr);
	if ( curr_page->objects()->find(object) >= 0 ) return curr_page;
	}
  return NULL;
 }

//-------------------------------------------------------------//

QSPage *QSWorkbook::page( int index ) const
 {
  return (*m_page_list)[index];
 }

//-------------------------------------------------------------//

void QSWorkbook::setPrinter( QPrinter *printer )
 {
  m_printer = printer;
  emit sigPrinterChanged();
  emit sigWorkbookChanged();
 }

//-------------------------------------------------------------//

void QSWorkbook::slot_object_added(QSCObject *object)
 {
  emit sigObjectAdded(object);
 }

//-------------------------------------------------------------//

void QSWorkbook::slot_object_removed(QSCObject *object)
 {
  emit sigObjectRemoved(object);
 }

//-------------------------------------------------------------//

void QSWorkbook::slot_object_order()
 {
  emit sigObjectOrder();
 }

//-------------------------------------------------------------//

void QSWorkbook::slot_page_changed()
 {
  emit sigWorkbookChanged();
 }

//-------------------------------------------------------------//

void QSWorkbook::slot_page_title_changed( const QString& )
 {
  emit sigPageListChanged();
  emit sigWorkbookChanged();
 }

