
/***************************************************************************
                               qsdrvqt.h
                             -------------------                                         
    begin                : 01-January-2000
    copyright            : (C) 2000 by Kamil Dobkowski                         
    email                : kamildobk@poczta.onet.pl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef QSDRVQT_H
#define QSDRVQT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include"qsdrv.h"
#include<math.h>
#include<qpainter.h>

class QImage;

//-------------------------------------------------------------//

/**
  * \brief Implementation of QSDrv for Qt.
  * @author Kamil Dobkowski
  */
class QSDrvQt : public QSDrv
 {
  public:
   /**
     * Constructor.
     */
	QSDrvQt();
   /**
     * Destructor.
     */
	virtual ~QSDrvQt();
	/**
	  * Returns a copy of this object.
	  */
	virtual QSDrvQt *copy();
	/**
	  * Creates and returns a copy of painter.
	  */
	static QPainter *copyPainter( const QPainter *painter );
	/**
	  * Copies painter, dpi settings.
	  */
	void copySettingsFrom( const QSDrvQt *drv );
   /**
     * Sets a painter. If deletePainter is true, painter is deleted in destructor.
     * This driver calls neither p->start(), nor p->stop()
     */
	virtual void setDC( QPainter *p, double dpi = 72.0, bool deletePainter = false );
     /**
       * Returns painter
       */
	QPainter *painter() const { return m_paint; }
	/**
	  * Returns 'delete' painter setting
	  */
	bool deletePainter() const { return m_delete_painter; }

   /**
     * Reimplemented from @ref QSDrv::startDraw .
     */
	void startDrawing();
   /**
     * Reimplemented from @ref QSDrv::stopDraw .
     * Doesn,t call paint->end().
     */
	void stopDrawing();

	void clearCanvas( const QSGFill& f, const QSPt2f& pos, const QSPt2f& size );
	void drawLine( const QSPt2f &one, const QSPt2f &two );
	void beginPolyline( const QSPt2f& pos );
	void drawPolylineTo( const QSPt2f& pos );
	void endPolyline();	
	QSPt2f currPolylinePos() { return m_curr_polyline_pos; }
	void drawRect( const QSPt2f &p1, const QSPt2f &p2 );
	void drawPoly( const QSPt2f pts[], int npoints, const bool edges[] = NULL, int edgeAutoColor = 0 );
	void drawEllipse( const QSPt2f& p1, const QSPt2f& p2  );
	void drawText( const QSPt2f &pos, const QString& text, int align = AlignLeft | AlignBottom );
	QSPt2f textSize( const QString& text );
	void drawRText( const QSPt2f &pos, int angle, const QString& text, int align = AlignLeft | AlignBottom );
	void getRTextBoundingPoly(  QSPt2f outPts[4], const QSPt2f &pos, int angle, const QString& text, int align = AlignLeft | AlignBottom );
	void getPixmapBuffer( PixmapBuffer *buff, int pwidth, int pheight );
	void drawPixmap( const QSPt2f& pos, PixmapBuffer *data );
	void setFill( const QSGFill &f );
	void setFont( const QSGFont &f );
	void setLine( const QSGLine &l );
	QSGFont currentFont();
	QSGFill currentFill();
	QSGLine currentLine();
     /**
       * Converts 'QFont' to 'QSGFont' .
       */
	static QSGFont toQSGFont( const QFont &f, const QColor &c, double dpi = 72.0 );
     /**
       * Converts 'QSGFont' to 'QFont' .
       */
	static QFont toQFont( const QSGFont &f, double dpi = 72.0 );
     /**
       * Converts 'QColor' to 'QSGColor' .
       */
	static QSGColor toQSGColor( const QColor &c );
     /**
       * Converts 'QSGColor' to 'QColor' .
       */
	static QColor toQColor( const QSGColor &c );
     /**
       * Converts 'QBrush' to 'QSGFill' .
       */
	static QSGFill toQSGFill( const QBrush &b );
     /**
       * Converts 'QSGFill' to 'QBrush' .
       */
	static QBrush toQBrush( const QSGFill &f );
     /**
       * Converts 'QPen' to 'QSGLine' .
       */
	static QSGLine toQSGLine( const QPen &p );
      /**
       * Converts 'QSGLine' to 'QPen' .
       */
 	static QPen toQPen( const QSGLine &p );

    protected:
	QPainter	*m_paint;
	QPointArray	m_vert_array;
	QPointArray	m_edge_array;
	QImage		*m_pixmap;
	QSGLine		m_line;
	QSGFill		m_cfill;
	QSGFont		m_curr_font;
	bool		m_delete_painter;
        QPen		m_curr_pen;

	QSPt2f m_curr_polyline_pos;
	int m_curr_polyline_style;
	double m_curr_polyline_t;
	double m_curr_polyline_pattern_length;
	double m_curr_polyline_pattern[6];
	static const int defpatterns[4][6];
	QPoint align_rect( const QRect& r, int align );
	inline int toInt( double value ) { return int(value+0.5); }
	void set_auto_pen( int autoColor );
 };


#endif











































































