/***************************************************************************
                                 qsctool.cpp
                             -------------------
    begin                : Sun Jan 30 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildbk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include"qsctool.h"
#include"qsdrvqt.h"
#include"qsplotview.h"
#include<qpainter.h>

QSTool::QSTool( QObject *parent )
: QObject( parent )
 {
  m_drv  = NULL;
  m_view = NULL;
  m_state = StateReady;
  m_snap_to_grid = false;
 }

//-------------------------------------------------------------//

QSTool::~QSTool()
 {
  deactivate();
 }

//-------------------------------------------------------------//

void QSTool::activate( QSPlotView *parent_view )
 {
  m_view = parent_view;
  m_state = StateReady;
 }

//-------------------------------------------------------------//

void QSTool::deactivate()
 {
  release_driver();
  m_view = NULL;
 }

//-------------------------------------------------------------//

bool QSTool::canvasEvent( QEvent *e )
 {
  switch ( e->type() ) {
     case QEvent::MouseButtonDblClick:	return eventMouseDblClick( static_cast<QMouseEvent*>(e) );
     case QEvent::MouseButtonPress:     return eventMousePress( static_cast<QMouseEvent*>(e) );
     case QEvent::MouseButtonRelease:   return eventMouseRelease( static_cast<QMouseEvent*>(e) );
     case QEvent::MouseMove:		return eventMouseMove( static_cast<QMouseEvent*>(e) );
     case QEvent::KeyPress:		return eventKeyPress( static_cast<QKeyEvent*>(e) );
     case QEvent::KeyRelease:		return eventKeyRelease( static_cast<QKeyEvent*>(e) );
     default: break;
    }
  return FALSE;
 }

//-------------------------------------------------------------//

bool QSTool::eventMouseDblClick( QMouseEvent *e )
 {
  if ( m_state == StateReady && e->button() == Qt::LeftButton ) {
	canvasDoubleClicked( e->pos(), e->state() );
	return true;
	}
  return false;
 }

//-------------------------------------------------------------//

bool QSTool::eventMousePress( QMouseEvent *e  )
 {
  if ( m_state == StateReady ) {
  	if ( e->button() == Qt::RightButton ) {
		m_state = StateRightButtonPressed;
		return true;
		}
	else if ( e->button() == Qt::MidButton ) {
		m_state = StateMiddleButtonPressed;
		return true;
		}
	else if ( e->button() == Qt::LeftButton ) {
		m_state = StateLeftButtonPressed;
		m_drag_start_pos = e->pos();
		m_drag_start_key = e->state();
		m_drag_prev_pos = e->pos();
		m_drag_prev_key = e->state();
		return true;
		}	
	}
  return false;
 }

//-------------------------------------------------------------//

bool QSTool::eventMouseRelease( QMouseEvent *e )
 {
  if ( m_state == StateRightButtonPressed && e->button() == Qt::RightButton ) {
	m_state = StateReady;
	canvasRightButtonClicked( e->pos(), e->state() );
	return true;
	}
  if ( m_state == StateMiddleButtonPressed && e->button() == Qt::MidButton ) {
	m_state = StateReady;
	canvasMiddleButtonClicked( e->pos(), e->state() );
	return true;
	}
  if ( m_state == StateLeftButtonPressed && e->button() == Qt::LeftButton ) {
	m_state = StateReady;
	canvasClicked( e->pos(), e->state() );
	return true;
	}
 if ( m_state == StateDragging && e->button() == Qt::LeftButton ) {
	m_state = StateReady;
	canvasDragMove( e->pos(), m_drag_prev_pos, m_drag_start_pos, e->state(), m_drag_prev_key, m_drag_start_key );
	canvasDragEnd( e->pos(), m_drag_start_pos, e->state(), m_drag_start_key );
	return true;
	}
 return false;
 }

//-------------------------------------------------------------//

bool QSTool::eventMouseMove( QMouseEvent *e  )
 {
  if ( m_state == StateLeftButtonPressed && (e->state() & Qt::LeftButton) ) {
	// eliminate some noise moves
	if ( abs(m_drag_start_pos.x()-e->pos().x()) > 2 ||
	     abs(m_drag_start_pos.y()-e->pos().y()) > 2 ||
	     (m_drag_start_key& Qt::ShiftButton) )
	if ( canvasDragStart( m_drag_start_pos, e->state() ) ) {
		m_state = StateDragging;
		canvasDragMove( e->pos(), m_drag_prev_pos, m_drag_start_pos, e->state(), m_drag_prev_key, m_drag_start_key );
		m_drag_prev_pos = e->pos();
		m_drag_prev_key = e->state();
		} else {
		m_state = StateReady;
		}
	return true;
	}
  else if ( m_state == StateDragging && (e->state() & Qt::LeftButton) ) {
	canvasDragMove( e->pos(), m_drag_prev_pos, m_drag_start_pos, e->state(), m_drag_prev_key, m_drag_start_key );
	m_drag_prev_pos = e->pos();
	m_drag_prev_key = e->state();
	return true;
	}
  else if ( m_state == StateReady ) {
	canvasMove( e->pos() );
	return true;
	}
  return false;
 }


//-------------------------------------------------------------//

bool QSTool::eventKeyPress(  QKeyEvent*  )
 {
 return false;
 }

 //-------------------------------------------------------------//

bool QSTool::eventKeyRelease( QKeyEvent*  )
 {
  return false;
 }

//-------------------------------------------------------------//

void QSTool::canvasClicked( const QPoint&, int )
 {
 }

//-------------------------------------------------------------

void QSTool::canvasMiddleButtonClicked( const QPoint&, int )
 {
 }

//-------------------------------------------------------------

void QSTool::canvasRightButtonClicked( const QPoint&, int )
 {
 }

//-------------------------------------------------------------//

bool QSTool::canvasDragStart( const QPoint&, int )
 {
  return false;
 }

//-------------------------------------------------------------

void QSTool::canvasDragMove( const QPoint&, const QPoint&, const QPoint&, int, int, int  )
 {
 }

//-------------------------------------------------------------

void QSTool::canvasDragEnd( const QPoint&, const QPoint&, int, int )
 {
 }

//-------------------------------------------------------------//

void QSTool::canvasMove( const QPoint& )
 {
 }

//-------------------------------------------------------------//

void QSTool::canvasDoubleClicked( const QPoint&, int )
 {
 }

//-------------------------------------------------------------//

QSDrvQt *QSTool::driver()
 {
  if ( !m_drv ) {
         m_drv = new QSDrvQt();
         m_drv->setDC(new QPainter(m_view->canvasWidget()),m_view->dpi(),true);
         m_drv->startDrawing();
        }
  return m_drv;
 }

//-------------------------------------------------------------//

void QSTool::release_driver()
 {
  if ( m_drv ) {
	m_drv->stopDrawing();
	delete m_drv; m_drv = NULL;
	}
 }

//-------------------------------------------------------------//

double QSTool::snapToGridX( double canvas_x, int keyState )
 {
  double result = canvas_x;
  double spacing_x = m_view->gridSpacingX();
  if ( m_view->gridVisible() && spacing_x > 0.0 && !(keyState & Qt::ShiftButton) )
  	 result = QSCoord::mmToPixels( floor(QSCoord::pixelsToMM(canvas_x,driver()->dpi)/spacing_x+0.5)*spacing_x, driver()->dpi );	
  return result;
 }

//-------------------------------------------------------------//

double QSTool::snapToGridY( double canvas_y, int keyState )
 {
  double result = canvas_y;
  double spacing_y = m_view->gridSpacingY();
  if ( m_view->gridVisible() && spacing_y > 0.0 && !(keyState & Qt::ShiftButton) )
  	 result = QSCoord::mmToPixels( floor(QSCoord::pixelsToMM(canvas_y,driver()->dpi)/spacing_y+0.5)*spacing_y, driver()->dpi );
  return result;
 }

//-------------------------------------------------------------//

QSPt2f QSTool::snapToGrid( const QPoint& pos, int keyState )
 {
  return snapToGrid( QSPt2f(pos), keyState );
 }

//-------------------------------------------------------------//

QSPt2f QSTool::snapToGrid( const QSPt2f& pos, int keyState )
 {
  return QSPt2f( snapToGridX(pos.x,keyState), snapToGridY(pos.y,keyState) );
 }

//-------------------------------------------------------------//

int QSTool::snapAngle( int angle, int keyState )
 {
  if ( !(keyState & Qt::ShiftButton) ) angle = int(angle/15)*15;
  return angle;
 }




