/***************************************************************************
                                qsclegend.h
                             -------------------
    begin                : 01-January-2001
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildobk@poczta.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef QSCLEGEND_H
#define QSCLEGEND_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include"qscobject.h"



/**
  * \brief Graph legend
  * Graph legend - it automatically displays items for all datasets in the parent graph..
  */
class QSCLegend : public QSCObject
 {
  Q_OBJECT
	Q_PROPERTY( int columns READ columns WRITE setColumns )
	Q_PROPERTY( int align READ align WRITE setAlign )
	Q_PROPERTY( double posX READ posX WRITE setPosX )
	Q_PROPERTY( double posY READ posY WRITE setPosY )
	Q_PROPERTY( double posZ READ posZ WRITE setPosZ )
	Q_PROPERTY( int coordX READ coordX WRITE setCoordX )
	Q_PROPERTY( int coordY READ coordY WRITE setCoordY )
 	Q_PROPERTY( int coordZ READ coordZ WRITE setCoordZ )
	Q_PROPERTY( QString font READ fontProperty WRITE setFontProperty )
	Q_PROPERTY( QString fill READ fillProperty WRITE setFillProperty )
        Q_PROPERTY( QString frame READ frameProperty WRITE setFrameProperty )
	Q_PROPERTY( QString shadowFill READ shadowFillProperty WRITE setShadowFillProperty )
	Q_PROPERTY( int shadowPosX READ shadowPosX WRITE setShadowPosX )
	Q_PROPERTY( int shadowPosY READ shadowPosY WRITE setShadowPosY )

   public:
	/**
	 * Constructor. parentAxes must exist ( must not be NULL ).
	 */
	QSCLegend( QSAxes *parentAxes, QObject *parent=NULL );
	virtual ~QSCLegend();
        virtual int style() { return Moveable; }
        virtual void draw( QSDrv *drv, bool blocking=true, bool transparent=true );
	virtual void setBox( const QSRectf& r, QSDrv *drv );
	virtual QSRectf box( QSDrv *drv );
    	virtual QString name();

	void setColumns( int columns );
	int columns() const { return m_columns; }
	void setAlign( int align );	
	int align() const { return m_align; }
	void setPos( const QSPt3f& pos );
	void setPosX( double value );
	void setPosY( double value );
	void setPosZ( double value );	
	QSPt3f pos() const { return m_pos; }
	double posX() const { return m_pos.x; }
	double posY() const { return m_pos.y; }
	double posZ() const { return m_pos.z; }	
	void setCoord( const QSPt3& coordSystem );
	void setCoordX( int coordSystem );
	void setCoordY( int coordSystem );	    	
	void setCoordZ( int coordSystem );
	QSPt3 coord() const { return m_axis; }
	int coordX() const { return m_axis.x; }
	int coordY() const { return m_axis.y; }
	int coordZ() const { return m_axis.z; }
	void setFont( const QSGFont& font );
        void setFontProperty( const QString& data );
	QSGFont font() const { return m_font; }
	QString fontProperty() const { return toQString(m_font); }
	void setFill( const QSGFill& fill );
	void setFillProperty( const QString &data );
	QSGFill fill() const { return m_fill; }
	QString fillProperty() const { return toQString(m_fill); }
	void setFrame( const QSGLine& line );
	void setFrameProperty( const QString& data );
	QSGLine frame() const { return m_frame; }
	QString frameProperty() const { return toQString(m_frame); }
	void setShadowFill( const QSGFill& fill );
	void setShadowFillProperty( const QString& data );
	QSGFill shadowFill() const { return m_shadow_fill; }
	QString shadowFillProperty() const { return toQString(m_shadow_fill); }
	void setShadowPos( const QSPt2& shift );
	void setShadowPosX( int shift );
	void setShadowPosY( int shift );		
	QSPt2 shadowPos() const { return m_shadow_pos; }
	int shadowPosX() const { return m_shadow_pos.x; }
	int shadowPosY() const { return m_shadow_pos.y; }
	virtual void loadStateFromStream( QDataStream& stream, QSObjectFactory *factory );
	virtual void saveStateToStream( QDataStream& stream, QSObjectFactory *factory );

    protected:
	int m_columns;
	int m_align;
        QSPt3f  m_pos;
        QSPt3   m_axis;
	QSGFont m_font;
	QSGFill m_fill;
	QSGLine m_frame;
	QSGFill m_shadow_fill;
	QSPt2   m_shadow_pos;

     private:
        static const double frmSpace ;
	static const double rowSpace ;
	static const double colSpace ;
	void do_everything( QSDrv *drv, QSRectf& rect, double average_height, bool draw );
	double get_height( QSDrv *drv );
 	};

#endif

