/***************************************************************************
                          qschildlist.h  -  description
                             -------------------
    begin                : Thu Aug 23 2001
    copyright            : (C) 2001 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QSCHILDLIST_H
#define QSCHILDLIST_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include<deque.h>

/**
  * \brief Internal class
  *
  * Class intended for internal use as a internal child list for QSData objects.
  * You can also remember one iterator position, see setPosition() position(),
  * current(). All object must not be allocated on a stack. This list doesn't allow NULL memebers.
  * @author Kamil Dobkowski
  */
template<class CHILD_OBJECT>
class QSChildList {
  public:
     QSChildList( bool autoDelete = true ) {
		m_index = 0;
		m_auto_delete = autoDelete;
		}
    ~QSChildList() {
		while( count() ) del(0);
		}
     void setPos( int index ) {
		m_index = index;
		}
     int pos() const {
		return m_index;
		}
     CHILD_OBJECT *current() const {
		return operator[]( m_index );
		}
     bool isValidPos() const  {
		return valid(m_index);
		}
     int count() const {
		return (int )m_child_list.size();
		}
     void add( CHILD_OBJECT *object ) {
		insert( count(), object );
		}
     void insert( int before_pos, CHILD_OBJECT *object ) {
		before_pos = QMIN( before_pos, count() );
		before_pos = QMAX( before_pos, 0 );
		if ( object ) m_child_list.insert( m_child_list.begin()+before_pos, object );
		}
     CHILD_OBJECT *remove( int index ) {
		if ( valid(index) ) {	
			CHILD_OBJECT *object = m_child_list[index];
			m_child_list.erase( m_child_list.begin() + index );
			return object;
			}
		return NULL;
		}
     void del( int index ) {
		if ( m_auto_delete ) delete remove(index); else remove(index);
		}
     void toFront( int index ) {
		if ( valid(index) ) m_child_list.push_back(  remove(index) );
		}
     void toBack( int index ) {
		if ( valid(index) ) m_child_list.push_front( remove(index) );
		}
     void raise( int index ) {
		if ( index<count()-1 ) reorder( index+1, index );
		}
     void lower( int index ) {
                if ( index>0 ) reorder( index-1, index );
		}
     void reorder( int position, int index ) {
 		position = QMIN( position, count() );
		position = QMAX( position, 0 );
		if ( valid(index) ) {
			 CHILD_OBJECT *object = remove(index);
			 m_child_list.insert( m_child_list.begin() + position, object  );			
			}		
		}
     int find( CHILD_OBJECT *object ) const {
		for( int i=0; i<count(); i++ ) if ( m_child_list[i] == object ) return i;
		return -1;
		}
     CHILD_OBJECT *operator[]( int index ) const  {
		return valid(index) ? m_child_list[index] : NULL;
		}
     inline bool valid( int index ) const {
		return ( index<count() && index>=0 );
		}
     inline bool autoDelete() const {
		return m_auto_delete;
		}
  private:
     int m_index;
     bool m_auto_delete;
     deque<CHILD_OBJECT*> m_child_list;
 };

#endif

