function [result]=kmesh(x,y,z)
//
// mesh(z)     - plots z-surface
// mesh(x,y,z) - plots z surface versus x,y rows. x,y must be monotone
// mesh(facets_x,facets_y,facets_z) - plots figure
//
// 	all matrices have the same size
// 	rows(facets_*) = number of vertices in a single facet ( 3d polygon )
//	cols(facets_*) = number of facets ( 3d polygons )
//	if rows(facets_*) == 1 plots a 3d trajectory
//	facets_x = x coordinates, facets_y = y coordinates, facets_z = z coordinates
//
result=1
[out in]=argn(0)
if in==1 then
// surface
// kremoveall();
  dataset = kadd(3);
  ksetmatrix(dataset,2,x);  // z
elseif in==3 then
  if size(x)==size(y) & size(y)==size(z) then
    // kremoveall();
    dataset = kadd(4);
    // 3d figure
    ksetmatrix(dataset,0,x); // facets x
    ksetmatrix(dataset,1,y); // facets y
    ksetmatrix(dataset,2,z); // facets z
  else
    // surface
    // kremoveall();
    dataset = kadd(3);
    if size(x,2) <> size(z,2) then, x=x', end
    if size(y,1) <> size(z,1) then, y=y', end

    if size(x,2) <> size(z,2) then, error("length(x) must be equal to cols(z) !"); result=0, end
    if size(y,1) <> size(z,1) then, error("length(y) must be equal to rows(z) !"); result=0, end

    ksetmatrix(dataset,0,x); // x
    ksetmatrix(dataset,1,y); // y
    ksetmatrix(dataset,2,z); // z
  end
else
  result = 0;
  error("Wrong number of arguments !");
end
end