/***************************************************************************
                                  ksetapp.cc
                             -------------------
    begin                : Sun Jun 25 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildobk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <octave/oct.h>
#include <iostream.h>
#include "octave-common.h"

#define ENV_APP_NUMBER "__kmatplot_app_num__"

DEFUN_DLD (ksetapp, args, ,
" usage: prevAppNumber = ksetapp (newAppNumber)\n"
"        currAppNumber = ksetapp()\n"
"\n"
"Sets a new 'KMatplot' application as a plot output."
"Application number must be > 0."
"See also: ksetaxes, kplot, kadd, kremove, kremoveall, kaddaxes, kremoveaxes, kimage, kcontour, kmesh, ksetmatrix" )
{
  int app_num = appNumber();

  //
  // New app number
  //
  if ( args.length() > 0 ) {

     int new_app_num = (int )args(0).double_value();
		 if ( new_app_num <= 0 ) new_app_num = 1;

		 char buff[50];
		 sprintf( buff, "%d", new_app_num );
		 setenv( ENV_APP_NUMBER, buff, 1 );
		}

  return octave_value_list( (double )app_num );
}

