/***************************************************************************
                                  kmesh.cc
                             -------------------
    begin                : Sun Jun 25 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildobk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <octave/oct.h>
#include <iostream.h>
#include <errno.h>
#include "octave-common.h"

DEFUN_DLD (kcontour, args, ,
" usage: kcontour(z)\n"
"        kcontour(x,y,z)\n"
"\n"
"See also: ksetapp, ksetaxes, kadd, kremove, kremoveall, kaddaxes, kremoveaxes, kplot, kimage, kmesh, ksetmatrix" )
{
  octave_value_list result( -1.0 );

  int nargin = args.length();
  if ( nargin != 1 && nargin != 3  ) {
     error("wrong number of arguments");
     return result;
     }

  int socket_fd = plot_connect( appNumber(), NULL, NULL );
  if ( socket_fd == -1 && errno < sys_nerr && errno >= 0 ) {
		error( sys_errlist[errno] );
		return result;
		}

  int dataset_number = -1;
  //plot_remove_all_datasets( socket_fd, axesNumber() );		

  if ( nargin == 1 ) {
	// Simple contour
	Matrix m = args(0).matrix_value();
	dataset_number = plot_add_dataset( socket_fd, axesNumber(), PlotContour );
        setMatrix( socket_fd, dataset_number, 2, m ); // v
  	}
  else
  if ( nargin == 3 ) {
     	Matrix x = args(0).matrix_value();
     	Matrix y = args(1).matrix_value();
     	Matrix z = args(2).matrix_value();
     	int rows = z.rows();
     	int cols = z.cols();

	// Contour normalize x to row vector
        if ( x.cols() == 1 ) { Matrix temp = x.transpose(); x = Matrix(); x = temp; }
        else
	if ( x.rows() > 1 && x.cols() > 1 ) {
	       error(" x must be a vector !" );
               plot_disconnect( socket_fd );
	       return result;	
	       }

	// normalize y to column vector
        if ( y.rows() == 1 ) { Matrix temp = y.transpose(); y = Matrix(); y = temp; }
	else
	if ( y.rows() > 1 && y.cols() > 1 ) {
		error(" y must be a vector !" );
		plot_disconnect( socket_fd );
		return result;	
		}

        if ( rows != y.rows() ) {
	       error(" rows (z) must be the same as length (y)");
               plot_disconnect( socket_fd );
	       return result;
	       }

	if ( cols != x.cols() ) {
               error("colums (z) must be the same as length (x)");
               plot_disconnect( socket_fd );
	       return result;
	       }

        dataset_number = plot_add_dataset( socket_fd, axesNumber(), PlotContour );
	setMatrix( socket_fd, dataset_number, 0, x );
	setMatrix( socket_fd, dataset_number, 1, y );	
     	setMatrix( socket_fd, dataset_number, 2, z );
    }

  plot_disconnect( socket_fd );
  return octave_value_list( (double )dataset_number );
}

