/***************************************************************************
                          ksworkspace.cpp  -  description
                             -------------------
    begin                : Thu Jan 17 2002
    copyright            : (C) 2002 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ksworkspace.h"
#include"kmatplotshell.h"
#include"pixmaps/action_windows.xpm"

#include<qworkspace.h>
#include<qlayout.h>
#include<qpushbutton.h>
#include<qhbuttongroup.h>
#include<qpopupmenu.h>
#include<qaction.h>
#include<qcursor.h>

KSWorkspace::KSWorkspace( KMatplotShell *shell, const char *name )
: QWidget(shell,name)
 {
  m_shell = shell;
  QVBoxLayout *layout = new QVBoxLayout( this );
  m_workspace = new QWorkspace( this );
  connect( m_workspace, SIGNAL(windowActivated(QWidget*)), this, SLOT(slot_window_activated(QWidget*)) );
  m_button_bar = new QWidget( this );
  m_button_bar->setFixedHeight( 22 );
  m_button_bar->installEventFilter( this );
  layout->addWidget( m_workspace );
  layout->addWidget( m_button_bar );

  QHBoxLayout *button_bar_layout = new QHBoxLayout( m_button_bar );
  m_buttons = new QHButtonGroup( m_button_bar );
  m_buttons->setExclusive( TRUE );
  m_buttons->setInsideMargin( 0 );
  m_buttons->setInsideSpacing( 0 );
  button_bar_layout->addWidget( m_buttons );
  button_bar_layout->addStretch( 1 );
 }

//--------------------------------------------------------------------------//

KSWorkspace::~KSWorkspace()
 {
 }

//--------------------------------------------------------------------------//

KSWorkspaceWindow *KSWorkspace::activeWindow() const
 {
  return dynamic_cast<KSWorkspaceWindow*>(m_workspace->activeWindow());
 }

//--------------------------------------------------------------------------//

KSWindowButton *KSWorkspace::addWindow( KSWorkspaceWindow *w )
 {
  KSWindowButton *new_button = new KSWindowButton( w, m_buttons );
  new_button->show();
  return new_button;
 }

//--------------------------------------------------------------------------//

void KSWorkspace::removeWindow( KSWorkspaceWindow *w )
 {
  if ( w && w->isActive() ) windowDeactivate( w );
  if ( w ) delete w->button();
 }

//--------------------------------------------------------------------------//

void KSWorkspace::windowActivate( KSWorkspaceWindow *w )
 {
  if ( w && !w->isActive() ) {
	w->activated();
	w->setActive( TRUE );
	if ( w->button() ) w->button()->setOn( TRUE );
	m_shell->objectContainer()->setWidget( w->createObjectPanel(m_shell->objectContainer()) );
	m_shell->propertyContainer()->setWidget( w->createPropertyPanel(m_shell->propertyContainer()) );
	}
 }

//--------------------------------------------------------------------------//

void KSWorkspace::windowDeactivate( KSWorkspaceWindow *w )
 {
  if ( w && w->isActive() ) {
	w->deactivated();
	w->setActive( FALSE );
	if ( w->button() ) w->button()->setOn( FALSE );
	m_shell->objectContainer()->setWidget( NULL );
	m_shell->propertyContainer()->setWidget( NULL );
	m_shell->disableCustomActions();
	}
 }

//--------------------------------------------------------------------------//

void KSWorkspace::slot_window_activated( QWidget *w )
 {
  QWidgetList window_list = m_workspace->windowList();
  for ( QWidget *curr_widget = window_list.first(); curr_widget; curr_widget = window_list.next() ) {
	 KSWorkspaceWindow *curr_window = dynamic_cast<KSWorkspaceWindow*>(curr_widget);
	 if ( curr_window && curr_window->isActive() && curr_widget != w ) windowDeactivate( curr_window );
	}
  KSWorkspaceWindow *window = dynamic_cast<KSWorkspaceWindow*>(w);
  if ( window && !window->isActive() ) windowActivate( window );	
 }

//--------------------------------------------------------------------------//

bool KSWorkspace::eventFilter( QObject *o, QEvent *e )
 {
  if ( e->type() == QEvent::ContextMenu && o == m_button_bar ) {
	((QContextMenuEvent *)e)->accept();
	QPopupMenu *windows = new QPopupMenu( this );
	QPopupMenu *new_window = new QPopupMenu( windows );
	windows->insertItem( tr("New window"), new_window );
	m_shell->m_new_page_view_win->addTo( new_window );
	m_shell->m_new_worksheet_win->addTo( new_window );
	m_shell->m_new_edit_data_win->addTo( new_window );
	windows->insertSeparator();
	m_shell->m_restore_windows->addTo( windows );
	m_shell->m_maximize_windows->addTo( windows );
	m_shell->m_minimize_windows->addTo( windows );
	windows->insertSeparator();
	m_shell->m_hide_window->addTo( windows );
	m_shell->m_show_window->addTo( windows );
	windows->insertSeparator();
	m_shell->m_close_window->addTo( windows );
	windows->insertSeparator();
	m_shell->m_tile_windows->addTo( windows );
	m_shell->m_cascade_windows->addTo( windows );
	windows->exec(QCursor::pos()); delete windows;
	return TRUE;
	}
  return FALSE;
 }

//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//



KSWorkspaceWindow::KSWorkspaceWindow( KSWorkspace *workspace, const QString& caption, const QPixmap& icon, WFlags f=0 )
:QWidget( workspace->workspace(), "workspace_window", f | WDestructiveClose )
 {
  m_contents = NULL;
  m_workspace = workspace;
  m_active = false;
  setCaption( caption );
  setIcon( icon );
  m_button = m_workspace->addWindow( this );
 }

//--------------------------------------------------------------------------//

KSWorkspaceWindow::~KSWorkspaceWindow()
 {
  m_workspace->removeWindow( this );
 }

//--------------------------------------------------------------------------//

void KSWorkspaceWindow::setContents( QWidget *contents )
 {
  delete m_contents;
  m_contents = contents;
  if ( m_contents ) {
	m_contents->move( 0, 0 );
	m_contents->resize( size() );
	m_contents->show();
	}
 }

//--------------------------------------------------------------------------//

void KSWorkspaceWindow::setActive( bool enable )
 {
  m_active = enable;
 }

//--------------------------------------------------------------------------//

void KSWorkspaceWindow::resizeEvent( QResizeEvent * )
 {
  if ( m_contents ) {
	m_contents->move( 0, 0 );
	m_contents->resize( size() );
	}
 }

//--------------------------------------------------------------------------//

void KSWorkspaceWindow::focusInEvent( QFocusEvent *event )
 {
  QWidget::focusInEvent( event );
 }

//--------------------------------------------------------------------------//

void KSWorkspaceWindow::focusOutEvent( QFocusEvent *event )
 {
  QWidget::focusOutEvent( event );
 }

//--------------------------------------------------------------------------//

void KSWorkspaceWindow::setTitle( const QString& newTitle )
 {
  setCaption( newTitle );
  if ( button() ) button()->setText( newTitle );
 }

//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//

KSWindowButton::KSWindowButton( KSWorkspaceWindow *window, QWidget *parent )
: QPushButton( parent )
 {
  m_window = window;
  setText( window->caption() );
  QPixmap pixmap = *window->icon();
  pixmap.resize( 10, 10 );
  setIconSet( pixmap );
  setFixedHeight( 22 );
  setMinimumWidth( 5 );
  setFont( QFont("Arial",9) );
  setToggleButton( TRUE );
  connect( this, SIGNAL(pressed()), this, SLOT(slot_button_pressed()) );
 }

//--------------------------------------------------------------------------//

KSWindowButton::~KSWindowButton()
 {
 }

//--------------------------------------------------------------------------//

void KSWindowButton::slot_button_pressed()
 {
  m_window->setFocus();
 }

//--------------------------------------------------------------------------//

void KSWindowButton::contextMenuEvent( QContextMenuEvent *e )
 {
  QPopupMenu *menu = new QPopupMenu( this );
  e->accept();
  int restore_id  = menu->insertItem(tr("Restore"));
  int maximize_id = menu->insertItem(tr("Maximize"));
  int minimize_id = menu->insertItem(tr("Minimize"));
  menu->insertSeparator();
  int hide_id     = menu->insertItem(tr("Hide"));
  int show_id     = menu->insertItem(tr("Show"));
  menu->insertSeparator();
  int close_id    = menu->insertItem(tr("Close"));

  int selected_id = menu->exec(QCursor::pos()); delete menu;

  if ( selected_id == restore_id ) {
	m_window->showNormal();
	}
  else if ( selected_id == maximize_id ) {
	m_window->showMaximized();
	}
  else if ( selected_id == minimize_id ) {
	m_window->showMinimized();
	}
  else if ( selected_id == hide_id ) {
	m_window->hide();
	}
  else if ( selected_id == show_id ) {
	m_window->show();
	}
  else if ( selected_id == close_id ) {
	// ups we are deleting ourselves
	m_window->close();
	}
 }
