/***************************************************************************
                                  kspanelmanager.h
                             -------------------
    begin                : Sat Oct 7 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildobk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSPANELMANAGER_H
#define KSPANELMANAGER_H

#include <qwidget.h>
#include <qframe.h>
#include <qguardedptr.h>
#include <qstringlist.h>
#include <qevent.h>

#include "widgets/qscobject.h"
#include "widgets/qsplotview.h"
#include "widgets/qsaxes.h"

class KSPanel;
class KSPanelButton;
class QSGraphicalData;
class KMatplotShell;
struct kspanelmanager_private_data;

/**
  *@author Kamil Dobkowski
  */
class KSPanelManager : public QFrame  {

        Q_OBJECT

   public:
        /**
          * Constructor
          */
	KSPanelManager( KMatplotShell *shell, QWidget *parent=0, const char *name=0);
	/**
	  * Destructor
	  */
	~KSPanelManager();
	/**
	  * Sets a new view to use with this panel manager.
	  */
	void setView( QSPlotView *view );
	/**
	  * Enables this panel manager to manage panels.
	  */
	void setEnabled( bool enabled );
	/**
	  * Apply properties to plot immediately after the controls change.
	  * Hide apply button
	  */
	void setAutoSetProperties( bool enabled );
	/**
	  * Returns enabled setting
	  */
	bool enabled() const { return is_enabled; }
	/**
	  *
	  */
	bool autoSetProperties() const { return pr_autoset; }
	/**
	  * Returns the current view
	  */
	QSPlotView *view() const;
	/**
	  * Event filter to show a contet menu.
	  */
	virtual bool eventFilter ( QObject *watched, QEvent *e );
  signals:
	/**
	  * Useful hints, help messages, etc.
	  */
	void message( const QString& message );
	/**
	  * Data object is selected ( axis, dataset )
	  */
	void dataObjectSelected( QSData *data );

  public slots:
	/**
	  * Show requested panel.
	  */
	void selectPanel( int category, int element );
	/**
	  * Sets orientation to Horizontal/Vertical
	  */
	void setOrientation( Orientation s );

   protected:
	virtual void resizeEvent ( QResizeEvent *event );
        QSCObject *get_curr_object();
        void category_button_factory( int select_category = -1 );
	void panel_button_factory( int category );
	KSPanelButton *panel_button( int button_id );
        void arrange_button_row( const QString& title, int button_num, QSGraphicalData *dataObject = NULL );
	void add_category_button( int category );
	void adjust_panel_orientation();
        bool is_enabled;
	bool pr_autoset;
	bool pr_reading;
	bool pr_applying;
	struct kspanelmanager_private_data *d;

   private slots:

        void slot_update_panel_list();
        void slot_update_panel_contents();
        void slot_update_graph();
        void slot_category_selected( int category_id );
        void slot_panel_selected( int panel_id );
        void slot_panel_apply_properties();
        void slot_panel_read_properties();
	void slot_set_message( const QString& info );

};

#endif
