/***************************************************************************
                                 ksmatrixmat.h                               
                             -------------------                                         
    begin                : 01-January-2000
    copyright            : (C) 2000 by Kamil Dobkowski                         
    email                : kamildobk@poczta.onet.pl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KSMATRIXMAT_H
#define KSMATRIXMAT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ksmatrixiohandler.h"

//
// USES: #define WORDS_BIGENDIAN
//

/**
  * Loads matrices from Matlab's MAT 1.0 files.
  * @author Kamil Dobkowski
  * @version 0.0.1
  */

class KSMatrixMAT : public KSMatrixIOHandler
     {

       public:

         /**
           * Constructor.
           */
	 KSMatrixMAT();

        /**
          * Destructor.
          */
	~KSMatrixMAT();

        bool check( QDataStream &is );
        KSHeadersList* headers( QDataStream& is );
        KSMatrix* load( QDataStream& is, const QString& matrixname );

        /**
          * Returns "MAT 1.0".
          */
        virtual QString format() { return QString("MAT 1.0"); }

     private:

       enum TypeM {
	        IEEE_LITTLE_ENDIAN = 0,
	        IEEE_BIG_ENDIAN    = 1,
	        VAX_D_FLOAT	   = 2,
	        VAX_G_FLOAT	   = 3,
	        CRAY		   = 4
	       };
	
       enum TypeO {
                 CORRECT = 0
                };	
	
       enum TypeP {
	        E_DOUBLE  = 0,
	        E_FLOAT	  = 1,
	        E_INTEGER = 2,
	        E_SHORT	  = 3,
	        E_USHORT  = 4,
	        E_UCHAR	  = 5 	
	       };
	
       enum TypeT {
	        FULL	 = 0,
	        TEXT	 = 1,
	        SPARSE = 2
	       };


       struct Flags {
                TypeM M;
                TypeO O;
                TypeP P;
                TypeT T;
               };

       struct Header {
	        int  type;    // see Flags	
        	int  mrows;   // rows
	        int  ncols;   // columns
	        int  imagf;   // is imaginary part present
	        int  namlen;  // name length
	       };

       KSMatrix* read_header( QDataStream& is, bool *swap = NULL, int *esize = NULL, int *dsize = NULL );
       void swap_bytes( void *adr, unsigned int len );
    };

#endif








































