%{
#define YYDEBUG 1
#define YYSTYPE	MPParserSymbol
#define YYPARSE_PARAM	formula_object
#define YYLEX_PARAM	formula_object
#define YYERROR_VERBOSE	1
//#define YYPRINT(file, type, value)   debug_print( formula_object, &yylloc, type, value )
#define yyerror(message) yyerr( message, &yylloc, formula_object )
#include "mpformula.h"
#include "mpparsersymbol.h"
#include "mpsymbols.h"
#include <math.h>
#include <stdlib.h>
void yyerr(  const char *message, void *location_info_ptr, void *formula_ptr );
int yylex( YYSTYPE *symbol_value, void *location_info_ptr, void *formula_ptr );
%}

%pure_parser
%token NUMBER
%token END
%token VAR
%token FUNC
%token ID

%left UNARY_MINUS
%left '\''

%%

input:
	top_expr END		{
				((MPFormula *)formula_object)->m_root_sym = $1.takeSym();
				YYACCEPT
				}
;

top_expr:
        expr			{
				$$ = $1;
				}
	| colon_expr		{
				$$ = new MPSymColonExpr( $1.takeSymList(),
						@1.first_column, @1.last_column, "colon expression" );
				}
;

/*
 * Monotone sequence from:to or from:step:to.
 * You can also collect all arguments in MPSymbolList and in expr -> colon_expr
 * transform it into colon expr
 */
colon_expr:
	expr ':' expr		{
				$$ = new MPSymbolList( $1.takeSym(), $3.takeSym() );
				}
	| colon_expr ':' expr	{
				/* only three-element colon expressions are allowed.
				   If it is more than three elements an error will be
				   raised during syntax checking */
				$1.symList()->add( $3.takeSym() );
				$$ = $1;
				}
;


expr:
	 expr '+' basic_expr	{
				$$ = new MPSymFunction2( MPSymFunction2::ADD,
						new MPSymbolList( $1.takeSym(), $3.takeSym() ),
						@2.first_column, @2.last_column, "operator +" );
				}
        | expr '-' basic_expr	{
				$$ = new MPSymFunction2( MPSymFunction2::SUB,
						new MPSymbolList( $1.takeSym(), $3.takeSym() ),
						@2.first_column, @2.last_column, "operator -" );
				}
	| basic_expr		{
				$$ = $1;
				}
;

basic_expr:
	 basic_expr '*' indexed_expr		{
				$$ = new MPSymFunction2( MPSymFunction2::MUL,
						new MPSymbolList( $1.takeSym(), $3.takeSym() ),
						@2.first_column, @2.last_column, "operator *" );
				}
        | basic_expr '/' indexed_expr		{
				$$ = new MPSymFunction2( MPSymFunction2::DIV,
						new MPSymbolList( $1.takeSym(), $3.takeSym() ),
						@2.first_column, @2.last_column, "operator /" );
				}
	| indexed_expr		{
				$$ = $1;
				}
;


/* Each expression can be indexed - only a choosen elements will be taken
   For example: sheet(3:4, 5:6)
 */
indexed_expr:
	indexed_expr '(' arg_list ')'	{
				// Matrix indices for example sheet(2:4,5:7) - highest priority
				if ( $3.symList()->count() == 1 ) {
					// single index for vectors
					$$ = new MPSymVectorIndexer( $1.takeSym(), $3.takeSymList(),
								@2.first_column, @4.last_column, "index operator()" );
					} else {
					// double index for matrices
					$$ = new MPSymMatrixIndexer( $1.takeSym(), $3.takeSymList(),
								@2.first_column, @4.last_column, "index operator()" );
					}

				}
	| simple_expr		{
				$$ = $1;
				}
;

simple_expr:
	NUMBER			{
				/* Floating-point number */
				$$ = new MPSymValue( $1.token().toDouble(),
						@1.first_column, @1.last_column, $1.token().latin1() );
				}
	| ID			{
				/* Identifier which is neither a variable nor function */
				((MPFormula *)formula_object)->m_error->setUndefinedSymbol( $1.token().latin1(),
						@1.first_column, @1.last_column );
				YYABORT
				}
	| VAR			{
				/* Variable, must be used without parenthesis and arguments ( see below ) */
				$$ = $1;				
				}
	| FUNC '(' arg_list ')' {
				/* Function - it must be called as function() or function(args) */
				// TODO: symbol ':' isn't allowed in functions - you should check it
				$1.sym()->setArgs( $3.takeSymList() );
				$$ = $1;
				}
	| '[' matrix ']'	{
				/* Matrix definition  [2, 3; 4, 5] */
				$$ = new MPSymMatrix( $2.takeSymList(), @1.first_column, @3.last_column, "matrix" )
				}
        | '(' top_expr ')'	{		
				$$ = $2;
				}
	| '-' simple_expr %prec UNARY_MINUS	{
				/* Unary minus has lower priority than transposition */
				$$ = new MPSymFunction1( MPSymFunction1::NEG,
							new MPSymbolList( $2.takeSym() ),
							@1.first_column, @1.last_column, "operator unary-" );
				}
	| simple_expr '\''	{
				/* Transposition */
				$$ = new MPSymTranspose( new MPSymbolList( $1.takeSym() ),
							@2.first_column, @2.last_column, "operator ' ( transpose )" );
				}
;

/**
  * Matrix  Example which forms 3x3 matrix: 4 5 6; 1 3 4; 5 6 7
  * Used as a part of expression
  */
matrix:	
	vector			{
				MPSymbol *vector = new MPSymVector( $1.takeSymList(),
							@1.first_column, @1.last_column, "row" );
				$$ = new MPSymbolList( vector );
				}
	| matrix ';' vector	{
				MPSymbol *vector = new MPSymVector( $3.takeSymList(),
							@3.first_column, @3.last_column, "row" );
				$1.symList()->add( vector );
				$$ = $1;
				}
;

/**
  * Vector -  4 5 6  or 4, 5, 6
  * used as a part of a matrix
  */
/*
	| vector simple_expr		{
					$1.symList()->add( $2.takeSym() );
					$$ = $1;
					}
*/
vector:	expr				{
					$$ = new MPSymbolList( $1.takeSym() );
					}
	| vector ',' top_expr		{
					$1.symList()->add( $3.takeSym() );
					$$ = $1;
					}
;

/*
 * List of arguments to function or index for example sheet(:,12) or sin(3.14)
 * allows special symbol ':' used for indexer to mark the whole range
 */
arg_list: /*empty */		{
				$$ = new MPSymbolList();
				}
	| top_expr			{
				$$ = new MPSymbolList( $1.takeSym() );
				}
	| arg_list ',' top_expr	{
				$1.symList()->add( $3.takeSym() );
				$$ = $1;
				}
	| ':'			{
				$$ = new MPSymbolList( new MPSymColon( @1.first_column, @1.last_column, ":" ) );				
				}
	| arg_list ',' ':'	{
				/* 2 x @3.last_column */
				$1.symList()->add( new MPSymColon( @3.last_column, @3.last_column, ":" ) );
				$$ = $1;
				}
;

%%
