/***************************************************************************
                                 kspanels.cpp
                             -------------------
    begin                : Fri Jan 4 2002
    copyright            : (C) 2002 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include"kspanels.h"
#include"ksattrbtn.h"
#include "../widgets/qsaxes3d.h"
#include "../widgets/qsaxes2d.h"
#include "../widgets/qsaxis.h"
#include "../widgets/qsplot.h"
#include "../widgets/qsfigure.h"
#include "../widgets/qssurface.h"
#include "../widgets/qscontour.h"
#include "../widgets/qscurve.h"
#include "../widgets/qsimage.h"
#include "../kscommands.h"
#include "kstextedit.h"

#include <qstringlist.h>
#include <qinputdialog.h>
#include <qvalidator.h>
#include <qtoolbutton.h>
#include <qwhatsthis.h>
#include <qpainter.h>
#include <assert.h>
#include <qtooltip.h>

#include <qpushbutton.h>
#include <qlineedit.h>
#include <qspinbox.h>
#include <qmultilineedit.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qpopupmenu.h>

#include"../pixmaps/panel_position.xpm"
#include"../pixmaps/panel_arrow.xpm"
#include"../pixmaps/panel_x.xpm"
#include"../pixmaps/panel_y.xpm"
#include"../pixmaps/panel_z.xpm"
#include"../pixmaps/panel_v.xpm"
#include"../pixmaps/panel_label.xpm"
#include"../pixmaps/panel_legend.xpm"
#include"../pixmaps/action_contour.xpm"
#include"../pixmaps/panel_pos1.xpm"
#include"../pixmaps/panel_rect.xpm"
#include"../pixmaps/panel_box.xpm"
#include"../pixmaps/action_figure.xpm"
#include"../pixmaps/panel_frame.xpm"
#include"../pixmaps/panel_general.xpm"
#include"../pixmaps/panel_gl.xpm"
#include"../pixmaps/action_pixmap.xpm"
#include"../pixmaps/panel_light.xpm"
#include"../pixmaps/panel_mesh.xpm"
#include"../pixmaps/action_curve.xpm"
#include"../pixmaps/action_surface.xpm"
#include"../pixmaps/panel_gx.xpm"
#include"../pixmaps/panel_gy.xpm"
#include"../pixmaps/panel_gz.xpm"
#include"../pixmaps/panel_gv.xpm"
#include"../pixmaps/panel_view.xpm"
#include"../pixmaps/panel_gradient.xpm"


//-----------------------------------------------------------//

KSPanelButtonRange::KSPanelButtonRange( QWidget *parent, KSWorkbook *workbook, QSAxes *axes )
:KSPanelButton( parent, workbook, BGeneral, QPixmap(panel_position), tr("Fast range and viewpoint setting") )
 {
  m_axes = axes;
 }

//-----------------------------------------------------------//

KSPanelButtonRange::~KSPanelButtonRange()
 {
 }

//-----------------------------------------------------------//

KSPanel *KSPanelButtonRange::createPanel( QWidget *panelParent )
 {
  return new KSPanelRange( panelParent, m_workbook, m_axes );
 }

//-----------------------------------------------------------//

bool KSPanelButtonRange::isButtonFor( QSCObject *, int, int )
 {
  /*
  if ( category == QSAxes::GeneralCategory &&
       object->isAxesShadow() &&
       element == 0 ) return true;
  */
  return false;
 }

//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//

KSPanelRange::KSPanelRange(QWidget *parent, KSWorkbook *workbook, QSAxes *axes, const char *name)
: KSPanelRangeInterf(parent,name)
 {
  m_axes = axes;
  m_workbook = workbook;

  connect( rememberView, SIGNAL(clicked()), this, SLOT(remember_view()) );

  connect( view1, SIGNAL(clicked()), this, SLOT(set_view_1()) );
  connect( view2, SIGNAL(clicked()), this, SLOT(set_view_2()) );
  connect( view3, SIGNAL(clicked()), this, SLOT(set_view_3()) );

  connect( viewUp, SIGNAL(clicked()), this, SLOT(view_up()) );
  connect( viewDown, SIGNAL(clicked()), this, SLOT(view_down()) );
  connect( viewLeft, SIGNAL(clicked()), this, SLOT(view_left()) );
  connect( viewRight, SIGNAL(clicked()), this, SLOT(view_right()) );

  connect( xPlus, SIGNAL(clicked()), this, SLOT(x_plus()) );
  connect( yPlus, SIGNAL(clicked()), this, SLOT(y_plus()) );
  connect( zPlus, SIGNAL(clicked()), this, SLOT(z_plus()) );
  connect( vPlus, SIGNAL(clicked()), this, SLOT(v_plus()) );

  connect( xMinus, SIGNAL(clicked()), this, SLOT(x_minus()) );
  connect( yMinus, SIGNAL(clicked()), this, SLOT(y_minus()) );
  connect( zMinus, SIGNAL(clicked()), this, SLOT(z_minus()) );
  connect( vMinus, SIGNAL(clicked()), this, SLOT(v_minus()) );

  m_axes3 = dynamic_cast<QSAxes3D*>(axes);

  if ( !m_axes3 ) {
	viewLeft->setEnabled( false );
	viewRight->setEnabled( false );
	viewUp->setEnabled( false );
	viewDown->setEnabled( false );
	}
 }

//-----------------------------------------------------------//

KSPanelRange::~KSPanelRange()
 {
 }

//-----------------------------------------------------------//

void KSPanelRange::readProperties()
 {
 }

//-----------------------------------------------------------//

void KSPanelRange::applyProperties()
 {
 }

//-----------------------------------------------------------//

void KSPanelRange::x_plus()
 {
  shift_range( QSAxis::XAxisType, 0.1 );
 }

//-----------------------------------------------------------//

void KSPanelRange::y_plus()
 {
  shift_range( QSAxis::YAxisType, 0.1 );
 }

//-----------------------------------------------------------//

void KSPanelRange::z_plus()
 {
  shift_range( QSAxis::ZAxisType, 0.1 );
 }

//-----------------------------------------------------------//

void KSPanelRange::v_plus()
 {
  shift_range( QSAxis::VAxisType, 0.1 );
 }

//-----------------------------------------------------------//

void KSPanelRange::x_minus()
 {
  shift_range( QSAxis::XAxisType, -0.1 );
 }

//-----------------------------------------------------------//

void KSPanelRange::y_minus()
 {
  shift_range( QSAxis::YAxisType, -0.1 );
 }

//-----------------------------------------------------------//

void KSPanelRange::z_minus()
 {
  shift_range( QSAxis::ZAxisType, -0.1 );
 }

//-----------------------------------------------------------//

void KSPanelRange::v_minus()
 {
  shift_range( QSAxis::VAxisType, -0.1 );
 }

//-----------------------------------------------------------//

void KSPanelRange::view_up()
 {
  if ( m_axes3 ) {
	m_axes3->setElevation( m_axes3->elevation()+5 );
	}
 }

//-----------------------------------------------------------//

void KSPanelRange::view_down()
 {
   if ( m_axes3 ) m_axes3->setElevation( m_axes3->elevation()-5 );
 }

 //-----------------------------------------------------------//

void KSPanelRange::view_left()
 {
  if ( m_axes3 ) m_axes3->setAzimuth( m_axes3->azimuth()-15 );
 }

//-----------------------------------------------------------//

void KSPanelRange::view_right()
 {
  if ( m_axes3 ) m_axes3->setAzimuth( m_axes3->azimuth()+15 );
 }

//-----------------------------------------------------------//

void KSPanelRange::shift_range( int axis_type, double shift )
 {
  KSCmdSetRanges *cmd = new KSCmdSetRanges( m_axes );
  for( int axis_nr=0; axis_nr<m_axes->axisCount(); axis_nr++ ) {
	QSAxis *axis = m_axes->axis(axis_nr);
	if ( axis->type() == axis_type && axis->scrollable() ) {
		double min = axis->worldToData(0.0+shift);
		double max = axis->worldToData(1.0+shift);
		axis->setRange( min, max );
		}
	}
  cmd->commit();
  m_workbook->execute( cmd );
 }

//		axis->setRange( min, max );
//-----------------------------------------------------------//

void KSPanelRange::set_view_1()
 {
  KSCmdSetRanges *cmd = new KSCmdSetRanges( m_axes );
  m_axes->setRememberedView( 0 );
  cmd->commit();
  m_workbook->execute( cmd );
 }

//-----------------------------------------------------------//

void KSPanelRange::set_view_2()
 {
  KSCmdSetRanges *cmd = new KSCmdSetRanges( m_axes );
  m_axes->setRememberedView( 1 );
  cmd->commit();
  m_workbook->execute( cmd );
 }

//-----------------------------------------------------------//

void KSPanelRange::set_view_3()
 {
  KSCmdSetRanges *cmd = new KSCmdSetRanges( m_axes );
  m_axes->setRememberedView( 2 );
  cmd->commit();
  m_workbook->execute( cmd );
 }

//-----------------------------------------------------------//

void KSPanelRange::remember_view()
 {
  bool ok = FALSE;
  int view_number = QInputDialog::getInteger( tr( "Please enter a number " ), "", 1, 1, 3, 1, &ok, this );
  if ( ok ) m_axes->rememberCurrentView( view_number-1 );
 }


//----------------------------------------------------------------------------------------------------------//
//----------------------------------------------------------------------------------------------------------//
//----------------------------------------------------------------------------------------------------------//
//----------------------------------------------------------------------------------------------------------//
//----------------------------------------------------------------------------------------------------------//
//-----------------------------------------------------------//



KSPanelButtonCArrow::KSPanelButtonCArrow( QWidget *parent, KSWorkbook *workbook, QSCObject *o )
:KSPanelButton( parent, workbook, BObject, QPixmap(panel_arrow), tr("Arrow properties") )
 {
  m_object = o;
 }

//-----------------------------------------------------------//

KSPanelButtonCArrow::~KSPanelButtonCArrow()
 {
 }

//-----------------------------------------------------------//

KSPanel *KSPanelButtonCArrow::createPanel( QWidget *panelParent )
 {
  return new KSPanelCArrow( panelParent, m_workbook, m_object );
 }

//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//

KSPanelCArrow::KSPanelCArrow(QWidget *parent, KSWorkbook *workbook, QSCObject *init_o, const char *name)
: KSPanelCArrowInterf(parent,name)
 {
  originArrow->setOrigin( true );
  endArrow->setOrigin( false );
  m_workbook = workbook;
  o = init_o;
  watchProperties();
 }

//-------------------------------------------------------------//

KSPanelCArrow::~KSPanelCArrow()
 {
 }

//-------------------------------------------------------------//

void KSPanelCArrow::readProperties()
 {
  originPoint->setDialogPoint( toQSGPoint(o->property("originPoint").toString()) );
  endPoint->setDialogPoint( toQSGPoint(o->property("endPoint").toString()) );
  originArrow->setDialogArrow( toQSGArrow(o->property("originArrow").toString()) );
  endArrow->setDialogArrow( toQSGArrow(o->property("endArrow").toString()) );
  arrowLine->setDialogLine( toQSGLine(o->property("line").toString()) );
 }

//-------------------------------------------------------------//

void KSPanelCArrow::applyProperties()
 {
  KSCmdSetProperties *cmd = new KSCmdSetProperties(o);
  cmd->setProperty( "originPoint", toQString(originPoint->dialogPoint()) );
  cmd->setProperty( "endPoint", toQString(endPoint->dialogPoint()) );
  cmd->setProperty( "originArrow", toQString(originArrow->dialogArrow()) );
  cmd->setProperty( "endArrow", toQString(endArrow->dialogArrow()) );
  cmd->setProperty( "line", toQString(arrowLine->dialogLine()) );
  m_workbook->execute( cmd );
 }


//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//

KSPanelButtonAxis::KSPanelButtonAxis( QWidget *parent, KSWorkbook *workbook, QSAxis *axis )
:KSPanelButton( parent, workbook, BAxes, QPixmap(), QString::null, axis )
 {
  m_axis = axis;

  QPixmap icon;
  QString tool_tip;
  switch( m_axis->type() ) {
	case QSAxis::XAxisType: icon = QPixmap(panel_x); tool_tip = tr("X axis "); break;
	case QSAxis::YAxisType: icon = QPixmap(panel_y); tool_tip = tr("Y axis ");  break;
	case QSAxis::ZAxisType: icon = QPixmap(panel_z); tool_tip = tr("Z axis ");  break;
	case QSAxis::VAxisType: icon = QPixmap(panel_v); tool_tip = tr("V axis ");  break;
	}
  setPixmap(icon);
  QToolTip::add( this, tool_tip );
  QWhatsThis::add( this, tool_tip );
 }

//-----------------------------------------------------------//

KSPanelButtonAxis::~KSPanelButtonAxis()
 {
 }

//-----------------------------------------------------------//

KSPanel *KSPanelButtonAxis::createPanel( QWidget *panelParent )
 {
  return new KSPanelAxis( panelParent, m_workbook, m_axis );
 }

//-----------------------------------------------------------//

bool KSPanelButtonAxis::isButtonFor( QSCObject *object, int category, int element )
 {
  if ( category == QSAxes::AxisCategory &&
       object->isAxesShadow() &&
       m_axis == object->parentAxes()->axis(element) ) return true;
  return false;
 }

//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//

#define KS_MAX_DOUBLE   1e300

KSPanelAxis::KSPanelAxis(QWidget *parent, KSWorkbook *workbook, QSAxis *axis, const char *name)
: KSPanelAxisInterf(parent,name)
 {
  m_workbook = workbook;
  m_axis = axis;

  ascalel->insertItem(tr("Linear"), 0 );
  ascalel->insertItem(tr("Log"),    1 );

  alene->setValidator( new QDoubleValidator( -1000.0, 1000.0, 3, alene ) );
  amine->setValidator( new QDoubleValidator( -KS_MAX_DOUBLE, KS_MAX_DOUBLE, 16, amine ) );
  amaxe->setValidator( new QDoubleValidator( -KS_MAX_DOUBLE, KS_MAX_DOUBLE, 16, amaxe ) );
  abasee->setValidator( new QDoubleValidator( 0.0, KS_MAX_DOUBLE, 16, abasee ) );
  axisArrow1->setOrigin( true  );
  axisArrow2->setOrigin( false );
  QWhatsThis::add( amine, tr("Minimum value on the axis\n\n"
                          "If both Maximum and Minimum values are set to zero "
                          "the axis range automatically fits to data. ") );
  QWhatsThis::add( amaxe, tr("Maximum value on the axis\n\n"
                          "If both Maximum and Minimum values are set to zero "
                          "the axis range automatically fits to data. ") );
  QWhatsThis::add( alene, tr("Position of the axis\n\n") );
  QWhatsThis::add( ascalel, tr("Axis scale\n\nTwo modes are available LINEAR and LOG. ") );
  QWhatsThis::add( abasee,  tr("Base value\n\nWhen a scale kind is LINEAR "
                            "this value acts as a base step for auto-generated labels. "
                            "If a scale kind is LOG, the value is used as a base of "
                            "logarithm, but always must be > 1.0. ") );
  //QWhatsThis::add( lfont, tr("Title font\n\nFont used to print the axis title.") );
  QWhatsThis::add( labele, tr("Axis title\n\nWrite a title string here. ") );

  watchProperties();
 }

//-----------------------------------------------------------//

KSPanelAxis::~KSPanelAxis()
 {
 }

//-----------------------------------------------------------//

void KSPanelAxis::readProperties()
 {
  QString s;

  amine->setText( s.setNum( m_axis->min(), 'g', 8 ) );
  amaxe->setText( s.setNum( m_axis->max(), 'g', 8 ) );
  alene->setText( s.setNum( m_axis->position(), 'g', 8 ) );
  abasee->setText( s.setNum( m_axis->scaleBase(), 'g', 8 ) );
  ascalel->setCurrentItem( m_axis->scaleType() == QSAxis::LinearScale ? 0 : 1 );
  labele->setText( m_axis->title() );
  labele->setBaseFont( m_axis->font(QSAxis::TitleFont) );
  titleFont->setDialogFont( m_axis->font(QSAxis::TitleFont) );
  axisArrow1->setDialogArrow( m_axis->arrow1() );
  axisArrow2->setDialogArrow( m_axis->arrow2() );
  axisLine->setDialogLine( m_axis->line(QSAxis::AxisLine) );
  areversed->setChecked( m_axis->reversed() );
  visible->setChecked( m_axis->visible() );
  scrollable->setChecked( m_axis->scrollable() );
  opposite->setChecked( m_axis->oppositePosition() );
  //defaultPosition->setChecked( m_axis->defaultPosition() );
  titlePosPara->setText( QString::number( m_axis->titlePosition(), 'g', 3 ) );
  titlePosPerp->setText( QString::number( m_axis->titleDistance(), 'g', 3 ) );
 }

//-----------------------------------------------------------//

void KSPanelAxis::applyProperties()
 {
  KSCmdSetGraphicalProperties *cmd = new KSCmdSetGraphicalProperties( m_axis );
  cmd->setProperty( "min", amine->text().toDouble() );
  cmd->setProperty( "max", amaxe->text().toDouble() );
  cmd->setProperty( "position", alene->text().toDouble() );
  cmd->setProperty( "scaleType", ascalel->currentItem()==1 ? QSAxis::LogScale : QSAxis::LinearScale );
  cmd->setProperty( "scaleBase", abasee->text().toDouble() );
  cmd->setProperty( "title", labele->text() );
  cmd->setFont( QSAxis::TitleFont, titleFont->dialogFont() );
  cmd->setProperty( "reversed", areversed->isChecked() );
  cmd->setProperty( "arrow1", toQString(axisArrow1->dialogArrow()) );
  cmd->setProperty( "arrow2", toQString(axisArrow2->dialogArrow()) );
  cmd->setLine( QSAxis::AxisLine, axisLine->dialogLine() );
  cmd->setProperty( "visible", visible->isChecked() );
  cmd->setProperty( "scrollable", scrollable->isChecked() );
  cmd->setProperty( "oppositePosition", opposite->isChecked() );
  //cmd->setProperty( "defaultPosition", defaultPosition->isChecked() );
  cmd->setProperty( "titlePosition", titlePosPara->text().toDouble() );
  cmd->setProperty( "titleDistance", titlePosPerp->text().toDouble() );
  m_workbook->execute( cmd );
  labele->setBaseFont( titleFont->dialogFont() );
 }


//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//


//-----------------------------------------------------------//

KSPanelButtonCLabel::KSPanelButtonCLabel( QWidget *parent, KSWorkbook *workbook, QSCObject *o )
:KSPanelButton( parent, workbook, BObject, QPixmap(panel_label), tr("Label") )
 {
  m_object = o;
 }

//-----------------------------------------------------------//

KSPanelButtonCLabel::~KSPanelButtonCLabel()
 {
 }

//-----------------------------------------------------------//

KSPanel *KSPanelButtonCLabel::createPanel( QWidget *panelParent )
 {
  return new KSPanelCLabel( panelParent, m_workbook, m_object );
 }


//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//


KSPanelCLabel::KSPanelCLabel(QWidget *parent, KSWorkbook *workbook, QSCObject *init_o, const char *name)
: KSPanelCLabelInterf(parent,name)
 {
  m_workbook = workbook;
  o = init_o;
  watchProperties();
 }

//-------------------------------------------------------------//

KSPanelCLabel::~KSPanelCLabel()
 {
 }

//-------------------------------------------------------------//

void KSPanelCLabel::readProperties()
 {
  labelFrame->setDialogLine( toQSGLine(o->property("frame").toString()) );
  labelFont->setDialogFont( toQSGFont(o->property("font").toString()) );
  labelFill->setDialogFill( toQSGFill(o->property("fill").toString()) );
  shadowFill->setDialogFill( toQSGFill(o->property("shadowFill").toString()) );
  shadowdx->setValue( o->property("shadowPosX").toInt() );
  shadowdy->setValue( o->property("shadowPosY").toInt() );
  setPosAlign( o->property("textAlign").toInt() );
 }

//-------------------------------------------------------------//

void KSPanelCLabel::applyProperties()
 {
   KSCmdSetProperties *cmd = new KSCmdSetProperties(o);
   cmd->setProperty( "frame", toQString(labelFrame->dialogLine()) );
   cmd->setProperty( "font", toQString(labelFont->dialogFont()) );
   cmd->setProperty( "fill", toQString(labelFill->dialogFill()) );
   cmd->setProperty( "shadowFill", toQString(shadowFill->dialogFill()) );
   cmd->setProperty( "textAlign", posAlign() );
   cmd->setProperty( "shadowPosX", shadowdx->value() );
   cmd->setProperty( "shadowPosY", shadowdy->value() );
   m_workbook->execute( cmd );
 }

//-------------------------------------------------------------//

void KSPanelCLabel::setPosAlign( int a )
 {
  if ( a & AlignTop ) {
         if ( a & AlignLeft    ) _tl->setChecked( true );
         if ( a & AlignHCenter ) _tc->setChecked( true );
         if ( a & AlignRight   ) _tr->setChecked( true );
        }
  else
  if ( a & AlignVCenter ) {
         if ( a & AlignLeft    ) _cl->setChecked( true );
         if ( a & AlignHCenter ) _cc->setChecked( true );
         if ( a & AlignRight   ) _cr->setChecked( true );
  }
  else
  if ( a & AlignBottom ) {
         if ( a & AlignLeft    ) _bl->setChecked( true );
         if ( a & AlignHCenter ) _bc->setChecked( true );
         if ( a & AlignRight   ) _br->setChecked( true );
  }
 }

//-------------------------------------------------------------//

int KSPanelCLabel::posAlign()
 {
  int result = 0;

  if ( _tl->isChecked() ) result =  AlignTop | AlignLeft ;
  if ( _tc->isChecked() ) result =  AlignTop | AlignHCenter ;
  if ( _tr->isChecked() ) result =  AlignTop | AlignRight ;

  if ( _cl->isChecked() ) result =  AlignVCenter | AlignLeft ;
  if ( _cc->isChecked() ) result =  AlignVCenter | AlignHCenter ;
  if ( _cr->isChecked() ) result =  AlignVCenter | AlignRight ;

  if ( _bl->isChecked() ) result =  AlignBottom | AlignLeft ;
  if ( _bc->isChecked() ) result =  AlignBottom | AlignHCenter ;
  if ( _br->isChecked() ) result =  AlignBottom | AlignRight ;

  return result;
 }

//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//

KSPanelButtonCLegend::KSPanelButtonCLegend( QWidget *parent, KSWorkbook *workbook, QSCObject *o )
:KSPanelButton( parent, workbook, BObject, QPixmap(panel_legend), tr("Legend") )
 {
  m_object = o;
 }

//-----------------------------------------------------------//

KSPanelButtonCLegend::~KSPanelButtonCLegend()
 {
 }

//-----------------------------------------------------------//

KSPanel *KSPanelButtonCLegend::createPanel( QWidget *panelParent )
 {
  return new KSPanelCLegendC( panelParent, m_workbook, m_object );
 }

//------------------------------------------------------------------//

KSPanelCLegendC::KSPanelCLegendC(QWidget *parent, KSWorkbook *workbook, QSCObject* init_o, const char *name)
: KSPanelCLegendCInterf(parent,name)
 {
  o = init_o;
  m_workbook = workbook;
  watchProperties();
 }

//------------------------------------------------------------------//

KSPanelCLegendC::~KSPanelCLegendC()
 {
 }

//------------------------------------------------------------------//

void KSPanelCLegendC::readProperties()
 {
  columns->setValue( o->property("columns").toInt() );
 }

//------------------------------------------------------------------//

void KSPanelCLegendC::applyProperties()
 {
  KSCmdSetProperties *cmd = new KSCmdSetProperties(o);
  cmd->setProperty("columns",columns->value());
  m_workbook->execute( cmd );
 }

//------------------------------------------------------------------//
//------------------------------------------------------------------//
//------------------------------------------------------------------//
//------------------------------------------------------------------//
//------------------------------------------------------------------//
//------------------------------------------------------------------//



//-----------------------------------------------------------//

KSPanelButtonContour::KSPanelButtonContour( QWidget *parent, KSWorkbook *workbook, QSContour *contour )
:KSPanelButton( parent, workbook, BDatasets, QPixmap(action_contour), tr("Contour: "), contour )
 {
  m_contour = contour;
 }

//-----------------------------------------------------------//

KSPanelButtonContour::~KSPanelButtonContour()
 {
 }

//-----------------------------------------------------------//

KSPanel *KSPanelButtonContour::createPanel( QWidget *panelParent )
 {
  return new KSPanelContour( panelParent, m_workbook, m_contour );
 }

//-----------------------------------------------------------//

bool KSPanelButtonContour::isButtonFor( QSCObject *object, int category, int element )
 {
  if ( category == QSAxes::DatasetCategory &&
       object->isAxesShadow() &&
       object->parentAxes()->plot(element) == m_contour ) return true;
  return false;
 }

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//

KSPanelContour::KSPanelContour(QWidget *parent, KSWorkbook *workbook, QSContour *init_contour, const char *name)
: KSPanelContourInterf(parent,name)
 {
  contour = init_contour;
  m_workbook = workbook;
  m_x_select = new KSAxisSelect( xaxisc, contour->parentAxes(), QSAxis::XAxisType );
  m_y_select = new KSAxisSelect( yaxisc, contour->parentAxes(), QSAxis::YAxisType );
  m_v_select = new KSAxisSelect( vaxisc, contour->parentAxes(), QSAxis::VAxisType );
  QWhatsThis::add( titlee, tr("Series title\n\nIt is displayed on the legend.") );
  watchProperties();
 }

//-------------------------------------------------------------//

KSPanelContour::~KSPanelContour()
{
}

//-------------------------------------------------------------//

void KSPanelContour::readProperties()
{
 m_x_select->readProperties( contour->defaultAxis(QSAxis::XAxisType) );
 m_y_select->readProperties( contour->defaultAxis(QSAxis::YAxisType) );
 m_v_select->readProperties( contour->defaultAxis(QSAxis::VAxisType) );
 fillsc->setChecked( contour->contourFills() );
 linesc->setChecked( contour->contourLines() );
 labelsc->setChecked( contour->contourLabels() );
 legendc->setChecked( contour->legendItemVisible() );
 labelSpacing->setText( QString::number(contour->labelSpacing()) );
 gridPoint->setDialogPoint( contour->point(QSContour::PointMark) );
 gridLine->setDialogLine( contour->line(QSContour::Grid) );
 titlee->setText( contour->title() );
}

//-------------------------------------------------------------//

void KSPanelContour::applyProperties()
{
 KSCmdSetGraphicalProperties *cmd = new KSCmdSetGraphicalProperties(contour);

 cmd->setProperty( "title", titlee->text() );
 cmd->setProperty( "contourFills", fillsc->isChecked() );
 cmd->setProperty( "contourLines", linesc->isChecked() );
 cmd->setProperty( "contourLabels", labelsc->isChecked() );
 cmd->setProperty( "legendItemVisible", legendc->isChecked() );
 cmd->setProperty( "labelSpacing", labelSpacing->text().toDouble() );
 cmd->setLine( QSContour::Grid, gridLine->dialogLine() );
 cmd->setPoint( QSContour::PointMark, gridPoint->dialogPoint() );

 cmd->setProperty( "defaultXAxis", contour->parentAxes()->axisIndex(m_x_select->selectedAxis()) );
 cmd->setProperty( "defaultYAxis", contour->parentAxes()->axisIndex(m_y_select->selectedAxis()) );
 cmd->setProperty( "defaultVAxis", contour->parentAxes()->axisIndex(m_v_select->selectedAxis()) );

 m_workbook->execute( cmd );
}

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-----------------------------------------------------------//

KSPanelButtonCPos::KSPanelButtonCPos( QWidget *parent,
					KSWorkbook *workbook, QSCObject *o,
					const QCString& posX, const QCString& posY, const QCString& posZ,
					const QCString& coordX, const QCString& coordY, const QCString& coordZ )
:KSPanelButton( parent, workbook, BObject, QPixmap(panel_pos1), tr("Position") )
 {
  m_object = o;
  m_pos_x = posX;
  m_pos_y = posY;
  m_pos_z = posZ;
  m_coord_x = coordX;
  m_coord_y = coordY;
  m_coord_z = coordZ;
 }

//-----------------------------------------------------------//

KSPanelButtonCPos::~KSPanelButtonCPos()
 {
 }

//-----------------------------------------------------------//

KSPanel *KSPanelButtonCPos::createPanel( QWidget *panelParent )
 {
  return new KSPanelCPos( panelParent, m_workbook, m_object, m_pos_x, m_pos_y, m_pos_z, m_coord_x, m_coord_y, m_coord_z );
 }

//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//

KSPanelCPos::KSPanelCPos(QWidget *parent, KSWorkbook *workbook, QSCObject *init_o,
			const QCString& posX, const QCString& posY, const QCString& posZ,
			const QCString& coordX, const QCString& coordY, const QCString& coordZ,
			const char *name )
: KSPanelCPosInterf(parent,name)
 {;
  o = init_o;
  m_workbook = workbook;
  m_pos_x = posX;
  m_pos_y = posY;
  m_pos_z = posZ;
  m_coord_x = coordX;
  m_coord_y = coordY;
  m_coord_z = coordZ;

  m_x_select = new KSAxisSelect( xAxis, o->parentAxes(), QSAxis::XAxisType );
  m_y_select = new KSAxisSelect( yAxis, o->parentAxes(), QSAxis::YAxisType );
  m_z_select = new KSAxisSelect( zAxis, o->parentAxes(), QSAxis::ZAxisType );

  watchProperties();
 }

//-------------------------------------------------------------//

KSPanelCPos::~KSPanelCPos()
 {
 }


//-------------------------------------------------------------//

void KSPanelCPos::readProperties()
 {
  m_x_select->readProperties( o->defaultAxis(QSAxis::XAxisType) );
  m_y_select->readProperties( o->defaultAxis(QSAxis::YAxisType) );
  m_z_select->readProperties( o->defaultAxis(QSAxis::ZAxisType) );

  xaxisc->setCurrentItem( o->property(m_coord_x).toInt() );
  yaxisc->setCurrentItem( o->property(m_coord_y).toInt() );
  zaxisc->setCurrentItem( o->property(m_coord_z).toInt() );

  xpos->setText( QString::number(o->property(m_pos_x).toDouble(),'g',9) );
  ypos->setText( QString::number(o->property(m_pos_y).toDouble(),'g',9) );
  zpos->setText( QString::number(o->property(m_pos_z).toDouble(),'g',9) );
 }

//-------------------------------------------------------------//

void KSPanelCPos::applyProperties()
 {
  KSCmdSetProperties *cmd = new KSCmdSetProperties(o);

  if ( o->parentAxes() ) {
  	cmd->setProperty( "defaultXAxis", o->parentAxes()->axisIndex(m_x_select->selectedAxis()) );
  	cmd->setProperty( "defaultYAxis", o->parentAxes()->axisIndex(m_y_select->selectedAxis()) );
  	cmd->setProperty( "defaultZAxis", o->parentAxes()->axisIndex(m_z_select->selectedAxis()) );
	}

  int old_xCoord = o->property(m_coord_x).toInt();
  int old_yCoord = o->property(m_coord_y).toInt();
  int old_zCoord = o->property(m_coord_z).toInt();

  int new_xCoord = xaxisc->currentItem();
  int new_yCoord = yaxisc->currentItem();
  int new_zCoord = zaxisc->currentItem();

  if ( old_xCoord != new_xCoord ||
       old_yCoord != new_yCoord ||
       old_zCoord != new_zCoord  ) {
	double dpi = o->parentAxes() ? o->parentAxes()->run_dpi() : 72.0;
        QSPt3f p(xpos->text().toDouble(),
                 ypos->text().toDouble(),
                 zpos->text().toDouble());
	QSPt3f cp = o->mixedToCanvas( p, old_xCoord, old_yCoord, old_zCoord, dpi );
        cmd->setProperty( m_coord_x, new_xCoord );
        cmd->setProperty( m_coord_y, new_yCoord );
        cmd->setProperty( m_coord_z, new_zCoord );
	p = o->canvasToMixed( cp, new_xCoord, new_yCoord, new_zCoord, dpi );
        xpos->setText( QString::number(p.x,'g',9) );
        ypos->setText( QString::number(p.y,'g',9) );
        zpos->setText( QString::number(p.z,'g',9) );
       }

  cmd->setProperty( m_pos_x, xpos->text().toDouble() );
  cmd->setProperty( m_pos_y, ypos->text().toDouble() );
  cmd->setProperty( m_pos_z, zpos->text().toDouble() );

  m_workbook->execute( cmd );
 }

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//


//-----------------------------------------------------------//

KSPanelButtonCRect::KSPanelButtonCRect( QWidget *parent, KSWorkbook *workbook, QSCObject *o )
:KSPanelButton( parent, workbook, BObject, QPixmap(panel_rect), tr("Rectangle/Ellipse") )
 {
  m_object = o;
 }

//-----------------------------------------------------------//

KSPanelButtonCRect::~KSPanelButtonCRect()
 {
 }

//-----------------------------------------------------------//

KSPanel *KSPanelButtonCRect::createPanel( QWidget *panelParent )
 {
  return new KSPanelCRect( panelParent, m_workbook, m_object );
 }

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//

KSPanelCRect::KSPanelCRect( QWidget *parent, KSWorkbook *workbook, QSCObject *init_o, const char *name )
: KSPanelCRectInterf(parent,name)
 {;
  o = init_o;
  m_workbook = workbook;
  watchProperties();
}

//-------------------------------------------------------------//

KSPanelCRect::~KSPanelCRect()
 {
 }

//-------------------------------------------------------------//

void KSPanelCRect::readProperties()
 {
  ellipse->setChecked( o->property("ellipse").toBool() );
  rectFrame->setDialogLine( toQSGLine(o->property("frame").toString()) );
  rectFill->setDialogFill( toQSGFill(o->property("fill").toString()) );
  shadowFill->setDialogFill( toQSGFill(o->property("shadowFill").toString()) );
  shadowdx->setValue( o->property("shadowPosX").toInt() );
  shadowdy->setValue( o->property("shadowPosY").toInt() );
 }

//-------------------------------------------------------------//

void KSPanelCRect::applyProperties()
 {
  KSCmdSetProperties *cmd = new KSCmdSetProperties(o);
  cmd->setProperty( "ellipse", ellipse->isChecked() );
  cmd->setProperty( "frame", toQString(rectFrame->dialogLine()) );
  cmd->setProperty( "fill", toQString(rectFill->dialogFill()) );
  cmd->setProperty( "shadowFill", toQString(shadowFill->dialogFill()) );
  cmd->setProperty( "shadowPosX", shadowdx->value() );
  cmd->setProperty( "shadowPosY", shadowdy->value() );
  m_workbook->execute( cmd );
 }

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//


 //-----------------------------------------------------------//

KSPanelButtonCube::KSPanelButtonCube( QWidget *parent, KSWorkbook *workbook, QSAxes3D *axes )
:KSPanelButton( parent, workbook, BGeneral, QPixmap(panel_box), tr("Cube") )
 {
  m_axes = axes;
 }

//-----------------------------------------------------------//

KSPanelButtonCube::~KSPanelButtonCube()
 {
 }

//-----------------------------------------------------------//

KSPanel *KSPanelButtonCube::createPanel( QWidget *panelParent )
 {
  return new KSPanelCube( panelParent, m_workbook, m_axes );
 }

//-----------------------------------------------------------//

bool KSPanelButtonCube::isButtonFor( QSCObject *object, int category, int element )
 {
  if ( category == QSAxes::GeneralCategory &&
       object->isAxesShadow() &&
       element == 0 ) return true;
  return false;
 }
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//

KSPanelCube::KSPanelCube(QWidget *parent, KSWorkbook *workbook, QSAxes3D *plot, const char *name)
 : KSPanelCubeInterf(parent,name)
 {
  assert( plot ); p3 = plot;
  m_workbook = workbook;

  xyThick->setValidator( new QDoubleValidator( 0.0, 1.0, 16, xyThick ) );
  xzThick->setValidator( new QDoubleValidator( 0.0, 1.0, 16, xzThick ) );
  yzThick->setValidator( new QDoubleValidator( 0.0, 1.0, 16, yzThick ) );

  watchProperties();
 }

//-------------------------------------------------------------//

KSPanelCube::~KSPanelCube()
 {
 }

//-------------------------------------------------------------//

void KSPanelCube::readProperties()
 {
  QString s;

  xyThick->setText( s.setNum( p3->xyWallThickness(), 'g', 16 ) );
  xzThick->setText( s.setNum( p3->xzWallThickness(), 'g', 16 ) );
  yzThick->setText( s.setNum( p3->yzWallThickness(), 'g', 16 ) );

  xEdge->setText( s.setNum( p3->xEdgeLength(), 'g', 16 ) );
  yEdge->setText( s.setNum( p3->yEdgeLength(), 'g', 16 ) );
  zEdge->setText( s.setNum( p3->zEdgeLength(), 'g', 16 ) );

  xyFill->setDialogFill( p3->fill( QSAxes3D::XYWallFill ) );
  xzFill->setDialogFill( p3->fill( QSAxes3D::XZWallFill ) );
  yzFill->setDialogFill( p3->fill( QSAxes3D::YZWallFill ) );

  xyLine->setDialogLine( p3->line( QSAxes3D::XYWallLine ) );
  xzLine->setDialogLine( p3->line( QSAxes3D::XZWallLine ) );
  yzLine->setDialogLine( p3->line( QSAxes3D::YZWallLine ) );

 }

//-------------------------------------------------------------//

void KSPanelCube::applyProperties()
 {
  KSCmdSetGraphicalProperties *cmd = new KSCmdSetGraphicalProperties(p3);
  cmd->setProperty( "xyWallThickness", xyThick->text().toDouble() );
  cmd->setProperty( "xzWallThickness", xzThick->text().toDouble() );
  cmd->setProperty( "yzWallThickness", yzThick->text().toDouble() );

  cmd->setProperty( "xEdgeLength", xEdge->text().toDouble() );
  cmd->setProperty( "yEdgeLength", yEdge->text().toDouble() );
  cmd->setProperty( "zEdgeLength", zEdge->text().toDouble() );

  cmd->setFill( QSAxes3D::XYWallFill, xyFill->dialogFill() );
  cmd->setFill( QSAxes3D::XZWallFill, xzFill->dialogFill() );
  cmd->setFill( QSAxes3D::YZWallFill, yzFill->dialogFill() );

  cmd->setLine( QSAxes3D::XYWallLine, xyLine->dialogLine() );
  cmd->setLine( QSAxes3D::XZWallLine, xzLine->dialogLine() );
  cmd->setLine( QSAxes3D::YZWallLine, yzLine->dialogLine() );

  m_workbook->execute( cmd );
 }

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//


 ///-----------------------------------------------------------//

KSPanelButtonFigure::KSPanelButtonFigure( QWidget *parent, KSWorkbook *workbook, QSFigure *figure )
:KSPanelButton( parent, workbook, BDatasets, QPixmap(action_figure), tr("Figure"), figure )
 {
  m_figure = figure;
 }

//-----------------------------------------------------------//

KSPanelButtonFigure::~KSPanelButtonFigure()
 {
 }

//-----------------------------------------------------------//

KSPanel *KSPanelButtonFigure::createPanel( QWidget *panelParent )
 {
  return new KSPanelFigure( panelParent, m_workbook, m_figure );
 }

//-----------------------------------------------------------//

bool KSPanelButtonFigure::isButtonFor( QSCObject *object, int category, int element )
 {
  if ( category == QSAxes::DatasetCategory &&
       object->isAxesShadow() &&
       object->parentAxes()->plot(element) == m_figure ) return true;
  return false;
 }

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//

KSPanelFigure::KSPanelFigure(QWidget *parent, KSWorkbook *workbook, QSFigure *init_figure, const char *name)
: KSPanelFigureInterf(parent,name)
 {
  figure = init_figure;
  m_workbook = workbook;
  m_x_select = new KSAxisSelect( xaxisc, figure->parentAxes(), QSAxis::XAxisType );
  m_y_select = new KSAxisSelect( yaxisc, figure->parentAxes(), QSAxis::YAxisType );
  m_z_select = new KSAxisSelect( zaxisc, figure->parentAxes(), QSAxis::ZAxisType );
  m_v_select = new KSAxisSelect( vaxisc, figure->parentAxes(), QSAxis::VAxisType );
  QWhatsThis::add( accuracys, tr("VCR - Vertex comparing accuracy\n\nThis value is used"
	                     " in shading calculations by drivers which use"
	                     " normals to vertices, such as OpenGL. A normal"
	                     " to a vertex is calculated as an average of all normals"
	                     " to polygons, which share this vertex. To find if two"
	                     " polygons share a vertex all vertices in those polygons"
	                     " are compared. To eliminate round-off errors, before comparing,"
	                     " all vertices in the plot are mapped to <0,1> box and next all"
	                     " coordinates are rounded to VCR places after the point.") );


 watchProperties();
}

//-------------------------------------------------------------//

KSPanelFigure::~KSPanelFigure()
 {
 }

//-------------------------------------------------------------//

void KSPanelFigure::readProperties()
 {
  m_x_select->readProperties( figure->defaultAxis(QSAxis::XAxisType)  );
  m_y_select->readProperties( figure->defaultAxis(QSAxis::YAxisType)  );
  m_z_select->readProperties( figure->defaultAxis(QSAxis::ZAxisType)  );
  m_v_select->readProperties( figure->defaultAxis(QSAxis::VAxisType)  );
  legendc->setChecked( figure->legendItemVisible() );
  accuracys->setValue( figure->vertexCompareAccuracy() );
  titlee->setText( figure->title() );
 }

//-------------------------------------------------------------//

void KSPanelFigure::applyProperties()
 {
  KSCmdSetGraphicalProperties *cmd = new KSCmdSetGraphicalProperties(figure);

  cmd->setProperty( "legendItemVisible", legendc->isChecked() );
  cmd->setProperty( "vertexCompareAccuracy", accuracys->value() );
  cmd->setProperty( "title", titlee->text() );
  cmd->setProperty( "defaultXAxis", figure->parentAxes()->axisIndex(m_x_select->selectedAxis()) );
  cmd->setProperty( "defaultYAxis", figure->parentAxes()->axisIndex(m_y_select->selectedAxis()) );
  cmd->setProperty( "defaultZAxis", figure->parentAxes()->axisIndex(m_z_select->selectedAxis()) );
  cmd->setProperty( "defaultVAxis", figure->parentAxes()->axisIndex(m_v_select->selectedAxis()) );

  m_workbook->execute( cmd );
 }

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//


//-----------------------------------------------------------//

KSPanelButtonFrame::KSPanelButtonFrame( QWidget *parent, KSWorkbook *workbook, QSAxes2D *axes )
:KSPanelButton( parent, workbook, BGeneral, QPixmap(panel_frame), tr("Frame") )
 {
  m_axes = axes;
 }

//-----------------------------------------------------------//

KSPanelButtonFrame::~KSPanelButtonFrame()
 {
 }

//-----------------------------------------------------------//

KSPanel *KSPanelButtonFrame::createPanel( QWidget *panelParent )
 {
  return new KSPanelFrame( panelParent, m_workbook, m_axes );
 }

//-----------------------------------------------------------//

bool KSPanelButtonFrame::isButtonFor( QSCObject *object, int category, int element )
 {
  if ( category == QSAxes::GeneralCategory &&
       object->isAxesShadow() &&
       element == 0 ) return true;
  return false;
 }

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//

KSPanelFrame::KSPanelFrame(QWidget *parent, KSWorkbook *workbook, QSAxes2D *plot, const char *name)
: KSPanelFrameInterf(parent,name)
 {
  assert( plot ); p2 = plot;
  m_workbook = workbook;


  QWhatsThis::add( fillStyle,   tr("Plot area fill\n\nFill style of the inside-frame area") );
  QWhatsThis::add( frameStyle,   tr("Frame fill\n\nFill style of the plot frame") );
  QWhatsThis::add( thicks, tr("Frame thickness\n\nThickness of the plot frame.")  );

  watchProperties();
 }

//-------------------------------------------------------------//

KSPanelFrame::~KSPanelFrame()
 {
 }

//-------------------------------------------------------------//

void KSPanelFrame::readProperties()
 {
  thicks->setValue( p2->frameWidth() );
  fillStyle->setDialogFill( p2->fill( QSAxes2D::RectFill)  );
  frameStyle->setDialogFill( p2->fill( QSAxes2D::FrameFill) );
 }

//-------------------------------------------------------------//

void KSPanelFrame::applyProperties()
 {
  KSCmdSetGraphicalProperties *cmd = new KSCmdSetGraphicalProperties(p2);
  cmd->setProperty( "frameWidth", thicks->value() );
  cmd->setFill( QSAxes2D::RectFill,  fillStyle->dialogFill() );
  cmd->setFill( QSAxes2D::FrameFill, frameStyle->dialogFill() );
  m_workbook->execute( cmd );
 }

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-----------------------------------------------------------//

KSPanelButtonGeneral::KSPanelButtonGeneral( QWidget *parent, KSWorkbook *workbook, QSAxes *axes )
:KSPanelButton( parent, workbook, BGeneral, QPixmap(panel_general), tr("Position/Title") )
 {
  m_axes = axes;
 }

//-----------------------------------------------------------//

KSPanelButtonGeneral::~KSPanelButtonGeneral()
 {
 }

//-----------------------------------------------------------//

KSPanel *KSPanelButtonGeneral::createPanel( QWidget *panelParent )
 {
  return new KSPanelGeneral( panelParent, m_workbook, m_axes );
 }

//-----------------------------------------------------------//

bool KSPanelButtonGeneral::isButtonFor( QSCObject *, int, int )
 {
//  if ( category == QSAxes::GeneralCategory &&
//       object->isAxesShadow() &&
//       element == 0 ) return true;
  return false;
 }

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//

KSPanelGeneral::KSPanelGeneral(QWidget *parent, KSWorkbook *workbook, QSAxes *plot, const char *name)
: KSPanelGeneralInterf(parent,name)
 {
  assert( plot ); p = plot;
  m_workbook = workbook;
  //font = new KSFontBtn( fontw->parentWidget() ); font->setGeometry( fontw->geometry() );
  QWhatsThis::add( titlee, tr("Plot title\n\nYou can write a title text here.") );
  //QWhatsThis::add( font, tr("Title font\n\nFont used to draw a title."));
  //QWhatsThis::add( tposc, tr("Title position\n\nPostion of the plot title on the canvas.") );
  QWhatsThis::add( backgroundFill, tr("Background fill\n\n Background fill style.") );
  watchProperties();
 }

//-------------------------------------------------------------//

KSPanelGeneral::~KSPanelGeneral()
 {
 }

//-------------------------------------------------------------//

void KSPanelGeneral::readProperties()
 {
  backgroundFill->setDialogFill( p->background() );
  titlee->setText( p->title() );
  xpose->setText( QString::number(p->posMM().x) );
  ypose->setText( QString::number(p->posMM().y) );
  widthe->setText( QString::number(p->sizeMM().x) );
  heighte->setText( QString::number(p->sizeMM().y) );
  draw_in_background->setChecked( p->drawInBackground() );
 }

//-------------------------------------------------------------//

void KSPanelGeneral::applyProperties()
 {
  KSCmdSetGraphicalProperties *cmd = new KSCmdSetGraphicalProperties(p);
  cmd->setProperty( "background", toQString(backgroundFill->dialogFill()) );
  cmd->setProperty( "title", titlee->text() );
  cmd->setProperty( "xPosMM", xpose->text().toDouble() );
  cmd->setProperty( "yPosMM", ypose->text().toDouble() );
  cmd->setProperty( "widthMM", widthe->text().toDouble() );
  cmd->setProperty( "heightMM", heighte->text().toDouble() );
  cmd->setProperty( "drawInBackground", draw_in_background->isChecked() );
  m_workbook->execute( cmd );

 }

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-----------------------------------------------------------//

KSPanelButtonGL::KSPanelButtonGL( QWidget *parent, KSWorkbook *workbook, QSAxes3D *axes )
:KSPanelButton( parent, workbook, BGeneral, QPixmap(panel_gl), tr("OpenGL") )
 {
  m_axes = axes;
 }

//-----------------------------------------------------------//

KSPanelButtonGL::~KSPanelButtonGL()
 {
 }

//-----------------------------------------------------------//

KSPanel *KSPanelButtonGL::createPanel( QWidget *panelParent )
 {
  return new KSPanelGL( panelParent, m_workbook, m_axes );
 }

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//

KSPanelGL::KSPanelGL(QWidget *parent, KSWorkbook *workbook, QSAxes3D *plot, const char *name)
: KSPanelGLInterf(parent,name)
 {
  p3 = plot;
  m_workbook = workbook;

  QWhatsThis::add( openglc, tr("OpenGL\n\nIf checked, an OpenGL will be used to draw the plot"
                            " instead of a standard Qt driver. OpenGL supports "
                            " smooth shading, transparency and color interpolation") );
  QWhatsThis::add( alphac,  tr("Alpha\n\nTurns on a transparency support in OpenGL") );
  QWhatsThis::add( globaltr, tr("Global transparency\n\nThis transparency value will be added to each color.") );
  QWhatsThis::add( shadewallsc, tr("Shading\n\nTurns on/off shading of the axis box. ") );
  QWhatsThis::add( shadewallsc, tr("Auto color\n\n") );
  QWhatsThis::add( shadewallsc, tr("Lightness\n\n") );

#ifndef HAVE_GL
  openglc->setEnabled( false );
  shadewallsc->setEnabled( false );
  alphac->setEnabled( false );
  autostrokec->setEnabled( false );
  globaltr->setEnabled( false );
  strokel->setEnabled( false );
  setEnabled( false );
#endif

  watchProperties();
 }

//-------------------------------------------------------------//

KSPanelGL::~KSPanelGL()
 {
 }

//-------------------------------------------------------------//

void KSPanelGL::readProperties()
 {
#ifdef HAVE_GL
  openglc->setChecked(p3->openGL());
  alphac->setChecked(p3->glTransparency());
  shadewallsc->setChecked(p3->glShadeWalls());
  autostrokec->setChecked(p3->glMeshAutoStroke());
  globaltr->setValue(p3->glGlobalTransparency());
  strokel->setValue(p3->glAutoStrokeLightness());
#endif
 }

//-------------------------------------------------------------//

void KSPanelGL::applyProperties()
 {
#ifdef HAVE_GL
  KSCmdSetProperties *cmd = new KSCmdSetProperties(p3);
  cmd->setProperty( "openGL", openglc->isChecked() );
  cmd->setProperty( "glTransparency", alphac->isChecked() );
  cmd->setProperty( "glShadeWalls", shadewallsc->isChecked() );
  cmd->setProperty( "glMeshAutoStroke", autostrokec->isChecked() );
  cmd->setProperty( "glGlobalTransparency", globaltr->value() );
  cmd->setProperty( "glAutoStrokeLightness", strokel->value() );
  m_workbook->execute( cmd );
#endif
 }

//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//


KSPanelButtonImage::KSPanelButtonImage( QWidget *parent, KSWorkbook *workbook, QSImage *image )
:KSPanelButton( parent, workbook, BDatasets, QPixmap(action_pixmap), tr("Pixmap: "), image )
 {
  m_image = image;
 }

//-----------------------------------------------------------//

KSPanelButtonImage::~KSPanelButtonImage()
 {
 }

//-----------------------------------------------------------//

KSPanel *KSPanelButtonImage::createPanel( QWidget *panelParent )
 {
  return new KSPanelImage( panelParent, m_workbook, m_image );
 }

//-----------------------------------------------------------//

bool KSPanelButtonImage::isButtonFor( QSCObject *object, int category, int element )
 {
  if ( category == QSAxes::DatasetCategory &&
       object->isAxesShadow() &&
       object->parentAxes()->plot(element) == m_image ) return true;
  return false;
 }

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//

KSPanelImage::KSPanelImage(QWidget *parent, KSWorkbook *workbook, QSImage *init_image, const char *name)
: KSPanelImageInterf(parent,name)
 {
  m_workbook = workbook;
  image = init_image;
  m_x_select = new KSAxisSelect( xaxisc, image->parentAxes(), QSAxis::XAxisType );
  m_y_select = new KSAxisSelect( yaxisc, image->parentAxes(), QSAxis::YAxisType );
  m_v_select = new KSAxisSelect( vaxisc, image->parentAxes(), QSAxis::VAxisType );

  QWhatsThis::add( titlee, tr("Series title\n\nIt is displayed on the legend.") );
  QWhatsThis::add( rawc, tr("Raw mode\n\nWhen raw mode is on, the V axis has set fixed range <0,255> and"
                        " linear scale. It requires much less calculations, so repaints"
                        " are much faster.") );
  watchProperties();
}

//-------------------------------------------------------------//

KSPanelImage::~KSPanelImage()
{
}

//-------------------------------------------------------------//

void KSPanelImage::readProperties()
{
 m_x_select->readProperties( image->defaultAxis(QSAxis::XAxisType)  );
 m_y_select->readProperties( image->defaultAxis(QSAxis::YAxisType)  );
 m_v_select->readProperties( image->defaultAxis(QSAxis::VAxisType)  );
 legendc->setChecked( image->legendItemVisible() );
 gradientc->setChecked( image->useGradient() );
 rawc->setChecked( image->rawMode() );
 titlee->setText( image->title() );
}

//-------------------------------------------------------------//

void KSPanelImage::applyProperties()
{
 KSCmdSetGraphicalProperties *cmd = new KSCmdSetGraphicalProperties(image);
 cmd->setProperty( "defaultXAxis", image->parentAxes()->axisIndex(m_x_select->selectedAxis()) );
 cmd->setProperty( "defaultYAxis", image->parentAxes()->axisIndex(m_y_select->selectedAxis()) );
 cmd->setProperty( "defaultVAxis", image->parentAxes()->axisIndex(m_v_select->selectedAxis()) );
 cmd->setProperty( "legendItemVisible", legendc->isChecked() );
 cmd->setProperty( "rawMode", rawc->isChecked() );
 cmd->setProperty( "useGradient", gradientc->isChecked() );
 cmd->setProperty( "title", titlee->text() );
 m_workbook->execute( cmd );
}

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//

//-----------------------------------------------------------//

KSPanelButtonLight::KSPanelButtonLight( QWidget *parent, KSWorkbook *workbook, QSAxes3D *axes )
:KSPanelButton( parent, workbook, BGeneral, QPixmap(panel_light), tr("Light") )
 {
  m_axes = axes;
 }

//-----------------------------------------------------------//

KSPanelButtonLight::~KSPanelButtonLight()
 {
 }

//-----------------------------------------------------------//

KSPanel *KSPanelButtonLight::createPanel( QWidget *panelParent )
 {
  return new KSPanelLight( panelParent, m_workbook, m_axes );
 }

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//

KSPanelLight::KSPanelLight(QWidget *parent, KSWorkbook *workbook, QSAxes3D *plot, const char *name)
: KSPanelLightInterf(parent,name)
 {
  assert( plot ); p3 = plot;
  m_workbook = workbook;
  QWhatsThis::add( lightc, tr("Light\n\nTurns on lighting.") );
  QWhatsThis::add( lightas, tr("Light azimuth\n\nPosition of the light source in spherical coordinates. Range is <0,359> degree. ") );
  QWhatsThis::add( lightes, tr("Light elevation\n\nPosition of the light source in spherical coordinates. Range is <-90,90> degree.") );
  QWhatsThis::add( lightis, tr("Light intensity\n\nIntensity of the directed light source. This parameter changes from "
                             "-50 (0%) to 50 (100%).") );
  QWhatsThis::add( lightams, tr("Abmient light intensity\n\nIntensity of the ambient light source or simple - lightness "
                              "This parameter changes from -50 (0%) to 50 (100%).") );

  watchProperties();
 }

//-----------------------------------------------------------//

KSPanelLight::~KSPanelLight()
 {
 }

//-----------------------------------------------------------//

void KSPanelLight::readProperties()
 {
  lightas->setValue( p3->lightAzimuth() );
  lightes->setValue( p3->lightElevation() );
  lightis->setValue( p3->directLight() );
  lightams->setValue( p3->ambientLight() );
  lightc->setChecked( p3->light() );
 }

//-----------------------------------------------------------//

void KSPanelLight::applyProperties()
 {
  KSCmdSetProperties *cmd = new KSCmdSetProperties(p3);
  cmd->setProperty( "lightAzimuth", lightas->value() );
  cmd->setProperty( "lightElevation", lightes->value() );
  cmd->setProperty( "directLight", lightis->value() );
  cmd->setProperty( "ambientLight", lightams->value() );
  cmd->setProperty( "light", lightc->isChecked() );
  m_workbook->execute( cmd );
 }

//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//


 //-----------------------------------------------------------//

KSPanelButtonMesh::KSPanelButtonMesh( QWidget *parent, KSWorkbook *workbook, QSPlot3D *plot )
:KSPanelButton( parent, workbook, BDatasets, QPixmap(panel_mesh), tr("Mesh: ")+plot->title() )
 {
  m_plot = plot;
 }

//-----------------------------------------------------------//

KSPanelButtonMesh::~KSPanelButtonMesh()
 {
 }

//-----------------------------------------------------------//

KSPanel *KSPanelButtonMesh::createPanel( QWidget *panelParent )
 {
  return new KSPanelMesh( panelParent, m_workbook, m_plot );
 }

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//

KSPanelMesh::KSPanelMesh(QWidget *parent, KSWorkbook *workbook, QSPlot3D *plot, const char *name)
: KSPanelMeshInterf(parent,name)
 {
  assert( plot ); p3 = plot;
  m_workbook = workbook;
  type->insertItem(tr("Default"));
  type->insertItem(tr("Gray"));
  type->insertItem(tr("Strange"));
  type->insertItem(tr("Two colors"));
  type->insertItem(tr("Five colors"));
  connect( type, SIGNAL(activated(int)), this, SLOT(gradient_type_changed(int)) );

  gradientw->setBackgroundMode( NoBackground );
  gradientw->installEventFilter( this );

  QWhatsThis::add( colorc, tr("Auto colors\n\nIf checked auto-colors are used as a fill color for a top side of the mesh."
                           " Default colors/Top is used otherwise.") );
  QWhatsThis::add( meshTopFill,    tr("Top color\n\nDefault color for a top side of the mesh. Used only if Auto color"
                           " is off.") );
  QWhatsThis::add( meshBottomFill,    tr("Bottom color\n\nDefault color for the bottom side of the mesh.") );
  /*
  QWhatsThis::add( col1,   tr("Default color for points with lowest Z values.") );
  QWhatsThis::add( col2,   tr("Default color for points with low Z values.") );
  QWhatsThis::add( col3,   tr("Default color for points with middle Z values.") );
  QWhatsThis::add( col4,   tr("Default color for points with great Z values.") );
  QWhatsThis::add( col5,   tr("Default color for points with greates Z values.") );
  QWhatsThis::add( line,   tr("Line style\n\nLine style for the mesh stroke.") );
  QWhatsThis::add( gradientw, tr("Gradient preview\n\nNothing really usable :)") );
  */
  watchProperties();
 }

//-------------------------------------------------------------//

KSPanelMesh::~KSPanelMesh()
 {
 }

//-------------------------------------------------------------//

void KSPanelMesh::readProperties()
 {
  colorc->setChecked( p3->colored() );
  divide->setChecked( p3->autoDivide() );
  topbottom->setChecked( p3->topBottom() );
  edgeAutoColor->setValue( p3->edgeAutoColor() );

  meshTopFill->setDialogFill( p3->fill(QSPlot3D::TMeshFill) );
  meshBottomFill->setDialogFill( p3->fill(QSPlot3D::BMeshFill) );
  meshLine->setDialogLine( p3->line(QSPlot3D::MeshLine) );
  meshPoint->setDialogPoint( p3->point(QSPlot3D::PointMark) );

  QSGGradient g = p3->gradient();

 	type->setCurrentItem( g.type() );
        gradient_type_changed(g.type());

  	meshFill1->setDialogFill( g.fill(0) );
  	meshFill2->setDialogFill( g.fill(1) );
  	meshFill3->setDialogFill( g.fill(2) );
  	meshFill4->setDialogFill( g.fill(3) );
  	meshFill5->setDialogFill( g.fill(4) );

  preview();
 }

//-------------------------------------------------------------//

void KSPanelMesh::applyProperties()
 {
  KSCmdSetGraphicalProperties *cmd = new KSCmdSetGraphicalProperties( p3 );
  cmd->setProperty( "gradient", toQString( QSGGradient( meshFill1->dialogFill(),
					      meshFill2->dialogFill(),
					      meshFill3->dialogFill(),
					      meshFill4->dialogFill(),
					      meshFill5->dialogFill(),
					      (QSGGradient::Type )type->currentItem())) );
  cmd->setProperty( "colored", colorc->isChecked() );
  cmd->setProperty( "autoDivide", divide->isChecked() );
  cmd->setProperty( "topBottom", topbottom->isChecked() );
  cmd->setProperty( "edgeAutoColor", edgeAutoColor->value() );
  cmd->setFill( QSPlot3D::TMeshFill, meshTopFill->dialogFill() );
  cmd->setFill( QSPlot3D::BMeshFill, meshBottomFill->dialogFill() );
  cmd->setLine( QSPlot3D::MeshLine, meshLine->dialogLine() );
  cmd->setPoint( QSPlot3D::PointMark, meshPoint->dialogPoint() );
  m_workbook->execute( cmd );
  preview();
 }


//-------------------------------------------------------------//

bool KSPanelMesh::eventFilter( QObject *o, QEvent *e )
 {
  QSGFill fill;

  if ( o == gradientw ) {
  if (  e->type() == QEvent::Paint ) {
	QPainter p( gradientw );
        QSGGradient g = p3->gradient();
        int w = gradientw->size().width();
        int h = gradientw->size().height();
        for ( int i=0; i<h; i++ ) {
                g.fill( double(h-i) / h, fill );
                p.setPen( QColor( fill.color.r, fill.color.g, fill.color.b ) );
                p.drawLine( 0, i, w-1, i );
               }
         return TRUE;
        }
     }

  return KSPanel::eventFilter(o,e);
 }

//-------------------------------------------------------------//

void KSPanelMesh::preview()
 {
  gradientw->update();
 }

//-------------------------------------------------------------//

void KSPanelMesh::gradient_type_changed(int )
 {
  QSGGradient g = QSGGradient( (QSGGradient::Type )type->currentItem() );
  meshFill1->show();
  meshFill2->show();
  meshFill3->show();
  meshFill4->show();
  meshFill5->show();

  	meshFill1->setDialogFill( g.fill(0) );
  	meshFill2->setDialogFill( g.fill(1) );
  	meshFill3->setDialogFill( g.fill(2) );
  	meshFill4->setDialogFill( g.fill(3) );
  	meshFill5->setDialogFill( g.fill(4) );


  if ( type->currentItem() == QSGGradient::GTwoColors ) {
	meshFill2->hide();
	meshFill3->hide();
	meshFill4->hide();
	}
  else
  if ( type->currentItem() == QSGGradient::GFiveColors ) {
	}
  else {
        meshFill1->hide();
	meshFill2->hide();
	meshFill3->hide();
	meshFill4->hide();
	meshFill5->hide();
       }

  preview();
 }

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//


//-----------------------------------------------------------//

KSPanelButtonCurve::KSPanelButtonCurve( QWidget *parent, KSWorkbook *workbook, QSCurve *curve )
:KSPanelButton( parent, workbook, BDatasets, QPixmap(action_curve), tr("XY plot: "), curve )
 {
  m_curve = curve;
 }

//-----------------------------------------------------------//

KSPanelButtonCurve::~KSPanelButtonCurve()
 {
 }

//-----------------------------------------------------------//

KSPanel *KSPanelButtonCurve::createPanel( QWidget *panelParent )
 {
  return new KSPanelCurve( panelParent, m_workbook, m_curve );
 }

//-----------------------------------------------------------//

bool KSPanelButtonCurve::isButtonFor( QSCObject *object, int category, int element )
 {
  if ( category == QSAxes::DatasetCategory &&
       object->isAxesShadow() &&
       object->parentAxes()->plot(element) == m_curve ) return true;
  return false;
 }
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//

//-------------------------------------------------------------//

KSPanelCurve::KSPanelCurve(QWidget *parent, KSWorkbook *workbook, QSCurve *plot, const char *name)
: KSPanelCurveInterf(parent,name)
 {
  assert( plot ); curve = plot;
  m_workbook = workbook;
  typec->clear();
  typec->insertItem(tr("Lines"));
  typec->insertItem(tr("Area"));
  typec->insertItem(tr("Ribbon"));
  typec->insertItem(tr("Bars"));
  typec->insertItem(tr("Vectors"));
  typec->insertItem(tr("Flux"));
  typec->insertItem(tr("Rectangles"));
  typec->insertItem(tr("Ellipses"));
  typec->insertItem(tr("Left Stairs"));
  typec->insertItem(tr("Middle Stairs"));
  typec->insertItem(tr("Right Stairs"));

  originArrow->setOrigin( true );
  endArrow->setOrigin( false );
  m_x_select = new KSAxisSelect( xaxisc, curve->parentAxes(), QSAxis::XAxisType );
  m_y_select = new KSAxisSelect( yaxisc, curve->parentAxes(), QSAxis::YAxisType );

  QWhatsThis::add( titlee, tr("Series title\n\nIt is displayed on the legend.") );

  QWhatsThis::add( typec, tr("Style\n\nPlot style for the current series.") );

  QWhatsThis::add( curveLine, tr("Line style\n\nLine style used to draw the current series") );
  QWhatsThis::add( curveFill, tr("Fill style\n\n Used to draw interiors of Polys, Rectangles, Ellipses and Bars") );
  QWhatsThis::add( curvePoint, tr("Point style\n\nStyle of point marks used to draw data points") );
  QWhatsThis::add( errorLine, tr("Errorbars line style\n\nLine style used to draw errorbars. See also 'Arrows' below.") );

  QWhatsThis::add( deltapdxe, tr("Delta % X value\n\nThis value is used when drawing Errorbars, Vectors, Rectangles, Ellipses or Polys. "
  				  "Total delta value is calculated as follows: DX[i] = DXVector[i] + FixedDeltaX + PercentDeltaX*XVector[i]/100.0;") );
  QWhatsThis::add( deltapdye, tr("Delta % Y value\n\nThis value is used when drawing Errorbars, Vectors, Rectangles, Ellipses or Polys."
			          "Total delta value is calculated as follows: DY[i] = DYVector[i] + FixedDeltaY + PercentDeltaY*YVector[i]/100.0;") );
  QWhatsThis::add( deltadxe, tr("Fixed Delta X value\n\nThis value is used when drawing Errorbars, Vectors, Rectangles, Ellipses or Polys."
  				  "Total delta value is calculated as follows: DX[i] = DXVector[i] + FixedDeltaX + PercentDeltaX*XVector[i]/100.0;") );
  QWhatsThis::add( deltadye, tr("Fixed Delta Y value\n\nThis value is used when drawing Errorbars, Vectors, Rectangles, Ellipses or Polys."
			          "Total delta value is calculated as follows: DY[i] = DYVector[i] + FixedDeltaY + PercentDeltaY*YVector[i]/100.0;") );

  QWhatsThis::add( zeroxe, tr("Zero Level X\n\nThis an X coordinate where XLines begin") );
  QWhatsThis::add( zeroye, tr("Zero Level Y\n\nThis an Y coordinate where YLines and Bars begin") );

  QWhatsThis::add( xLine, tr("Y Lines\n\n Horizontal lines, which crosses data points on the plot") );
  QWhatsThis::add( yLine, tr("X Lines\n\n Vertical lines, which crosses data points on the plot") );

  QWhatsThis::add( originArrow, tr("Arrow style\n\n Arrow style used to draw horizontal bars or a vector begin") );
  QWhatsThis::add( endArrow, tr("Arrow style\n\n Arrow style used to draw vertical bars or a vector end") );


  watchProperties();
 }

//-------------------------------------------------------------//

KSPanelCurve::~KSPanelCurve()
 {
 }



//-------------------------------------------------------------//

void KSPanelCurve::readProperties()
 {
  typec->setCurrentItem( curve->type() );
  m_x_select->readProperties( curve->defaultAxis(QSAxis::XAxisType)  );
  m_y_select->readProperties( curve->defaultAxis(QSAxis::YAxisType)  );

  legendc->setChecked( curve->legendItemVisible() );

  deltapdxe->setText( QString::number(curve->percentDelta().x) );
  deltapdye->setText( QString::number(curve->percentDelta().y) );

  deltadxe->setText( QString::number(curve->fixedDelta().x) );
  deltadye->setText( QString::number(curve->fixedDelta().y) );

  zeroxe->setText( QString::number(curve->zeroPoint().x) );
  zeroye->setText( QString::number(curve->zeroPoint().y) );
  errorLine->setDialogLine( curve->line(QSCurve::ErrorLine) );
  xLine->setDialogLine( curve->line(QSCurve::XLine) );
  yLine->setDialogLine( curve->line(QSCurve::YLine) );
  curveLine->setDialogLine( curve->line(QSCurve::BaseLine) );
  curveFill->setDialogFill( curve->fill(QSCurve::BaseFill) );
  curvePoint->setDialogPoint( curve->point(QSCurve::PointMark) );
  originArrow->setDialogArrow( curve->arrow1() );
  endArrow->setDialogArrow( curve->arrow2() );
  titlee->setText( curve->title() );
 }

//-------------------------------------------------------------//

void KSPanelCurve::applyProperties()
{
 KSCmdSetGraphicalProperties *cmd = new KSCmdSetGraphicalProperties(curve);
 cmd->setProperty( "defaultXAxis", curve->parentAxes()->axisIndex(m_x_select->selectedAxis()) );
 cmd->setProperty( "defaultYAxis", curve->parentAxes()->axisIndex(m_y_select->selectedAxis()) );
 cmd->setProperty( "legendItemVisible", legendc->isChecked() );
 cmd->setProperty( "title", titlee->text() );

 cmd->setProperty( "type", typec->currentItem() );
 cmd->setProperty( "zeroLevelX", zeroxe->text().toDouble() );
 cmd->setProperty( "zeroLevelY", zeroye->text().toDouble() );
 cmd->setProperty( "fixedDX", deltadxe->text().toDouble() );
 cmd->setProperty( "fixedDY", deltadye->text().toDouble() );
 cmd->setProperty( "percentDX", deltapdxe->text().toDouble() );
 cmd->setProperty( "percentDY", deltapdye->text().toDouble() );

 cmd->setLine( QSCurve::BaseLine, curveLine->dialogLine() );
 cmd->setLine( QSCurve::ErrorLine, errorLine->dialogLine() );
 cmd->setLine( QSCurve::XLine, xLine->dialogLine() );
 cmd->setLine( QSCurve::YLine, yLine->dialogLine() );
 cmd->setFill( QSCurve::BaseFill, curveFill->dialogFill() );
 cmd->setPoint( QSCurve::PointMark, curvePoint->dialogPoint() );

 cmd->setProperty( "arrow1", toQString(originArrow->dialogArrow()) );
 cmd->setProperty( "arrow2", toQString(endArrow->dialogArrow()) );

 m_workbook->execute( cmd );
}


//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//


//-----------------------------------------------------------//

KSPanelButtonSurface::KSPanelButtonSurface( QWidget *parent, KSWorkbook *workbook, QSSurface *surface )
:KSPanelButton( parent, workbook, BDatasets, QPixmap(action_surface), tr("Surface: "), surface )
 {
  m_surface = surface;
 }

//-----------------------------------------------------------//

KSPanelButtonSurface::~KSPanelButtonSurface()
 {
 }

//-----------------------------------------------------------//

KSPanel *KSPanelButtonSurface::createPanel( QWidget *panelParent )
 {
  return new KSPanelSurface( panelParent, m_workbook, m_surface );
 }

//-----------------------------------------------------------//

bool KSPanelButtonSurface::isButtonFor( QSCObject *object, int category, int element )
 {
  if ( category == QSAxes::DatasetCategory &&
       object->isAxesShadow() &&
       object->parentAxes()->plot(element) == m_surface ) return true;
  return false;
 }

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//

KSPanelSurface::KSPanelSurface(QWidget *parent, KSWorkbook *workbook, QSSurface *init_surface, const char *name)
: KSPanelSurfaceInterf(parent,name)
 {
  surface = init_surface;
  m_workbook = workbook;
  m_x_select = new KSAxisSelect( xaxisc, surface->parentAxes(), QSAxis::XAxisType );
  m_y_select = new KSAxisSelect( yaxisc, surface->parentAxes(), QSAxis::YAxisType );
  m_z_select = new KSAxisSelect( zaxisc, surface->parentAxes(), QSAxis::ZAxisType );
  m_v_select = new KSAxisSelect( vaxisc, surface->parentAxes(), QSAxis::VAxisType );
  watchProperties();
 }

//------------------------------------------------------------//

KSPanelSurface::~KSPanelSurface()
 {
 }

//------------------------------------------------------------//

void KSPanelSurface::readProperties()
 {
  m_x_select->readProperties( surface->defaultAxis(QSAxis::XAxisType)  );
  m_y_select->readProperties( surface->defaultAxis(QSAxis::YAxisType)  );
  m_z_select->readProperties( surface->defaultAxis(QSAxis::ZAxisType)  );
  m_v_select->readProperties( surface->defaultAxis(QSAxis::VAxisType)  );
  xGridStep->setValue( surface->xGridStep() );
  yGridStep->setValue( surface->yGridStep() );
  legendc->setChecked( surface->legendItemVisible() );
  titlee->setText( surface->title() );
 }

//------------------------------------------------------------//

void KSPanelSurface::applyProperties()
 {
  KSCmdSetGraphicalProperties *cmd = new KSCmdSetGraphicalProperties(surface);

  cmd->setProperty( "xGridStep", xGridStep->value() );
  cmd->setProperty( "yGridStep", yGridStep->value() );
  cmd->setProperty( "legendItemVisible", legendc->isChecked() );
  cmd->setProperty( "title", titlee->text() );
  cmd->setProperty( "defaultXAxis", surface->parentAxes()->axisIndex(m_x_select->selectedAxis()) );
  cmd->setProperty( "defaultYAxis", surface->parentAxes()->axisIndex(m_y_select->selectedAxis()) );
  cmd->setProperty( "defaultZAxis", surface->parentAxes()->axisIndex(m_z_select->selectedAxis()) );
  cmd->setProperty( "defaultVAxis", surface->parentAxes()->axisIndex(m_v_select->selectedAxis()) );

  m_workbook->execute( cmd );
 }

//------------------------------------------------------------//
//------------------------------------------------------------//
//------------------------------------------------------------//
//------------------------------------------------------------//
//------------------------------------------------------------//

//-----------------------------------------------------------//

KSPanelButtonGrid::KSPanelButtonGrid( QWidget *parent, KSWorkbook *workbook, QSAxis *axis )
:KSPanelButton( parent, workbook, BAxes, QPixmap() )
 {
  m_axis = axis;

  QPixmap icon;
  QString tool_tip;
  switch( m_axis->type() ) {
	case QSAxis::XAxisType: icon = QPixmap(panel_gx); tool_tip = tr("X grid : ")+axis->title(); break;
	case QSAxis::YAxisType: icon = QPixmap(panel_gy); tool_tip = tr("Y grid : ")+axis->title(); break;
	case QSAxis::ZAxisType: icon = QPixmap(panel_gz); tool_tip = tr("Z grid : ")+axis->title(); break;
	case QSAxis::VAxisType: icon = QPixmap(panel_gv); tool_tip = tr("V grid : ")+axis->title(); break;
	}
  setPixmap(icon);
  QToolTip::add( this, tool_tip );
  QWhatsThis::add( this, tool_tip );
 }

//-----------------------------------------------------------//

KSPanelButtonGrid::~KSPanelButtonGrid()
 {
 }

//-----------------------------------------------------------//

KSPanel *KSPanelButtonGrid::createPanel( QWidget *panelParent )
 {
  return new KSPanelGrid( panelParent, m_workbook, m_axis );
 }

//-----------------------------------------------------------//

bool KSPanelButtonGrid::isButtonFor( QSCObject *object, int category, int element )
 {
  if ( category == QSAxes::GridCategory &&
       object->isAxesShadow() &&
       object->parentAxes()->axis(element) == m_axis ) return true;
  return false;
 }

//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//


KSPanelGrid::KSPanelGrid(QWidget *parent, KSWorkbook *workbook, QSAxis *axis, const char *name)
 : KSPanelGridInterf(parent,name)
 {
  m_axis = axis;
  m_workbook = workbook;

  codes = new QPopupMenu( formate );
  codes->setFont(QFont("helvetica", 10, 50));
  codes->insertItem( tr("value"),  Value  );
  codes->insertItem( tr("factor"), Factor );
  codes->insertItem( tr("base"),   Base   );
  codes->insertItem( tr("exponent"), Exponent );

  formate->installEventFilter( this );


  QWhatsThis::add( adjustc,  tr("Adjust an axis range \n\nIf turned on the axis range "
                             "is rounded to a tic step border.") );
  QWhatsThis::add( majdensitye, tr("Major tic step(value>0) \nMajor tic density (value<0)\n\nDensity is "
                                "only an approximative value. Number of visible tics "
                                "may be slightly different. ") );
  QWhatsThis::add( mindensitye, tr("Minor tic step \nMinor tic density \n\nDensity is "
                                "only an approximative value. Number of visible tics "
                                "may be slightly different. ") );
  QWhatsThis::add( formate, tr("Format of axis labels \n\nThis is a text, which will be displayed "
                            "as a label text.\nTo insert a tic value into it type (TIC). Two "
                            "additional paramaters may be added after TIC word:\n"
                            "TYPE=\"?\", where ? can be one of the following letters: \n"
                            "V - tic value. This is a default value. \n"
                            "X - exponent part of the label value. \n"
                            "F - factor part of the label value. \n"
                            "B - base part of the label value.\n"
                            "\n"
                            "FORMAT=\"?\", where ? is an ordinary C-styled \"printf\" format, "
                            "but with only eEfgG types allowed. Default value is %g. "
                            "\n\n"
                            "Example:\n"
                            "(TIC TYPE=\"x\" FORMAT=\"%.2f\") \n"
                            "\n"
                            "Press a right mouse button over the edit field to insert a standard format.") );
  QWhatsThis::add( majorLine, tr("Line style\n\nLine style for major grid lines.") );
  QWhatsThis::add( minorLine, tr("Line style\n\nLine style for minor grid lines.") );
  QWhatsThis::add( labelFont, tr("Labels font\n\nFont used to draw labels.") );
  watchProperties();
 }


//-----------------------------------------------------------//

KSPanelGrid::~KSPanelGrid()
 {
 }

//-----------------------------------------------------------//

void KSPanelGrid::applyProperties()
 {
  KSCmdSetGraphicalProperties *cmd = new KSCmdSetGraphicalProperties(m_axis);
  cmd->setProperty( "ticsFormat", formate->text() );
  cmd->setProperty( "roundRangeToTicStep", adjustc->isChecked() );
  cmd->setProperty( "majorGridStep", majdensitye->text().toDouble() );
  cmd->setProperty( "minorGridStep", mindensitye->text().toDouble() );
  cmd->setFont( QSAxis::TicsFont, labelFont->dialogFont()  );
  cmd->setLine( QSAxis::MajorGridLine, majorLine->dialogLine() );
  cmd->setLine( QSAxis::MinorGridLine, minorLine->dialogLine() );
  cmd->setProperty( "ticsOuter", outerc->isChecked() );
  cmd->setProperty( "ticsVisible", showticc->isChecked() );
  cmd->setProperty( "ticsAngle", angle->value() );
  cmd->setProperty( "ticLabelPos1", evenPos->text().toDouble() );
  cmd->setProperty( "ticLabelPos2", oddPos->text().toDouble() );
  m_workbook->execute( cmd );
 }


//-----------------------------------------------------------//

void KSPanelGrid::readProperties()
 {
  formate->setText( m_axis->ticsFormat() );
  adjustc->setChecked( m_axis->roundRangeToTicStep() );
  majdensitye->setText( QString::number( m_axis->majorGridStep(), 'g', 3 ) );
  mindensitye->setText( QString::number( m_axis->minorGridStep(), 'g', 3 ) );
  labelFont->setDialogFont(  m_axis->font(QSAxis::TicsFont)  );
  majorLine->setDialogLine( m_axis->line(QSAxis::MajorGridLine) );
  minorLine->setDialogLine( m_axis->line(QSAxis::MinorGridLine) );
  outerc->setChecked( m_axis->ticsOuter() );
  showticc->setChecked( m_axis->ticsVisible() );
  angle->setValue( m_axis->ticsAngle() );
  evenPos->setText( QString::number( m_axis->ticLabelPos1(), 'g', 3 ) );
  oddPos->setText( QString::number( m_axis->ticLabelPos2(), 'g', 3 ) );
 }


//-----------------------------------------------------------//

bool KSPanelGrid::eventFilter( QObject *o, QEvent *e )
 {
  /*
  if ( e->type() == QEvent::MouseButtonPress && o == formate ) {
         // popup menu
         QMouseEvent *p = static_cast<QMouseEvent *>(e);

         if ( p->button() == RightButton ) {

                 FormatCode code = FormatCode( codes->exec( QCursor::pos()));

                 switch( code ) {
                         case Value:         formate->insert("<TIC TYPE=\"V\" FORMAT=\"%g\">");   break;
                         case Factor:        formate->insert("<TIC TYPE=\"F\" FORMAT=\"%.2f\">"); break;
                         case Exponent:      formate->insert("<TIC TYPE=\"X\" FORMAT=\"%g\">");   break;
                         case Base:          formate->insert("<TIC TYPE=\"B\" FORMAT=\"%g\">");   break;
                        }
                 return TRUE;
                }
        }
  */
  return KSPanelGridInterf::eventFilter(o,e);
 }


//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//
//------------------------------------------------------------------------------------------------------//

 //-----------------------------------------------------------//

KSPanelButtonView::KSPanelButtonView( QWidget *parent, KSWorkbook *workbook, QSAxes3D *axes )
:KSPanelButton( parent, workbook, BGeneral, QPixmap(panel_view), tr("Viewpoint") )
 {
  m_axes = axes;
 }

//-----------------------------------------------------------//

KSPanelButtonView::~KSPanelButtonView()
 {
 }

//-----------------------------------------------------------//

KSPanel *KSPanelButtonView::createPanel( QWidget *panelParent )
 {
  return new KSPanelView( panelParent, m_workbook, m_axes );
 }

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//

KSPanelView::KSPanelView(QWidget *parent, KSWorkbook *workbook, QSAxes3D *plot, const char *name)
: KSPanelViewInterf(parent,name)
 {
  assert( plot ); p3 = plot;
  m_workbook = workbook;

  QWhatsThis::add( perspectivec, tr("Perspective\n\nTurns on perspective."));
  QWhatsThis::add( autoscalec, tr("Autoscale\n\nFits an axis box to the display area."));
  QWhatsThis::add( azimuths, tr("Azimuth\n\nPosition of the viewpoint in spherical coordinates. Range is <0,359> degree.") );
  QWhatsThis::add( elevations, tr("Elevation\n\nPosition of the viewpoint in spherical coordinates. Range is <-90,90> degree."));
  QWhatsThis::add( distances, tr("Distance\n\nSize of the plot. Changes from -50 (0%) to 50 (200%).") );
  QWhatsThis::add( fdistances, tr("Focuspoint distance\n\nDistance from the focus point to the "
                                "screen. Changes from -50 (almost zero) to 50 (almost inf).")  );

  watchProperties();
 }

//-----------------------------------------------------------//

KSPanelView::~KSPanelView()
 {
 }

//-----------------------------------------------------------//	

void KSPanelView::readProperties()
 {
  azimuths->setValue( p3->azimuth() );
  elevations->setValue( p3->elevation() );
  distances->setValue( p3->distance() );
  fdistances->setValue( p3->focusDistance() );

  perspectivec->setChecked( p3->perspective() );
  autoscalec->setChecked( p3->autoscale() );
 }

//-----------------------------------------------------------//

void KSPanelView::applyProperties()
 {
  KSCmdSetProperties *cmd = new KSCmdSetProperties(p3);

  cmd->setProperty( "azimuth", azimuths->value() );
  cmd->setProperty( "elevation", elevations->value() );
  cmd->setProperty( "distance", distances->value() );
  cmd->setProperty( "focusDistance", fdistances->value() );
  cmd->setProperty( "perspective", perspectivec->isChecked() );
  cmd->setProperty( "autoscale", autoscalec->isChecked() );

  m_workbook->execute( cmd );
 }

//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//

KSPanelButtonGradient::KSPanelButtonGradient( QWidget *parent, KSWorkbook *workbook, QSPlot *plot )
:KSPanelButton( parent, workbook, BDatasets, QPixmap(panel_gradient), tr("Gradient "), plot )
 {
  m_plot = plot;
 }

//-----------------------------------------------------------//

KSPanelButtonGradient::~KSPanelButtonGradient()
 {
 }

//-----------------------------------------------------------//

KSPanel *KSPanelButtonGradient::createPanel( QWidget *panelParent )
 {
  return new KSPanelGradient( panelParent, m_workbook, m_plot );
 }

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//

KSPanelGradient::KSPanelGradient(QWidget *parent, KSWorkbook *workbook, QSPlot *init_plot, const char *name)
: KSPanelGradientInterf(parent,name)
 {
  m_plot = init_plot;
  m_workbook = workbook;
  connect( type, SIGNAL(activated(int)), this, SLOT(gradient_type_changed(int)) );
  //connect( col1, SIGNAL(dialogFillChanged()), this, SLOT(preview()) );
  //connect( col2, SIGNAL(dialogFillChanged()), this, SLOT(preview()) );
  //connect( col3, SIGNAL(dialogFillChanged()), this, SLOT(preview()) );
  //connect( col4, SIGNAL(dialogFillChanged()), this, SLOT(preview()) );
  //connect( col5, SIGNAL(dialogFillChanged()), this, SLOT(preview()) );

  gradientw->setBackgroundMode( NoBackground );
  gradientw->installEventFilter( this );
  /*
  QWhatsThis::add( col1,   tr("Default color for points with lowest Z values.") );
  QWhatsThis::add( col2,   tr("Default color for points with low Z values.") );
  QWhatsThis::add( col3,   tr("Default color for points with middle Z values.") );
  QWhatsThis::add( col4,   tr("Default color for points with great Z values.") );
  QWhatsThis::add( col5,   tr("Default color for points with greates Z values.") );
  QWhatsThis::add( gradientw, tr("Gradient preview") );
  */
  watchProperties();
 }


//-------------------------------------------------------------//

KSPanelGradient::~KSPanelGradient()
 {
 }

//-------------------------------------------------------------//

void KSPanelGradient::readProperties()
 {
  QSGGradient g = m_plot->gradient();

 	type->setCurrentItem( g.type() );
        gradient_type_changed(g.type());

  	gradientFill1->setDialogFill( g.fill(0) );
  	gradientFill2->setDialogFill( g.fill(1) );
  	gradientFill3->setDialogFill( g.fill(2) );
  	gradientFill4->setDialogFill( g.fill(3) );
  	gradientFill5->setDialogFill( g.fill(4) );
	
  preview();
 }

//-------------------------------------------------------------//

void KSPanelGradient::applyProperties()
 {
  KSCmdSetGraphicalProperties *cmd = new KSCmdSetGraphicalProperties( m_plot );
  cmd->setProperty( "gradient", toQString( QSGGradient( gradientFill1->dialogFill(),
					      gradientFill2->dialogFill(),
					      gradientFill3->dialogFill(),
					      gradientFill4->dialogFill(),
					      gradientFill5->dialogFill(),
					      (QSGGradient::Type )type->currentItem() )) );
  m_workbook->execute( cmd );
  preview();
 }


//-------------------------------------------------------------//

bool KSPanelGradient::eventFilter( QObject *o, QEvent *e )
 {
  QSGFill fill;

  if ( o == gradientw ) {
  if (  e->type() == QEvent::Paint ) {
	QPainter p( gradientw );
        QSGGradient g = m_plot->gradient();
        int w = gradientw->size().width();
        int h = gradientw->size().height();
        for ( int i=0; i<h; i++ ) {
                g.fill( double(h-i) / h, fill );
                p.setPen( QColor( fill.color.r, fill.color.g, fill.color.b ) );
                p.drawLine( 0, i, w-1, i );
               }
         return TRUE;
        }
     }

  return KSPanel::eventFilter(o,e);
 }

//-------------------------------------------------------------//

void KSPanelGradient::preview()
 {
  gradientw->update();
 }

//-------------------------------------------------------------//

void KSPanelGradient::gradient_type_changed(int )
 {
  QSGGradient g = QSGGradient( (QSGGradient::Type )type->currentItem() );
  gradientFill1->show();
  gradientFill2->show();
  gradientFill3->show();
  gradientFill4->show();
  gradientFill5->show();

  	gradientFill1->setDialogFill( g.fill(0) );
  	gradientFill2->setDialogFill( g.fill(1) );
  	gradientFill3->setDialogFill( g.fill(2) );
  	gradientFill4->setDialogFill( g.fill(3) );
  	gradientFill5->setDialogFill( g.fill(4) );

  if ( type->currentItem() == QSGGradient::GTwoColors ) {
	gradientFill2->hide();
	gradientFill3->hide();
	gradientFill4->hide();
	}
  else
  if ( type->currentItem() == QSGGradient::GFiveColors ) {
	}
  else {
        gradientFill1->hide();
	gradientFill2->hide();
	gradientFill3->hide();
	gradientFill4->hide();
	gradientFill5->hide();
       }

  preview();
 }

