/***************************************************************************
                                  kspanel.cpp
                             -------------------
    begin                : Sat Oct 7 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildobk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kspanel.h"
#include <qobjcoll.h>
#include <qwhatsthis.h>
#include <qtooltip.h>
#include <qcombobox.h>
#include "../widgets/qsaxes.h"
#include "../widgets/qsaxis.h"
#include "../pixmaps/panel_general.xpm"
#include "../pixmaps/panel_axes.xpm"
#include "../pixmaps/panel_datasets.xpm"
#include "../pixmaps/panel_object.xpm"

KSPanelButton *KSPanelButton::categoryButton( ButtonCategory category, QWidget *parent )
 {
  switch( category ) {
	case BGeneral:	return new KSPanelButton( parent, NULL, BGeneral, QPixmap(panel_general), tr("General properties") );  		break;
	case BAxes:   	return new KSPanelButton( parent, NULL, BAxes, QPixmap(panel_axes), tr("Axis properties") );  			break;
	case BDatasets:	return new KSPanelButton( parent, NULL, BDatasets, QPixmap(panel_datasets), tr("Dataset properties") );  	break;
	case BObject:  	return new KSPanelButton( parent, NULL, BObject, QPixmap(panel_object), tr("Object properties") );  		break;
	}
  return NULL;
 }

//-----------------------------------------------------//

KSPanelButton::KSPanelButton( QWidget *parent, KSWorkbook *workbook, ButtonCategory category, const QPixmap& icon, const QString& toolTip, QSData *dataObject = NULL )
:QPushButton( parent )
 {
  m_category = category;
  m_workbook = workbook;
  m_data_object = dataObject;
  //setFixedHeight( 25 );
  setToggleButton( true );
  setPixmap(icon);
  QToolTip::add( this, toolTip );
  QWhatsThis::add( this, toolTip );
  installEventFilter( this );
 }

//-----------------------------------------------------//

KSPanelButton::~KSPanelButton()
 {
 }

//-----------------------------------------------------//

KSPanel *KSPanelButton::createPanel( QWidget * )
 {
  return NULL;
 }

//-----------------------------------------------------//
//-----------------------------------------------------//
//-----------------------------------------------------//
//-----------------------------------------------------//

KSPanel::KSPanel(QWidget *parent, const char *name )
: QWidget(parent,name)
 {
 }

//-----------------------------------------------------//

KSPanel::~KSPanel()
 {
 }

//-----------------------------------------------------//

void KSPanel::watchProperties()
 {
  watch_properties_of( this );	
 }

//-----------------------------------------------------//

void KSPanel::watch_properties_of( QObject *o )
// handles:
//	QLineEdit
//	QCheckBox
//      QSpinBox
//	QButton
//      QMultiLineEdit
//	KSAttrBtn
 {
  const QObjectList *fields = o->children();
  if ( fields ) {
  	QObjectListIt field( *fields );	
  	while ( (QObject *)field ) {
  		QObject *object = field;
  	 	// KSAttrBtn must be before QButton !
		if ( qstrcmp(object->className(),"QFrame") == 0 ) watch_properties_of( object );
                else if (  object->inherits("KSTextEdit")    ) { object->installEventFilter( this ); connect( object, SIGNAL(changed()), this, SLOT(property_change()) ); }		
		else if ( object->inherits("QLineEdit")      ) { object->installEventFilter( this ); connect( object, SIGNAL(returnPressed()), this, SLOT(property_change()) );}
  	 	else if ( object->inherits("KSAttrBtn")      ) { object->installEventFilter( this ); connect( object, SIGNAL(attrChanged()), this, SLOT(property_change()) ); }
  	 	else if ( object->inherits("QButton")        ) { object->installEventFilter( this ); connect( object, SIGNAL(clicked()), this, SLOT(property_change()) ); }
		else if ( object->inherits("QMultiLineEdit") ) { object->installEventFilter( this ); connect( object, SIGNAL(textChanged()), this, SLOT(property_change()) ); }
 		else if ( object->inherits("QComboBox")      ) { object->installEventFilter( this ); connect( object, SIGNAL(activated(const QString&)), this, SLOT(property_change_string(const QString&)) ); }  	 	
		else if ( object->inherits("QSpinBox")       ) {
                        QObjectList *l = object->queryList( "QLineEdit" );
    			QObjectListIt it( *l );
    			QObject *line_edit = it.current();
    			if ( line_edit ) {
				line_edit->installEventFilter( this );
                        	QWhatsThis::add( (QWidget *)line_edit, QWhatsThis::textFor((QWidget *)object) );
				}
                        delete l;
			connect( object, SIGNAL(valueChanged(const QString&)), this, SLOT(property_change_string(const QString&)) );
			}
		
  	 	
  	 	++field;
  	       }
  	}
 }

//-----------------------------------------------------//

void KSPanel::property_change()
 {
  emit propertiesChanged();
 }
//-----------------------------------------------------//

void KSPanel::property_change_string(const QString&)
 {
  emit propertiesChanged();
 }

//-----------------------------------------------------//

bool KSPanel::eventFilter ( QObject *o, QEvent *e )
 {
  if ( o->isWidgetType() ) switch( e->type() ) {
	case QEvent::Enter:  emit message( QWhatsThis::textFor((QWidget *)o) ); break;
	case QEvent::Leave:  emit message( "" ); break;
	default: break;
  	}
  return FALSE;
 }

//-----------------------------------------------------//
//-----------------------------------------------------//
//-----------------------------------------------------//
//-----------------------------------------------------//

KSAxisSelect::KSAxisSelect( QComboBox *parent, QSAxes *parentAxes, int axisType )
:QObject( parent )
 {
  m_parent = parent;
  m_parent_axes = parentAxes;
  m_axis_type = axisType;

  QWhatsThis::add( parent, axisName() + tr("\n\nAxis, which the current dataset is bound to" ) );
 }

//-----------------------------------------------------//

KSAxisSelect::~KSAxisSelect()
 {
 }

//-----------------------------------------------------//

QString KSAxisSelect::axisName()
 {
  QString type_name = "Unknown";
  switch( m_axis_type ) {
	case QSAxis::XAxisType: type_name = "X axis "; break;
	case QSAxis::YAxisType: type_name = "Y axis "; break;
 	case QSAxis::ZAxisType: type_name = "Z axis "; break;
 	case QSAxis::VAxisType: type_name = "V axis "; break;
	}
 return type_name;
 }

//-----------------------------------------------------//

QSAxis *KSAxisSelect::selectedAxis()
 {
  if ( m_parent_axes == NULL ) return NULL;

  int index = m_parent->currentItem();
  int axis_of_type = 0;
  int axis_nr;
  for( axis_nr=0; axis_nr<m_parent_axes->axisCount(); axis_nr++ ) {
	 if ( m_parent_axes->axis(axis_nr)->type() == m_axis_type ) {
		 if ( axis_of_type == index ) break;
                 axis_of_type += 1;
		}
	}
  return m_parent_axes->axis(axis_nr);
 }

//-----------------------------------------------------//

void KSAxisSelect::readProperties( QSAxis *selectedAxis )
 {
  m_parent->clear();
  if( m_parent_axes == NULL ) return;

  int index = 0;
  for( int axis_nr=0; axis_nr<m_parent_axes->axisCount(); axis_nr++ )
	if ( m_parent_axes->axis(axis_nr)->type() == m_axis_type ) {
		  m_parent->insertItem( axisName() + m_parent_axes->axis(axis_nr)->title() );
		  if ( m_parent_axes->axis(axis_nr) == selectedAxis ) m_parent->setCurrentItem( index );
	          index++;
		  }

 }
