/***************************************************************************
                          ksgeneraldialogs.h  -  description
                             -------------------
    begin                : Fri Nov 9 2001
    copyright            : (C) 2001 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSOBJECTTREEDLG_H
#define KSOBJECTTREEDLG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ksobjecttreedlginterf.h"

class QSPage;
class QPoint;
class QSCObject;
class QSPlotView;
class QListViewItem;
class KMatplotShell;
class QSCObjectCollection;

class KSObjectTreePanel : public KSObjectTreePanelInterf
 {
	Q_OBJECT
   public:
	KSObjectTreePanel( KMatplotShell *shell, QSPlotView *view, QWidget *parent );
	virtual ~KSObjectTreePanel();
	void setPage( QSPage *page );
  public slots:
	virtual void slotRaise();
	virtual void slotLower();
	virtual void slotToBack();
	virtual void slotToFront();
	virtual void slotObjectViewSelectionChanged();
	virtual void slotShowMenu( QListViewItem *, const QPoint&, int );
  private slots:
	void slot_current_page_changed();
	void slot_object_list_changed( QSCObjectCollection *collection );
	void slot_selection_changed();
  private:
	KMatplotShell *m_shell;
	QSPlotView *m_view;
	QSPage *m_page;

	void create_object_list();
	void add_object_to_the_list( QSCObject *object, QListViewItem *parent=NULL );
        void update_selection();
	void update_current_item( QSCObject *object );
 };

#endif

