/***************************************************************************
                          ksgeneraldialogs.cpp  -  description
                             -------------------
    begin                : Fri Nov 9 2001
    copyright            : (C) 2001 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ksobjecttreedlg.h"
#include "../widgets/qsplotview.h"
#include "../kmatplotshell.h"
#include <qlistview.h>

class KSObjectTreeListItem : public QListViewItem
 {
  public:
	KSObjectTreeListItem( QListView *parent, QSCObject *object )
	 : QListViewItem(parent), m_object(object) {
		setText( 0, m_object->name() );
		}
	KSObjectTreeListItem( QListViewItem *parent, QSCObject *object )
	 : QListViewItem(parent), m_object(object) {
		setText( 0, m_object->name() );
		}
	~KSObjectTreeListItem() {
		}
	QSCObject *object() const {
		return m_object;
		}
  private:
	QSCObject *m_object;
 };

//--------------------------------------------------------------------------//

KSObjectTreePanel::KSObjectTreePanel( KMatplotShell *shell, QSPlotView *view, QWidget *parent )
: KSObjectTreePanelInterf(parent,NULL)
 {
  m_page = NULL;
  m_shell = shell;
  m_view = view;
  objectView->setSorting(-1);
  connect( m_view, SIGNAL(sigCurrentPageChanged()), this, SLOT(slot_current_page_changed()) );
  connect( m_view->selection(), SIGNAL(sigChanged()), this, SLOT(slot_selection_changed()) );
  setPage( m_view->currentPage() );
 }

//--------------------------------------------------------------------------//

KSObjectTreePanel::~KSObjectTreePanel()
 {
 }

//--------------------------------------------------------------------------//

void KSObjectTreePanel::slotRaise()
 {
  m_shell->doAction( m_shell->m_raise );
 }

//--------------------------------------------------------------------------//

void KSObjectTreePanel::slotLower()
 {
  m_shell->doAction( m_shell->m_lower );
 }

//--------------------------------------------------------------------------//

void KSObjectTreePanel::slotToBack()
 {
  m_shell->doAction( m_shell->m_send_to_back );
 }

//--------------------------------------------------------------------------//

void KSObjectTreePanel::slotToFront()
 {
  m_shell->doAction( m_shell->m_bring_to_front );
 }

//--------------------------------------------------------------------------//

void KSObjectTreePanel::slotShowMenu( QListViewItem *, const QPoint&, int )
 {
  m_shell->doAction( m_shell->m_object_menu );
 }

//--------------------------------------------------------------------------//

void  KSObjectTreePanel::setPage( QSPage *page )
 {
  if ( m_page ) {
	disconnect( m_page->objects(), SIGNAL(sigListChanged(QSCObjectCollection*)), this, SLOT(slot_object_list_changed(QSCObjectCollection*)) );
	}
  m_page = page;
  if ( m_page ) {
	connect( m_page->objects(), SIGNAL(sigListChanged(QSCObjectCollection*)), this, SLOT(slot_object_list_changed(QSCObjectCollection*)) );
	}
  create_object_list();
 }

//--------------------------------------------------------------------------/

void KSObjectTreePanel::slotObjectViewSelectionChanged()
 {
  m_view->selection()->setAutoUpdates( false );
  m_view->selection()->clear();
  KSObjectTreeListItem *citem = dynamic_cast<KSObjectTreeListItem*>(objectView->firstChild());
  while ( citem ) {
	 if ( citem->isSelected() ) m_view->selection()->add( citem->object() );
         citem = dynamic_cast<KSObjectTreeListItem*>(citem->itemBelow());
        }
  m_view->selection()->setAutoUpdates( true );
 }

//--------------------------------------------------------------------------//

void KSObjectTreePanel::slot_current_page_changed()
 {
  setPage( m_view->currentPage() );
 }

//--------------------------------------------------------------------------//

void KSObjectTreePanel::slot_object_list_changed( QSCObjectCollection * )
 {
  create_object_list();
 }

//--------------------------------------------------------------------------//

void KSObjectTreePanel::slot_selection_changed()
 {
  update_selection();
 }

//--------------------------------------------------------------------------//

void KSObjectTreePanel::create_object_list()
 {
  int pos_x = objectView->contentsX();
  int pos_y = objectView->contentsY();
  QSCObject *current_object =  objectView->currentItem() ? dynamic_cast<KSObjectTreeListItem*>(objectView->currentItem())->object() : NULL;
  objectView->clear();
  if ( m_page )
  for( int i=0; i<m_page->objects()->count(); i++ ) {
	add_object_to_the_list( m_page->objects()->object(i) );
	}
  update_selection();
  update_current_item( current_object );
  objectView->setContentsPos(pos_x,pos_y);
 }

//--------------------------------------------------------------------------//

void KSObjectTreePanel::add_object_to_the_list( QSCObject *object, QListViewItem *parent )
 {
  KSObjectTreeListItem *curr_item = NULL;
  if ( parent ) curr_item = new KSObjectTreeListItem( parent, object );
	   else curr_item = new KSObjectTreeListItem( objectView, object );

  if ( dynamic_cast<QSCGroup*>(object) ) {
	QSCGroup *curr_group = dynamic_cast<QSCGroup*>(object);
	for( int i=0; i<curr_group->objects()->count(); i++ ) {
		add_object_to_the_list( curr_group->objects()->object(i), curr_item );
		}
	}

  objectView->setOpen( curr_item, true );
 }

//--------------------------------------------------------------------------//

void KSObjectTreePanel::update_selection()
 {
  KSObjectTreeListItem *citem = dynamic_cast<KSObjectTreeListItem*>(objectView->firstChild());
  while ( citem ) {
	 if ( m_view->selection()->contains(citem->object()) ) citem->setSelected( true );
							  else citem->setSelected( false );
         citem = dynamic_cast<KSObjectTreeListItem*>(citem->itemBelow());
        }
  objectView->triggerUpdate();
 }

//--------------------------------------------------------------------------//

void KSObjectTreePanel::update_current_item( QSCObject *object )
 {
  KSObjectTreeListItem *citem = dynamic_cast<KSObjectTreeListItem*>(objectView->firstChild());
  while ( citem ) {
	 if ( citem->object() == object ) {
		objectView->setCurrentItem( citem );
		break;
		}
         citem = dynamic_cast<KSObjectTreeListItem*>(citem->itemBelow());
        }
 }

//--------------------------------------------------------------------------//




