/***************************************************************************
                          ksexportpicturedlg.h  -  description
                             -------------------
    begin                : Tue May 29 2001
    copyright            : (C) 2001 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSEXPORTPICTUREDLG_H
#define KSEXPORTPICTUREDLG_H

#include <qwidget.h>
#include <qstring.h>
#include <qstringlist.h>
#include "ksexportpicturedlginterf.h"
class QFile;
class QProcess;
class QSPlotView;

/**
  *@author kamil
  */
class KSExportPictureDlg : public KSExportPictureDlgInterf  {
   Q_OBJECT
 public:
	KSExportPictureDlg( QSPlotView *view, const char *name=0);
	virtual ~KSExportPictureDlg();

 public slots:
	virtual void exportPicture();
	virtual void browseFilename();
	virtual void changeImageSize( const QString& );
	virtual void setFullPage( bool );
	void slotReceivedOutput ();
	void slotProcessExited();

 protected:
	QSPlotView *m_view;
	QProcess *m_curr_process;
	QFile *m_curr_temp_file;
	static QString m_file_name;
 	static int m_file_format;
	static double m_file_dpi;
	static int m_pixmap_format;
	static int m_pixmap_quality;
	static bool m_pixmap_smooth;
	static int m_metafile_format;
        static double m_input_x;
        static double m_input_y;
        static double m_input_width;
	static double m_input_height;
        static bool m_input_full_page;
	static int m_user_gs_device;
        static int m_user_imagick_device;
	static int m_user_command;
	static QStringList m_user_commands;
        static QString m_user_curr_command;
	
	void clean_up();
};

#endif
