/***************************************************************************
                                kschannellist.h
                             -------------------                                         
    begin                : 01-January-2000
    copyright            : (C) 2000 by Kamil Dobkowski                         
    email                : kamildobk@poczta.onet.pl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KSCHANNELLIST_H
#define KSCHANNELLIST_H


#include"../widgets/qsdata.h"
#include<qobject.h>
#include<qstring.h>
#include<qguardedptr.h>
#include<qlistview.h>

class KSChannelListItem : public QListViewItem {
           public:

            KSChannelListItem( QListView* parent, QSData* object, int channel, QString c1, QString description )
            : QListViewItem( parent, c1 ), m_data(object), m_channel(channel), m_description(description) {}

            KSChannelListItem( QListView* parent, QSData* object, int channel, QString c1, QString c2, QString description )
            : QListViewItem( parent, c1, c2 ), m_data(object), m_channel(channel), m_description(description) {}

            KSChannelListItem( QListViewItem* parent, QSData* object, int channel, QString c1, QString c2, QString description )
            : QListViewItem( parent, c1, c2 ), m_data(object), m_channel(channel), m_description(description) {}

            virtual ~KSChannelListItem() {}
            QSData *dataObject() const { return m_data; }
	    int channel() const { return m_channel; }
	    bool isValid() const { return m_channel>=0 && m_data; }
	    KSChannelListItem *next() { return dynamic_cast<KSChannelListItem*>(itemBelow()); }
		
	    QSData *m_data;
	    int m_channel;
	    QString m_description;
           };


//--------------------------------------------------------------------------------------------------------//

class QSPlot;

/**
  * Smart list view, wchich display matrix list.
  * It tracks QSData object state so can be used in non-modal dialogs.
  * Displays all tree hierarchy of QSAxes.
  * @author Kamil Dobkowski
  */
class KSChannelList : public QListView
 {
  Q_OBJECT

  public:
    /**
      * Constructor.
      */
    KSChannelList( QWidget *parent, const char *name = 0 );
    /**
      * Destructor.
      */
   ~KSChannelList();
    /**
      *  Data object and all its childeren will be showed in list window.
      */
    void setDataObject( QSData *data, bool showAllChannels = true, int defaultChannel = -1, bool showRoot = true );
    /**
      *
      */
    QSData *dataObject() const { return m_data; }
    /**
      *
      */
    KSChannelListItem *first() const { return dynamic_cast<KSChannelListItem*>(firstChild()); }
    /**
      *
      */
    KSChannelListItem *selected() const { return dynamic_cast<KSChannelListItem*>(selectedItem()); }
    /**
      *
      */
    void select( QSData *dataObject, int channel );

  signals:
    void sigShowText( const QString& );
    void sigDataChanged( QSData *object, int channel );

  private slots:
    void slot_refresh_contents();
    void slot_refresh_list(QSData*,int);
    void slot_show_description();
    void slot_refresh_list( QSData *object, const char *newName );

  private:
    void add_qsdata_object_to_list( QSData *data );
    QGuardedPtr<QSData> m_data;
    QSData *prev_selected_data;
    int     prev_selected_channel;
    bool m_show_all_channels;
    bool m_show_root;
    int m_default_channel;

 };

#endif







